<?php


/**
 * Recent Post Widget
 */
class falar_posts_thumbs extends WP_Widget {

    function __construct(){
        $widget_ops = array('description' => esc_html__('Display Random or Recent posts with a small image.', 'falar-toolkit'));
        parent::__construct( false, esc_html__('Falar Recent Posts', 'falar-toolkit'), $widget_ops);
    }

    function widget($args, $instance){
        global $falar_theme, $falar_opt;
        extract($args); //it receives an associative array

        $title = apply_filters('widget_title', $instance['title']);
        $args = array(
            'posts_per_page' => $instance['number'],
            'post_type' => 'post',
            'order' => 'DESC',
            'orderby' => $instance['orderby']
        );
        $query = new WP_Query($args);

        if( !$query->have_posts() ) return;
        echo $before_widget;
        if($title) echo $before_title.$title.$after_title;
        if(!$instance['number']) $instance['number'] = 4;

        if($query->have_posts()):
            $c = 0;

            while($query->have_posts()): $query->the_post(); ?>
                <?php
                $class = 'item';
                $post_id = get_the_ID();
                $thumb_size = 'falar_widget_thumb';
                ?>
                <?php if( !has_post_thumbnail() ) $class .= ' no-thumb'; ?>
                <article <?php post_class($class); ?>>

                    <div class="blog-article-item">
                    <?php
                        $categories = get_the_category();
                        if ($categories) {
                            echo '<ul class="ps-0 mb-0 list-unstyled cat">';
                            foreach ($categories as $category) {
                                echo '<li><a href="' . esc_url(get_category_link($category->term_id)) . '">' . esc_html($category->name) . '</a></li>';
                            }
                            echo '</ul>';
                        }
				    ?>
                        <h3 class="title usmall"><a href="<?php the_permalink(); ?>"><?php echo wp_trim_words( get_the_title(), 10, '' );?> </a></h3>
                        <ul class="ps-0 mb-0 list-unstyled article-list">
                            <li class="d-inline-block">
                                <?php echo esc_html(get_the_date()); ?>
                            </li>
                            <li>
                                <?php echo esc_html(falar_post_reading_time()); ?>
                            </li>
                        </ul>
                    </div>

                    <div class="clear"></div>
                </article>
            <?php
            endwhile;
            wp_reset_postdata();
        endif;
        echo $after_widget;
    }

    function update($new_instance, $old_instance){
        $instance = $old_instance;
        $instance['title'] = strip_tags($new_instance['title']);
        $instance['number'] = (int) $new_instance['number'];
        $instance['orderby'] = $new_instance['orderby'];
        return $instance;
    }

    function form($instance){
        $defaults = array(
            'title' => 'Recent posts',
            'number' => 4,
            'orderby' => 'date'
        );
        $instance = wp_parse_args((array)$instance, $defaults);
        $number = isset( $instance['number'] ) ? absint( $instance['number'] ) : 4;
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>">
                <?php esc_html_e('Title:', 'falar-toolkit'); ?>
                <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $instance['title']; ?>" />
            </label>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('number'); ?>"><?php esc_html_e( 'Number of posts to show:', 'falar-toolkit'); ?></label>
            <input id="<?php echo $this->get_field_id('number'); ?>" name="<?php echo $this->get_field_name('number'); ?>" type="text" value="<?php echo $number; ?>" size="3" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('orderby'); ?>"><?php esc_html_e('Mode:', 'falar-toolkit') ?> </label>
            <select id="<?php echo $this->get_field_id('orderby'); ?>" name="<?php echo $this->get_field_name('orderby'); ?>">
                <option <?php if ($instance['orderby'] == 'date') echo 'selected="selected"'; ?> value="date"><?php esc_html_e('Recent Posts', 'falar-toolkit'); ?></option>
                <option <?php if ($instance['orderby'] == 'rand') echo 'selected="selected"'; ?> value="rand"><?php esc_html_e('Random Posts', 'falar-toolkit'); ?></option>
                <?php if( function_exists('get_field') ): // By views ?>
                    <option <?php if ($instance['orderby'] == 'views') echo 'selected="selected"'; ?> value="views"><?php esc_html_e('Post views', 'falar-toolkit'); ?></option>
                <?php endif; ?>
            </select>
        </p>
        <?php
    }

}

function falar_register_posts_thumbs() {
    register_widget('falar_posts_thumbs');
}

add_action('widgets_init', 'falar_register_posts_thumbs');


/**
 * Footer Info Widget
 */
class falar_footer_info extends WP_Widget{

    function __construct(){
        $widget_ops = array('description' => esc_html__('Display Footer Info', 'falar-toolkit'));
        parent::__construct( false, esc_html__('Falar Footer Info', 'falar-toolkit'), $widget_ops);
    }

    function widget($args, $instance){
        extract($args);
        global $falar_opt;

        // Main site logo
        if(isset($falar_opt['footer_logo1']['url'])):
            $logo1 	= $falar_opt['footer_logo1']['url'];
        else:
            $logo1	= '';
        endif;

        if(isset($falar_opt['footer_logo2']['url'])):
            $logo2 	= $falar_opt['footer_logo2']['url'];
        else:
            $logo2	= '';
        endif;

        if(isset($falar_opt['footer_logo3']['url'])):
            $logo3 	= $falar_opt['footer_logo3']['url'];
        else:
            $logo3	= '';
        endif;
        
        echo $before_widget;
            if($logo1): ?>
                <div class="widget-logo">
                    <a href="<?php echo esc_url( home_url( '/' ) ); ?>">
                        <img class="logo" src="<?php echo esc_url($falar_opt['footer_logo1']['url']); ?>" alt="<?php bloginfo( 'name' ); ?>">
                    </a>
                </div>
            <?php endif;
        ?>
        <?php if( $instance['fot_content'] != '' ): ?>
            <p><?php echo $instance['fot_content']; ?></p>
        <?php endif; ?>
        <?php if( $instance['g_map'] != '' ): ?>
            <div class="location">
                <i class="ri-map-2-line"></i>
                <?php echo $instance['map_con_one']; ?> <a href="<?php echo $instance['g_map']; ?>" target="_blank"><?php echo $instance['map_con_two']; ?></a>
            </div>
        <?php endif; ?>

        <?php
        echo $after_widget;
    }

    function update($new_instance, $old_instance){
        $instance                    = $old_instance;
        $instance['title']           = strip_tags($new_instance['title']);
        $instance['fot_content']     = $new_instance['fot_content'];
        $instance['map_con_one']     = $new_instance['map_con_one'];
        $instance['g_map']           = $new_instance['g_map'];
        $instance['map_con_two']     = $new_instance['map_con_two'];
        return $instance;
    }

    function form($instance){
        $defaults = array(
            'title'             => 'Falar',
            'fot_content'       =>  'Lorem ipsum dolor sit amet consectetur. Neque in maecenas risus et imperdiet gravida. Tortor facilisis maecenas.',   
            'map_con_one'       =>  'Location view on',   
            'g_map'             =>  'https://www.google.com/maps',   
            'map_con_two'       =>  'Google Map',   
        );
        $instance = wp_parse_args((array)$instance, $defaults);
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>">
                <?php esc_html_e('Title:', 'falar-toolkit'); ?>
                <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $instance['title']; ?>" />
            </label>
        </p>

        <p>
            <label for="<?php echo $this->get_field_id('fot_content'); ?>">
                <?php esc_html_e('Footer Content', 'falar-toolkit'); ?>
                <input class="widefat" id="<?php echo $this->get_field_id('fot_content'); ?>" name="<?php echo $this->get_field_name('fot_content'); ?>" type="text" value="<?php echo $instance['fot_content']; ?>" />
            </label>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('map_con_one'); ?>">
                <?php esc_html_e('Map Content One', 'falar-toolkit'); ?>
                <input class="widefat" id="<?php echo $this->get_field_id('map_con_one'); ?>" name="<?php echo $this->get_field_name('map_con_one'); ?>" type="text" value="<?php echo $instance['map_con_one']; ?>" />
            </label>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('g_map'); ?>">
                <?php esc_html_e('Google Map Url', 'falar-toolkit'); ?>
                <input class="widefat" id="<?php echo $this->get_field_id('g_map'); ?>" name="<?php echo $this->get_field_name('g_map'); ?>" type="text" value="<?php echo $instance['g_map']; ?>" />
            </label>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('map_con_two'); ?>">
                <?php esc_html_e('Map Content Two', 'falar-toolkit'); ?>
                <input class="widefat" id="<?php echo $this->get_field_id('map_con_two'); ?>" name="<?php echo $this->get_field_name('map_con_two'); ?>" type="text" value="<?php echo $instance['map_con_two']; ?>" />
            </label>
        </p>

        <?php
    }

}

function falar_register_footer_info() {
    register_widget('falar_footer_info');
}

add_action('widgets_init', 'falar_register_footer_info');



/**
 * Footer Social Widget
 */
class falar_footer_contact_info extends WP_Widget{

    function __construct(){
        $widget_ops = array('description' => esc_html__('Display Footer Contact Info', 'falar-toolkit'));
        parent::__construct( false, esc_html__('Falar Footer Contact Info', 'falar-toolkit'), $widget_ops);
    }

    function widget($args, $instance){
        extract($args);
        global $falar_opt;


        $title  = apply_filters('widget_title', $instance['title']);

        echo $before_widget;
        if($title) echo $before_title.$title.$after_title;
        ?>

        <ul class="info-list">
            <li>
                <?php if( $instance['icon1'] != '' ): ?>
                    <div class="icon">
                        <i class="<?php echo $instance['icon1']; ?>"></i>
                    </div>
                <?php endif; ?>

                <?php if( $instance['address'] != '' ): ?>
                    <span><?php echo $instance['address']; ?></span>
                <?php endif; ?>
            </li>
            <li>
                <?php if( $instance['icon2'] != '' ): ?>
                    <div class="icon">
                        <i class="<?php echo $instance['icon2']; ?>"></i>
                    </div>
                <?php endif; ?>
                <?php if( $instance['phoneNo'] != '' ): ?>
                    <a href="tel:<?php echo $instance['phoneNo']; ?>"><?php echo $instance['phoneNo']; ?></a>
                <?php endif; ?>
            </li>
            <li>
                <?php if( $instance['icon3'] != '' ): ?>
                    <div class="icon">
                        <i class="<?php echo $instance['icon3']; ?>"></i>
                    </div>
                <?php endif; ?>
                <?php if( $instance['email'] != '' ): ?>
                    <a href="mailto:<?php echo $instance['email']; ?>"><?php echo $instance['email']; ?></a>
                <?php endif; ?>
            </li>
        </ul>

        <?php
        echo $after_widget;
    }

    function update($new_instance, $old_instance){
        $instance                  = $old_instance;
        $instance['title']         = strip_tags($new_instance['title']);
        $instance['icon1']         = $new_instance['icon1'];
        $instance['icon2']         = $new_instance['icon2'];
        $instance['icon3']         = $new_instance['icon3'];
        $instance['address']       = $new_instance['address'];
        $instance['phoneNo']       = $new_instance['phoneNo'];
        $instance['email']         = $new_instance['email'];
        
        return $instance;
    }

    function form($instance){
        $defaults = array(
            'title'             => 'Get in Touch',
            'icon1'             =>  'Location Icon',     
            'icon2'             =>  'Phone Icon',     
            'icon3'             =>  'Mail Icon',     
            'address'           =>  '2750 Quadra Street Victoria Road, New York, Canada',
            'phoneNo'           =>  '+14854560102',
            'email'             =>  'support@falar.com',
        );
        $instance = wp_parse_args((array)$instance, $defaults);
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>">
                <?php esc_html_e('Title:', 'falar-toolkit'); ?>
                <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $instance['title']; ?>" />
            </label>
        </p>

        <p>
            <label for="<?php echo $this->get_field_id('icon1'); ?>">
                <?php esc_html_e('Icon One:', 'falar-toolkit'); ?>
                <input class="widefat" id="<?php echo $this->get_field_id('icon1'); ?>" name="<?php echo $this->get_field_name('icon1'); ?>" type="text" value="<?php echo $instance['icon1']; ?>" />
            </label>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('icon2'); ?>">
                <?php esc_html_e('Icon Two:', 'falar-toolkit'); ?>
                <input class="widefat" id="<?php echo $this->get_field_id('icon2'); ?>" name="<?php echo $this->get_field_name('icon2'); ?>" type="text" value="<?php echo $instance['icon2']; ?>" />
            </label>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('icon3'); ?>">
                <?php esc_html_e('Icon Three:', 'falar-toolkit'); ?>
                <input class="widefat" id="<?php echo $this->get_field_id('icon3'); ?>" name="<?php echo $this->get_field_name('icon3'); ?>" type="text" value="<?php echo $instance['icon3']; ?>" />
            </label>
        </p>

        <p>
            <label for="<?php echo $this->get_field_id('address'); ?>">
                <?php esc_html_e('Address:', 'falar-toolkit'); ?>
                <input class="widefat" id="<?php echo $this->get_field_id('address'); ?>" name="<?php echo $this->get_field_name('address'); ?>" type="text" value="<?php echo $instance['address']; ?>" />
            </label>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('phoneNo'); ?>">
                <?php esc_html_e('Phone No:', 'falar-toolkit'); ?>
                <input class="widefat" id="<?php echo $this->get_field_id('phoneNo'); ?>" name="<?php echo $this->get_field_name('phoneNo'); ?>" type="text" value="<?php echo $instance['phoneNo']; ?>" />
            </label>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('email'); ?>">
                <?php esc_html_e('Email Address:', 'falar-toolkit'); ?>
                <input class="widefat" id="<?php echo $this->get_field_id('email'); ?>" name="<?php echo $this->get_field_name('email'); ?>" type="text" value="<?php echo $instance['email']; ?>" />
            </label>
        </p>

        <?php
    }

}

function falar_register_footer_contact_info() {
    register_widget('falar_footer_contact_info');
}

add_action('widgets_init', 'falar_register_footer_contact_info');


/**
 * Newsletter Widget
 */
class falar_newsletter extends WP_Widget{
    function __construct(){
        $widget_ops = array('description' => esc_html__('Display Contact Info', 'falar-toolkit'));
        parent::__construct( false, esc_html__('Falar Footer Newsletter', 'falar-toolkit'), $widget_ops);
    }

    function widget($args, $instance){
        extract($args);

        global $falar_opt;

        // Main site logo
        if(isset($falar_opt['footer_logo1']['url'])):
            $logo1 	= $falar_opt['footer_logo1']['url'];
        else:
            $logo1	= '';
        endif;

        if(isset($falar_opt['footer_logo2']['url'])):
            $logo2 	= $falar_opt['footer_logo2']['url'];
        else:
            $logo2	= '';
        endif;

        if(isset($falar_opt['footer_logo3']['url'])):
            $logo3 	= $falar_opt['footer_logo3']['url'];
        else:
            $logo3	= '';
        endif;

        $title  = apply_filters('widget_title', $instance['title']);
        echo $before_widget;
        ?>
            
            <?php if( $instance['title'] != '' ): ?>
                <h3><?php echo $instance['title']; ?></h3>
            <?php endif; ?>
            <div class="footer-form">
                <?php if( $instance['email_url'] != '' ): ?>
                    <form class="footer-input input-box mailchimp newsletter-form" method="post">
                        <div class="form-group">
                            <input type="email" class="form-control input-newsletter memail" placeholder="<?php echo esc_attr($instance['email_placeholder']); ?>" name="EMAIL" required>
                            <?php if( $instance['newsletter_button_text'] != '' ): ?>
                                <button type="submit" class="footer-btn"><?php echo $instance['newsletter_button_text']; ?> <i class="ti ti-arrow-narrow-right"></i></button>
                            <?php endif; ?>
                            
                            <div class="mchimp-errmessage alert alert-danger" style="display: none;"></div>
                            <div class="mchimp-sucmessage alert alert-primary" style="display: none;"></div>
                        </div>
                    </form>
                <?php endif; ?>
            </div>
            <ul class="footer-logos">
                <?php if($logo1): ?>
                    <li>
                        <img src="<?php echo esc_url($falar_opt['footer_logo1']['url']); ?>" alt="image">
                    </li>
                <?php endif; ?>
                <?php if($logo2): ?>
                    <li>
                        <img src="<?php echo esc_url($falar_opt['footer_logo2']['url']); ?>" alt="image">
                    </li>
                <?php endif; ?>
                <?php if($logo3): ?>
                    <li>
                        <img src="<?php echo esc_url($falar_opt['footer_logo3']['url']); ?>" alt="image">
                    </li>
                <?php endif; ?>
            </ul>
        <script>
            ;(function($){
                "use strict";
                $(document).ready(function () {
                    // MAILCHIMP
                    $(".mailchimp").ajaxChimp({
                        callback: mailchimpCallback,
                        url: "<?php echo esc_js($instance['email_url']) ?>"
                    });
                    $(".memail").on("focus", function () {
                        $(".mchimp-errmessage").fadeOut();
                        $(".mchimp-sucmessage").fadeOut();
                    });
                    $(".memail").on("keydown", function () {
                        $(".mchimp-errmessage").fadeOut();
                        $(".mchimp-sucmessage").fadeOut();
                    });
                    $(".memail").on("click", function () {
                        $(".memail").val("");
                    });

                    function mailchimpCallback(resp) {
                        if (resp.result === "success") {
                            $(".mchimp-sucmessage").html(resp.msg).fadeIn(1000);
                            $(".mchimp-sucmessage").fadeOut(3000);
                        } else if (resp.result === "error") {
                            $(".mchimp-errmessage").html(resp.msg).fadeIn(1000);
                        }
                    }
                });
            })(jQuery)
        </script>

        <?php
        echo $after_widget;
    }

    function update($new_instance, $old_instance){
        $instance                           = $old_instance;
        $instance['title']                  = $new_instance['title'];
        $instance['email_url']              = $new_instance['email_url'];
        $instance['email_placeholder']      = $new_instance['email_placeholder'];
        $instance['newsletter_button_text'] = $new_instance['newsletter_button_text'];
        return $instance;
    }

    function form($instance){
        $defaults = array(
            'title'                        => 'Subscribe Newsletter',
            'email_url'                    => 'https://envytheme.us13.list-manage.com/subscribe/post?u=1f4dcefed57b9c394873f34d2&id=b093890ff6',
            'social'                       => '',
            'email_placeholder'            => 'Enter Email Address',
            'newsletter_button_text'       => 'Subscribe Now ',
        );
        $instance = wp_parse_args((array)$instance, $defaults);
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>">
                <?php esc_html_e('Title:', 'falar-toolkit'); ?>
                <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $instance['title']; ?>" />
            </label>
        </p>

        <p>
            <label for="<?php echo $this->get_field_id('email_url'); ?>">
                <?php esc_html_e('Action URL:', 'falar-toolkit'); ?>
                <input class="widefat" id="<?php echo $this->get_field_id('email_url'); ?>" name="<?php echo $this->get_field_name('email_url'); ?>" type="text" value="<?php echo $instance['email_url']; ?>" />
            </label>
            <i>Enter here your MailChimp action URL. <a href="https://www.docs.envytheme.com/docs/falar-theme-documentation/tips-guides-troubleshoots/get-mailchimp-newsletter-form-action-url/" target="_blank"> How to </a></i>
        </p>

        <p>
            <label for="<?php echo $this->get_field_id('email_placeholder'); ?>">
                <?php esc_html_e('Placeholder Title:', 'falar-toolkit'); ?>
                <input class="widefat" id="<?php echo $this->get_field_id('email_placeholder'); ?>" name="<?php echo $this->get_field_name('email_placeholder'); ?>" type="text" value="<?php echo $instance['email_placeholder']; ?>" />
            </label>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('newsletter_button_text'); ?>">
                <?php esc_html_e('Newsletter Button Text:', 'falar-toolkit'); ?>
                <input class="widefat" id="<?php echo $this->get_field_id('newsletter_button_text'); ?>" name="<?php echo $this->get_field_name('newsletter_button_text'); ?>" type="text" value="<?php echo $instance['newsletter_button_text']; ?>" />
            </label>
        </p>
        
        <?php
    }

}

function falar_register_newsletter() {
    register_widget('falar_newsletter');
}

add_action('widgets_init', 'falar_register_newsletter');



