<?php
    /**
     * ReduxFramework Sample Config File
     * For full documentation, please visit: http://docs.reduxframework.com/
     */

    if ( ! class_exists( 'Redux' ) ) {
        return;
    }

    // This is your option name where all the Redux data is stored.
    $opt_name = FALAR_FRAMEWORK_VAR;

    // This line is only for altering the demo. Can be easily removed.
    $opt_name = apply_filters( 'opt_name/opt_name', $opt_name );

    // Used within different fields. Simply examples. Search for ACTUAL DECLARATION for field examples
    $sampleHTML = '';
    if ( file_exists( dirname( __FILE__ ) . '/info-html.html' ) ) {
        Redux_Functions::initWpFilesystem();

        global $wp_filesystem;

        $sampleHTML = $wp_filesystem->get_contents( dirname( __FILE__ ) . '/info-html.html' );
    }

    // Background Patterns Reader
    $sample_patterns_path = ReduxFramework::$_dir . '../sample/patterns/';
    $sample_patterns_url  = ReduxFramework::$_url . '../sample/patterns/';
    $sample_patterns      = array();

    if ( is_dir( $sample_patterns_path ) ) {
        if ( $sample_patterns_dir = opendir( $sample_patterns_path ) ) {
            $sample_patterns = array();
            while ( ( $sample_patterns_file = readdir( $sample_patterns_dir ) ) !== false ) {
                if ( stristr( $sample_patterns_file, '.png' ) !== false || stristr( $sample_patterns_file, '.jpg' ) !== false ) {
                    $name              = explode( '.', $sample_patterns_file );
                    $name              = str_replace( '.' . end( $name ), '', $sample_patterns_file );
                    $sample_patterns[] = array(
                        'alt' => $name,
                        'img' => $sample_patterns_url . $sample_patterns_file
                    );
                }
            }
        }
    }

    // All the possible arguments for Redux.
    $theme = wp_get_theme(); // For use with some settings. Not necessary.
    $args = array(
        // TYPICAL -> Change these values as you need/desire
        'opt_name'             => $opt_name,
        // This is where your data is stored in the database and also becomes your global variable name.
        'display_name'         => $theme->get( 'Name' ),
        // Name that appears at the top of your panel
        'display_version'      => $theme->get( 'Version' ),
        // Version that appears at the top of your panel
        'menu_type'            => 'menu',
        //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
        'allow_sub_menu'       => true,
        // Show the sections below the admin menu item or not
        'menu_title'           => __( 'Theme Options', 'falar-toolkit' ),
        'page_title'           => __( 'Theme Options', 'falar-toolkit' ),
        // You will need to generate a Google API key to use this feature.
        // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
        'google_api_key'       => '',
        // Set it you want google fonts to update weekly. A google_api_key value is required.
        'google_update_weekly' => false,
        // Must be defined to add google fonts to the typography module
        'async_typography'     => false,
        // Use a asynchronous font on the front end or font string
        //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
        'admin_bar'            => true,
        // Show the panel pages on the admin bar
        'admin_bar_icon'       => 'dashicons-team',
        // Choose an icon for the admin bar menu
        'admin_bar_priority'   => 50,
        // Choose an priority for the admin bar menu
        'global_variable'      => '',
        // Set a different name for your global variable other than the opt_name
        'dev_mode'             => false,
        // Show the time the page took to load, etc
        'update_notice'        => false,
        // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
        'customizer'           => true,
        // Enable basic customizer support
        //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
        //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field

        // OPTIONAL -> Give you extra features
        'page_priority'        => 90,
        // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
        'page_parent'          => 'themes.php',
        // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
        'page_permissions'     => 'manage_options',
        // Permissions needed to access the options panel.
        'menu_icon'            => '',
        // Specify a custom URL to an icon
        'last_tab'             => '',
        // Force your panel to always open to a specific tab (by id)
        'page_icon'            => 'icon-themes',
        // Icon displayed in the admin panel next to your menu_title
        'page_slug'            => 'opt_nameion',
        // Page slug used to denote the panel, will be based off page title then menu title then opt_name if not provided
        'save_defaults'        => true,
        // On load save the defaults to DB before user clicks save or not
        'default_show'         => false,
        // If true, shows the default value next to each field that is not the default value.
        'default_mark'         => '',
        // What to print by the field's title if the value shown is default. Suggested: *
        'show_import_export'   => true,
        // Shows the Import/Export panel when not used as a field.

        // CAREFUL -> These options are for advanced use only
        'transient_time'       => 60 * MINUTE_IN_SECONDS,
        'output'               => true,
        // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
        'output_tag'           => true,
        // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
        // 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.

        // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
        'database'             => '',
        // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
        'use_cdn'              => true,
        // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.

        // HINTS
        'hints'                => array(
            'icon'          => 'el el-question-sign',
            'icon_position' => 'right',
            'icon_color'    => 'lightgray',
            'icon_size'     => 'normal',
            'tip_style'     => array(
                'color'   => 'red',
                'shadow'  => true,
                'rounded' => false,
                'style'   => '',
            ),
            'tip_position'  => array(
                'my' => 'top left',
                'at' => 'bottom right',
            ),
            'tip_effect'    => array(
                'show' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'mouseover',
                ),
                'hide' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'click mouseleave',
                ),
            ),
        )
    );

    // Panel Intro text -> before the form
    if ( ! isset( $args['global_variable'] ) || $args['global_variable'] !== false ) {
        if ( ! empty( $args['global_variable'] ) ) {
            $v = $args['global_variable'];
        } else {
            $v = str_replace( '-', '_', $args['opt_name'] );
        }
        $args['intro_text'] = sprintf( __( '<p></p>', 'falar-toolkit' ), $v );
    } else {
        $args['intro_text'] = __( '<p>This text is displayed above the options panel. It isn\'t required, but more info is always better! The intro_text field accepts all HTML.</p>', 'falar-toolkit' );
    }
    Redux::setArgs( $opt_name, $args );
    // END ARGUMENTS


    // Set the help sidebar
    $content = __( '<p>This is the sidebar content, HTML is allowed.</p>', 'falar-toolkit' );
    Redux::set_help_sidebar( $opt_name, $content );

// General Options
Redux::setSection( $opt_name, array(
    'title'             => esc_html__( 'General Options', 'falar-toolkit' ),
    'id'                => 'general_options',
    'customizer'        => false,
    'icon'              => ' el el-home',
    'fields'     => array(
        array(
            'id'       => 'main_logo',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'Site Logo', 'falar-toolkit' ),
          
            'desc'     => esc_html__( 'Recommended sizes - width: 140px, height: 45px.', 'falar-toolkit' ),
        ),
        array(
            'id'       => 'main_logo2',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'Site Logo Two', 'falar-toolkit' ),
          
            'desc'     => esc_html__( 'Recommended sizes - width: 140px, height: 45px.', 'falar-toolkit' ),
        ),
        array(
            'id'       => 'main_logo3',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'Site Logo Three', 'falar-toolkit' ),
          
            'desc'     => esc_html__( 'Recommended sizes - width: 140px, height: 45px.', 'falar-toolkit' ),
        ),
        array(
            'id'       => 'main_logo4',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'Site Logo Four', 'falar-toolkit' ),
          
            'desc'     => esc_html__( 'Recommended sizes - width: 170px, height: 50px.', 'falar-toolkit' ),
        ),
        array(
            'id'       => 'main_logo5',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'Site Logo Five', 'falar-toolkit' ),
          
            'desc'     => esc_html__( 'Recommended sizes - width: 185px, height: 50px.', 'falar-toolkit' ),
        ),
        array(
            'id'       => 'search_icon',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'Search Icon', 'falar-toolkit' ),
        ),
        array(
            'id'       => 'menu_icon',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'Menu Icon', 'falar-toolkit' ),
        ),
        array(
			'id'    => 'header_search_placeholder',
            'type'  => 'text',
			'title' => esc_html__('Header Search Placeholder', 'falar-toolkit'),
        ),
        array(
			'id'    => 'mail_address',
            'type'  => 'text',
			'title' => esc_html__('Mail Address', 'falar-toolkit'),
        ),
        array(
			'id'    => 'phone_no',
            'type'  => 'text',
			'title' => esc_html__('Phone No', 'falar-toolkit'),
        ),
        array(
			'id'    => 'top_menu_text1',
            'type'  => 'text',
			'title' => esc_html__('Top Menu Text One', 'falar-toolkit'),
        ),
        array(
			'id'    => 'top_menu_url1',
            'type'  => 'text',
			'title' => esc_html__('Top Menu Url One', 'falar-toolkit'),
        ),
        array(
			'id'    => 'top_menu_text2',
            'type'  => 'text',
			'title' => esc_html__('Top Menu Text Two', 'falar-toolkit'),
        ),
        array(
			'id'    => 'top_menu_url2',
            'type'  => 'text',
			'title' => esc_html__('Top Menu Url Two', 'falar-toolkit'),
        ),
        array(
			'id'    => 'top_menu_text3',
            'type'  => 'text',
			'title' => esc_html__('Top Menu Text Three', 'falar-toolkit'),
        ),
        array(
			'id'    => 'top_menu_url3',
            'type'  => 'text',
			'title' => esc_html__('Top Menu Url Three', 'falar-toolkit'),
        ),
        array(
			'id'    => 'top_menu_text4',
            'type'  => 'text',
			'title' => esc_html__('Top Menu Text Four', 'falar-toolkit'),
        ),
        array(
			'id'    => 'top_menu_url4',
            'type'  => 'text',
			'title' => esc_html__('Top Menu Url Four', 'falar-toolkit'),
        ),
        array(
			'id'    => 'top_button_text',
            'type'  => 'text',
			'title' => esc_html__('Top Button Text', 'falar-toolkit'),
        ),
        array(
			'id'    => 'top_button_url',
            'type'  => 'text',
			'title' => esc_html__('Top Button Url', 'falar-toolkit'),
        ),
        array(
            'id'       => 'sidebar_top_bg',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'Sidebar Top Image', 'falar-toolkit' ),
        ),
        array(
			'id'    => 'sidebar_top_title',
            'type'  => 'text',
			'title' => esc_html__('Sidebar Top Title', 'falar-toolkit'),
        ),
        array(
			'id'    => 'sidebar_top_content',
            'type'  => 'text',
			'title' => esc_html__('Sidebar Top Content', 'falar-toolkit'),
        ),
        array(
			'id'    => 'sidebar_button_text',
            'type'  => 'text',
			'title' => esc_html__('Sidebar Button Text', 'falar-toolkit'),
        ),
        array(
			'id'    => 'sidebar_button_url',
            'type'  => 'text',
			'title' => esc_html__('Sidebar Button Url', 'falar-toolkit'),
        ),
        array(
			'id'    => 'directory_title',
            'type'  => 'text',
			'title' => esc_html__('Directory Title', 'falar-toolkit'),
        ),
        array(
			'id'    => 'directory_list_text1',
            'type'  => 'text',
			'title' => esc_html__('Directory List Text One', 'falar-toolkit'),
        ),
        array(
			'id'    => 'directory_list_url1',
            'type'  => 'text',
			'title' => esc_html__('Directory List Url One', 'falar-toolkit'),
        ),
        array(
			'id'    => 'directory_list_text2',
            'type'  => 'text',
			'title' => esc_html__('Directory List Text Two', 'falar-toolkit'),
        ),
        array(
			'id'    => 'directory_list_url2',
            'type'  => 'text',
			'title' => esc_html__('Directory List Url Two', 'falar-toolkit'),
        ),
        array(
			'id'    => 'directory_list_text3',
            'type'  => 'text',
			'title' => esc_html__('Directory List Text Three', 'falar-toolkit'),
        ),
        array(
			'id'    => 'directory_list_url3',
            'type'  => 'text',
			'title' => esc_html__('Directory List Url Three', 'falar-toolkit'),
        ),
        array(
			'id'    => 'news_title',
            'type'  => 'text',
			'title' => esc_html__('News Title', 'falar-toolkit'),
        ),
        array(
			'id'    => 'top_header_hideshow',
            'type'  => 'switch',
            'title' => esc_html__('Hide Top Hedear', 'falar-toolkit'),
            'default'   => '0'
        ),
        array(
			'id'    => 'sidebar_blog_hideshow',
            'type'  => 'switch',
            'title' => esc_html__('Hide Sidebar Blog Post', 'falar-toolkit'),
            'default'   => '0'
        ),

        array(
            'id' => 'falar_enable_rtl',
            'type' => 'select',
            'options' => array(
                'enable'        => 'Enable',
                'disable'       => 'Disable',
            ),
            'title'     => esc_html__( 'RTL', 'falar-toolkit' ),
            'default'   => 'disable',
        ),
        
    ),
) );

// Preloader Options
Redux::setSection( $opt_name, array(
    'title'            => esc_html__( 'Preloader', 'falar-toolkit' ),
    'id'               => 'preloader_opt',
    'customizer'        => false,
    'icon'             => 'dashicons dashicons-controls-repeat',
    'fields'           => array(

        array(
            'id'      => 'enable_preloader',
            'type'    => 'switch',
            'title'   => esc_html__( 'Pre-loader', 'falar-toolkit' ),
            'on'      => esc_html__( 'Enable', 'falar-toolkit' ),
            'off'     => esc_html__( 'Disable', 'falar-toolkit' ),
            'default' => true,
        ),

        array(
            'required' => array( 'enable_preloader', '=', '1' ),
            'id'       => 'preloader_style',
            'type'     => 'select',
            'title'    => esc_html__( 'Pre-loader Style', 'falar-toolkit' ),
            'default'   => 'circle-spin',
            'options'  => array(
                'circle-spin'   => esc_html__( 'Spin Preloader', 'falar-toolkit' ),
                'text'          => esc_html__( 'Text Preloader', 'falar-toolkit' ),
                'image'         => esc_html__( 'Image Preloader', 'falar-toolkit' )
            )
        ),

        /**
         * Text Preloader
         */
        array(
            'title'     => esc_html__( 'Color', 'falar-toolkit' ),
            'id'        => 'preloader_color',
            'type'      => 'color',
            'output'    => array( '.preloader-area .waviy' ),
            'required'  => array( 'preloader_style', '=', 'text' ),
        ),
        array(
            'id'       => 'loading_text',
            'type'     => 'text',
            'title'    => esc_html__( 'Loading Letter One', 'falar-toolkit' ),
            'default'  => esc_html__( 'L', 'falar-toolkit' ),
            'required' => array( 'preloader_style', '=', 'text' ),
        ),
        array(
            'id'       => 'loading_text2',
            'type'     => 'text',
            'title'    => esc_html__( 'Loading Letter Two', 'falar-toolkit' ),
            'default'  => esc_html__( 'O', 'falar-toolkit' ),
            'required' => array( 'preloader_style', '=', 'text' ),
        ),
        array(
            'id'       => 'loading_text3',
            'type'     => 'text',
            'title'    => esc_html__( 'Loading Letter Three', 'falar-toolkit' ),
            'default'  => esc_html__( 'A', 'falar-toolkit' ),
            'required' => array( 'preloader_style', '=', 'text' ),
        ),
        array(
            'id'       => 'loading_text4',
            'type'     => 'text',
            'title'    => esc_html__( 'Loading Letter Four', 'falar-toolkit' ),
            'default'  => esc_html__( 'D', 'falar-toolkit' ),
            'required' => array( 'preloader_style', '=', 'text' ),
        ),
        array(
            'id'       => 'loading_text5',
            'type'     => 'text',
            'title'    => esc_html__( 'Loading Letter Five', 'falar-toolkit' ),
            'default'  => esc_html__( 'I', 'falar-toolkit' ),
            'required' => array( 'preloader_style', '=', 'text' ),
        ),
        array(
            'id'       => 'loading_text6',
            'type'     => 'text',
            'title'    => esc_html__( 'Loading Letter Six', 'falar-toolkit' ),
            'default'  => esc_html__( 'N', 'falar-toolkit' ),
            'required' => array( 'preloader_style', '=', 'text' ),
        ),
        array(
            'id'       => 'loading_text7',
            'type'     => 'text',
            'title'    => esc_html__( 'Loading Letter Seven', 'falar-toolkit' ),
            'default'  => esc_html__( 'G', 'falar-toolkit' ),
            'required' => array( 'preloader_style', '=', 'text' ),
        ),
        
        array(
            'title'         => esc_html__( 'Loading Text Typography', 'falar-toolkit' ),
            'id'            => 'preloader_small_typo',
            'type'          => 'typography',
            'text-align'    => false,
            'output'        => '.preloader-area .waviy',
            'required' => array( 'preloader_style', '=', 'text' ),
        ),

        /**
         * Image Preloader
         */
        array(
            'required' => array( 'preloader_style', '=', 'image' ),
            'id'       => 'preloader_image',
            'type'     => 'media',
            'title'    => esc_html__( 'Pre-loader image', 'falar-toolkit' ),
            'compiler' => true,
        ),
    )
));

// Page Banner
Redux::setSection( $opt_name, array(
    'title'             => esc_html__( 'Page Banner', 'falar-toolkit' ),
    'id'                => 'banner_options',
    'customizer'        => false,
    'icon'              => 'el el-website',
    'fields'     => array(
        array(
            'id'        => 'page_title_tag',
            'type'      => 'select',
            'title'     => esc_html__( 'Banner Title Tag', 'falar-toolkit' ),
            'options' => array(
                'h1'         => esc_html__( 'h1', 'falar-toolkit' ),
                'h2'         => esc_html__( 'h2', 'falar-toolkit' ),
                'h3'         => esc_html__( 'h3', 'falar-toolkit' ),
                'h4'         => esc_html__( 'h4', 'falar-toolkit' ),
                'h5'         => esc_html__( 'h5', 'falar-toolkit' ),
                'h6'         => esc_html__( 'h6', 'falar-toolkit' ),
            ),
            'default' => 'h2',
            'output'    => '.inner-heros-warp .inner-hero-content h1, .inner-heros-warp .inner-hero-content h2, .inner-heros-warp .inner-hero-content h3, .inner-heros-warp .inner-hero-content h4, .inner-heros-warp .inner-hero-content h5, .inner-heros-warp .inner-hero-content h6'
        ),
        array(
            'id'        => 'title_title_typo',
            'type'      => 'typography',
            'text-align'    => false,
            'title'     => esc_html__( 'Title Typography', 'falar-toolkit' ),
            'output'    => '.inner-heros-warp .inner-hero-content h1, .inner-heros-warp .inner-hero-content h2, .inner-heros-warp .inner-hero-content h3, .inner-heros-warp .inner-hero-content h4, .inner-heros-warp .inner-hero-content h5, .inner-heros-warp .inner-hero-content h6'
        ),
        array(
            'id'        => 'title_desc_typo',
            'type'      => 'typography',
            'text-align'    => false,
            'title'     => esc_html__( 'Breadcumb Typography', 'falar-toolkit' ),
            'output'    => '.inner-heros-warp .inner-hero-content ul li, .inner-heros-warp .inner-hero-content ul li a'
        ),
        array(
            'id'          => 'page_banner_bg',
            'type'        => 'color',
            'title'       => __('Page Banner Background Color', 'falar-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'background' => '.inner-heros-warp',
            ),
            'transparent' => false
        ),
    ),
) );

// Custom Post
Redux::setSection( $opt_name, array(
    'title'         => esc_html__( 'Custom Posts Settings', 'falar-toolkit' ),
    'id'            => 'falar_custom_posts',
    'customizer'    => false,
    'icon'          => 'el el-file-edit',
    'desc'          => 'Manage your events settings.',
    'fields' => array(
        array(
            'id'       => 'events_permalink',
            'type'     => 'text',
            'title'    => esc_html__( 'Single Events Permalink', 'falar-toolkit' ),
            'default'  => esc_html__('events-post', 'falar-toolkit'),
            'desc'     => '<p>After changing the permalink go to <strong style="color:#28a745;">Settings Permalinks</strong> and hit <strong style="color:#28a745;">Save Changes</strong> button.</p>',
        ),

        array(
			'id'    => 'hide_events_banner',
            'type'  => 'switch',
            'title' => esc_html__('Hide Single Events Banner', 'falar-toolkit'),
            'default'   => '0'
        ),
        array(
			'id'    => 'hide_events_title',
            'type'  => 'switch',
			'title' => esc_html__('Hide Single Events Title', 'falar-toolkit'),
            'default'   => '0',
            'required'    => array('hide_events_banner','equals','0'),
        ),
        array(
			'id'    => 'hide_events_breadcrumb',
            'type'  => 'switch',
			'title' => esc_html__('Hide Single Events Breadcrumb', 'falar-toolkit'),
            'default'   => '0',
            'required'    => array('hide_events_banner','equals','0'),
        ),
        array(
            'id'       => 'events_banner_shape',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'Events Banner Shape', 'falar-toolkit' ),
        ),

        array(
            'id'       => 'program_permalink',
            'type'     => 'text',
            'title'    => esc_html__( 'Single Program Permalink', 'falar-toolkit' ),
            'default'  => esc_html__('program-post', 'falar-toolkit'),
            'desc'     => '<p>After changing the permalink go to <strong style="color:#28a745;">Settings Permalinks</strong> and hit <strong style="color:#28a745;">Save Changes</strong> button.</p>',
        ),

        array(
			'id'    => 'hide_program_banner',
            'type'  => 'switch',
            'title' => esc_html__('Hide Single Program Banner', 'falar-toolkit'),
            'default'   => '0'
        ),
        array(
			'id'    => 'hide_program_title',
            'type'  => 'switch',
			'title' => esc_html__('Hide Single Program Title', 'falar-toolkit'),
            'default'   => '0',
            'required'    => array('hide_program_banner','equals','0'),
        ),
        array(
			'id'    => 'hide_program_breadcrumb',
            'type'  => 'switch',
			'title' => esc_html__('Hide Single Program Breadcrumb', 'falar-toolkit'),
            'default'   => '0',
            'required'    => array('hide_program_banner','equals','0'),
        ),
        array(
            'id'       => 'program_banner_shape',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'Program Banner Shape', 'falar-toolkit' ),
        ),



        array(
            'id'       => 'career_permalink',
            'type'     => 'text',
            'title'    => esc_html__( 'Single Career Permalink', 'falar-toolkit' ),
            'default'  => esc_html__('career-post', 'falar-toolkit'),
            'desc'     => '<p>After changing the permalink go to <strong style="color:#28a745;">Settings Permalinks</strong> and hit <strong style="color:#28a745;">Save Changes</strong> button.</p>',
        ),

        array(
			'id'    => 'hide_career_banner',
            'type'  => 'switch',
            'title' => esc_html__('Hide Single Career Banner', 'falar-toolkit'),
            'default'   => '0'
        ),
        array(
			'id'    => 'hide_career_title',
            'type'  => 'switch',
			'title' => esc_html__('Hide Single Career Title', 'falar-toolkit'),
            'default'   => '0',
            'required'    => array('hide_career_banner','equals','0'),
        ),
        array(
			'id'    => 'hide_career_breadcrumb',
            'type'  => 'switch',
			'title' => esc_html__('Hide Single Career Breadcrumb', 'falar-toolkit'),
            'default'   => '0',
            'required'    => array('hide_career_banner','equals','0'),
        ),
        array(
            'id'       => 'career_banner_shape',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'Career Banner Shape', 'falar-toolkit' ),
        ),

    )
));

// WooCommerce Product
Redux::setSection( $opt_name, array(
    'title'         => __( 'WooCommerce Product', 'falar-toolkit' ),
    'desc'          => __( 'Manage product page settings.', 'falar-toolkit' ),
    'icon'          => 'el-icon-list-alt',
    'customizer'    => false,
    'fields' => array(
        
        array(
            'id'        => 'products_page_count',
            'desc'      => __( 'Number of products per page on product pages.', 'falar-toolkit' ),
            'type'      => 'text',
            'title'     => __( 'Products per page', 'falar-toolkit' ),
            'default'   => '6',
        ),
        array(
			'id'    => 'hide_product_banner',
            'type'  => 'switch',
            'title' => esc_html__('Hide Single Product Banner', 'falar-toolkit'),
            'default'   => '0'
        ),
        array(
			'id'    => 'hide_product_breadcrumb',
            'type'  => 'switch',
			'title' => esc_html__('Hide Single Product Breadcrumb', 'falar-toolkit'),
            'default'   => '0',
            'required'    => array('hide_product_banner','equals','0'),
        ),
        array(
            'id'    => 'product_sidebar',
            'type'  => 'select',
            'options' => array(
                'falar_product_no_sidebar'       => 'None',
                'left-sidebar'  => 'Sidebar on the left',
                'right-sidebar' => 'Sidebar on the right',
            ),
            'title'     => __( 'Product Sidebar Position', 'falar-toolkit' ),
            'default'   => 'falar_product_no_sidebar',
        ),
        array(
            'id'        => 'enable_product_meta',
            'type'      => 'switch',
            'title'     => esc_html__('Enable Product Meta', 'falar-toolkit'),
            'default'   => '1'
        ),
        array(
            'id'        => 'des_tab_title',
            'type'      => 'text',
            'default'   => 'Description',
            'title'     => esc_html__('Description Tab Title', 'falar-toolkit'),
        ),
        array(
            'id'        => 'review_tab_title',
            'type'      => 'text',
            'default'   => 'Reviews',
            'title'     => esc_html__('Reviews Tab Title', 'falar-toolkit'),
        ),
    ),
));

// Social Profiles
Redux::setSection( $opt_name, array(
	'title' => esc_html__('Social Profiles', 'falar-toolkit'),
	'desc'  => 'Social profiles are used in different places inside the theme.',
	'icon'  => 'el-icon-user',
	'customizer' => false,
	'fields' => array(
        array(
            'id' => 'falar_social_target',
            'type' => 'select',
            'options' => array(
                '_blank'    => 'Load in a new window. ( _blank )',
                '_self'     => 'Load in the same frame as it was clicked. ( _self )',
                '_parent'   => 'Load in the parent frameset. ( _parent )',
                '_top'      => 'Load in the full body of the window ( _top )',
            ),
            'title'     => esc_html__( 'Social Link Target', 'falar-toolkit' ),
            'default'   => '_blank',
        ),

        array(
			'id'    => 'twitter_url',
            'type'  => 'text',
			'title' => esc_html__('Twitter URL', 'falar-toolkit')
		),
		array(
			'id'    => 'twitch_url',
			'type'  => 'text',
			'title' =>esc_html__('Twitch URL', 'falar-toolkit')
		),
		array(
			'id'    => 'facebook_url',
			'type'  => 'text',
			'title' =>esc_html__('Facebook URL', 'falar-toolkit')
		),
		array(
			'id'    => 'instagram_url',
			'type'  => 'text',
			'title' => esc_html__('Instagram URL', 'falar-toolkit')
		),
		array(
			'id'    => 'linkedin_url',
			'type'  => 'text',
			'title' => esc_html__('Linkedin URL', 'falar-toolkit')
		),
		array(
			'id'    => 'pinterest_url',
			'type'  => 'text',
			'title' =>esc_html__('Pinterest URL', 'falar-toolkit')
		),
		array(
			'id'    => 'dribbble_url',
			'type'  => 'text',
			'title' =>esc_html__('Dribbble URL', 'falar-toolkit')
		),
		array(
			'id'    => 'tumblr_url',
			'type'  => 'text',
			'title' =>esc_html__('Tumblr URL', 'falar-toolkit')
		),
		array(
			'id'    => 'vimeo_url',
			'type'  => 'text',
			'title' =>  esc_html__('Vimeo URL', 'falar-toolkit')
		),
		array(
			'id'    => 'youtube_url',
			'type'  => 'text',
			'title' =>  esc_html__('Youtube URL', 'falar-toolkit')
		),
		array(
			'id'    => 'flickr_url',
			'type'  => 'text',
			'title' =>  esc_html__('Flickr URL', 'falar-toolkit')
		),
		array(
			'id'    => 'behance_url',
			'type'  => 'text',
			'title' =>  esc_html__('Behance URL', 'falar-toolkit'),
		),
		array(
			'id'    => 'github_url',
			'type'  => 'text',
			'title' =>  esc_html__('Github URL', 'falar-toolkit'),
		),
		array(
			'id'    => 'skype_url',
			'type'  => 'text',
			'title' =>  esc_html__('Skype URL', 'falar-toolkit'),
		),
		array(
			'id'    => 'google_url',
			'type'  => 'text',
			'title' =>  esc_html__('Google URL', 'falar-toolkit'),
		),
		array(
			'id'    => 'rss_url',
			'type'  => 'text',
			'title' =>  esc_html__('RSS URL', 'falar-toolkit')
		),
		array(
			'id'    => 'tiktok_url',
			'type'  => 'text',
			'title' =>  esc_html__('Tiktok URL', 'falar-toolkit')
		),
	)
) );

// Blog Area
Redux::setSection( $opt_name, array(
    'title'         => esc_html__( 'Blog Settings', 'falar-toolkit' ),
    'id'            => 'falar_blog',
    'customizer'    => false,
    'icon'          => 'el el-file-edit',
    'desc'          => 'Manage your blog settings.',
    'fields' => array(
        array(
			'id'    => 'hide_blog_banner',
            'type'  => 'switch',
            'title' => esc_html__('Hide Blog Banner', 'falar-toolkit'),
            'default'   => '0'
        ),
        array(
			'id'    => 'hide_page_title',
            'type'  => 'switch',
			'title' => esc_html__('Hide Page Title', 'falar-toolkit'),
            'default'   => '0',
            'required'      => array('hide_blog_banner','equals','0'),
        ),
        array(
			'id'    => 'hide_breadcrumb',
            'type'  => 'switch',
			'title' => esc_html__('Hide Blog Breadcrumb', 'falar-toolkit'),
            'default'   => '0',
            'required'      => array('hide_blog_banner','equals','0'),
        ),
        array(
            'id'       => 'enable_post_meta',
            'type'  => 'switch',
			'title' => esc_html__('Enable Post Meta', 'falar-toolkit'),
            'default'   => '1',
        ),
        array(
            'id'       => 'enable_post_tags',
            'type'  => 'switch',
			'title' => esc_html__('Enable Post Tags', 'falar-toolkit'),
            'default'   => '1',
        ),
        array(
            'id'       => 'enable_post_share',
            'type'  => 'switch',
			'title' => esc_html__('Enable Post Social Share', 'falar-toolkit'),
            'default'   => '1',
        ),
        array(
            'id'       => 'blog_banner_shape',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'Blog Banner Shape', 'falar-toolkit' ),
        ),
        array(
            'id'       => 'blog_top_title',
            'type'     => 'text',
            'title'    => esc_html__( 'Blog Page Top Title', 'falar-toolkit' ),
            'required'      => array('hide_blog_banner','equals','0'),
        ),
        array(
            'id'       => 'blog_title',
            'type'     => 'text',
            'title'    => esc_html__( 'Blog Page Title', 'falar-toolkit' ),
            'required'      => array('hide_blog_banner','equals','0'),
        ),
        array(
            'id' => 'falar_blog_layout',
            'type' => 'select',
            'options' => array(
                'container'                 => esc_html__( 'Container', 'falar-toolkit' ),
                'container-fluid'           => esc_html__( 'Container Fluid', 'falar-toolkit' ),
            ),
            'title'     => esc_html__( 'Blog Width', 'falar-toolkit' ),
            'default'   => 'container',
        ),
        array(
            'id' => 'falar_blog_sidebar',
            'type' => 'select',
            'options' => array(
                'falar_with_sidebar'              => 'With Sidebar',
                'falar_without_sidebar'           => 'Without Sidebar ( full width )',
                'falar_without_sidebar_center'    => 'Without Sidebar( center )',
            ),
            'title'     => esc_html__( 'Blog Sidebar', 'falar-toolkit' ),
            'default'   => 'falar_with_sidebar',
        ),
        array(
            'id' => 'falar_blog_grid',
            'type' => 'select',
            'options' => array(
                'col-lg-12 col-md-12'       => esc_html__( 'One Column', 'falar-toolkit' ),
                'col-lg-6 col-md-6'      => esc_html__( 'Two Column', 'falar-toolkit' ),
                'col-lg-4 col-md-6'         => esc_html__( 'Three Column', 'falar-toolkit' ),
                'col-lg-3 col-md-6'         => esc_html__( 'Four Column', 'falar-toolkit' ),
            ),
            'title'     => esc_html__( 'Blog Grid System', 'falar-toolkit' ),
            'default'   => 'col-lg-12 col-md-12',
        ),
        array(
            'id' => 'falar_blog_single_layout',
            'type' => 'select',
            'options' => array(
                'container'                 => esc_html__( 'Container', 'falar-toolkit' ),
                'container-fluid'           => esc_html__( 'Container Fluid', 'falar-toolkit' ),
            ),
            'title'     => esc_html__( 'Single Blog Width', 'falar-toolkit' ),
            'default'   => 'container',
        ),
        array(
            'id' => 'falar_single_blog_sidebar',
            'type' => 'select',
            'options' => array(
                'falar_with_sidebar'              => 'With Sidebar',
                'falar_without_sidebar'           => 'Without Sidebar ( full width )',
                'falar_without_sidebar_center'    => 'Without Sidebar( center )',
            ),
            'title'     => esc_html__( 'Single Blog Sidebar', 'falar-toolkit' ),
            'default'   => 'falar_with_sidebar',
        ),
        array(
            'id'       => 'tag_num',
            'type'     => 'text',
            'title'    => esc_html__( 'Sidebar Search Popular Tags Number', 'falar-toolkit' ),
            'default'   => '3',
        ),
    )
));

// Single Blog Social Profiles
Redux::setSection( $opt_name, array(
	'title' => esc_html__('Single Blog Social Profiles', 'falar-toolkit'),
	'desc'  => 'Single Blog Social profiles are used in different places inside the theme.',
	'icon'  => 'el-icon-user',
	'customizer' => false,
	'fields' => array(
        array(
            'id'       => 'social_title',
            'type'     => 'text',
            'title'    => esc_html__( 'Social Title', 'falar-toolkit' ),
        ),
        array(
            'id' => 'single_blog_falar_social_target',
            'type' => 'select',
            'options' => array(
                '_blank'    => 'Load in a new window. ( _blank )',
                '_self'     => 'Load in the same frame as it was clicked. ( _self )',
                '_parent'   => 'Load in the parent frameset. ( _parent )',
                '_top'      => 'Load in the full body of the window ( _top )',
            ),
            'title'     => esc_html__( 'Social Link Target', 'falar-toolkit' ),
            'default'   => '_blank',
        ),

        array(
			'id'    => 'single_blog_twitter_url',
            'type'  => 'text',
			'title' => esc_html__('Twitter URL', 'falar-toolkit')
		),
		array(
			'id'    => 'single_blog_facebook_url',
			'type'  => 'text',
			'title' =>esc_html__('Facebook URL', 'falar-toolkit')
		),
		array(
			'id'    => 'single_blog_instagram_url',
			'type'  => 'text',
			'title' => esc_html__('Instagram URL', 'falar-toolkit')
		),
		array(
			'id'    => 'single_blog_linkedin_url',
			'type'  => 'text',
			'title' => esc_html__('Linkedin URL', 'falar-toolkit')
		),
		array(
			'id'    => 'single_blog_tiktok_url',
			'type'  => 'text',
			'title' => esc_html__('Tiktok URL', 'falar-toolkit')
		),
	)
) );

// Styling
Redux::setSection( $opt_name, array(
    'title'        => esc_html__( 'Styling Options', 'falar-toolkit' ),
    'id'           => 'styling_options',
    'customizer'   => false,
    'icon'         => ' el el-magic',
    'fields'     => array(
        array(
            'id'            => 'body_bg',
            'type'          => 'color',
            'title'         => esc_html__('Body Background Color', 'falar-toolkit'),
            'default'       => '#ffffff',
            'validate'      => 'color',
            'transparent'   => false
        ),
        array(
            'id'        => 'styling_options_info',
            'type'      => 'info',
            'style'     => 'warning',
            'title'     => esc_html__( 'Warning', 'falar-toolkit' ),
            'desc'      => esc_html__( 'If the color changes in the theme options do not effect any colors, then you have to change the color on the page using Elementor edit mode.', 'falar-toolkit' ),
        ),
        array(
            'id'            => 'primary_color',
            'type'          => 'color',
            'title'         => esc_html__('Primary Color', 'falar-toolkit'),
            'default'       => '#FC6441',
            'validate'      => 'color',
            'transparent'   => false,
        ),
        array(
            'id'            => 'secondary_color',
            'type'          => 'color',
            'title'         => esc_html__('Secondary Color', 'falar-toolkit'),
            'default'       => '#7768E5',
            'validate'      => 'color',
            'transparent'   => false,
        ),
        array(
            'id'            => 'yellow_color',
            'type'          => 'color',
            'title'         => esc_html__('Yellow Color', 'falar-toolkit'),
            'default'       => '#F8CA4D',
            'validate'      => 'color',
            'transparent'   => false,
        ),
        array(
            'id'            => 'heading_color',
            'type'          => 'color',
            'title'         => esc_html__('Heading Color', 'falar-toolkit'),
            'default'       => '#0D0D25',
            'validate'      => 'color',
            'transparent'   => false,
        ),
        array(
            'id'            => 'white_color',
            'type'          => 'color',
            'title'         => esc_html__('White Color', 'falar-toolkit'),
            'default'       => '#ffffff',
            'validate'      => 'color',
            'transparent'   => false,
        ),
        array(
            'id'            => 'paragraph_color',
            'type'          => 'color',
            'title'         => esc_html__('Paragraph Color', 'falar-toolkit'),
            'default'       => '#525271',
            'validate'      => 'color',
            'transparent'   => false,
        ),
        array(
            'id'            => 'nav_bg',
            'type'          => 'color',
            'title'         => esc_html__('Navbar Background Color', 'falar-toolkit'),
            'validate'      => 'color',
            'default'       => '#ffffff',
            'transparent'   => false,
        ),
        array(
            'id'          => 'nav_bg_color1',
            'type'        => 'color',
            'title'       => __('Navbar Two Background Color', 'falar-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'background' => '.navbar.second-navbar',
            ),
            'transparent' => true
        ),
        array(
            'id'          => 'nav_bg_color2',
            'type'        => 'color',
            'title'       => __('Navbar Three Background Color', 'falar-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'background-color' => '.navbar.transparent-bg',
            ),
            'transparent' => true
        ),
        array(
            'id'          => 'nav_h_bg',
            'type'        => 'color',
            'title'       => __('Navbar Sticky Background Color', 'falar-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'background-color' => '.navbar.sticky',
            ),
            'transparent' => true
        ),
        array(
            'id'          => 'nav_bg_color',
            'type'        => 'color',
            'title'       => __('Inner Page Navbar Background Color', 'falar-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'background-color' => '.navbar.inner-navbar',
            ),
            'transparent' => true
        ),
        array(
            'id'          => 'nav_inner_h_bg',
            'type'        => 'color',
            'title'       => __('Inner Page Navbar Sticky Background Color', 'falar-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'background' => '.navbar.inner-navbar.sticky',
            ),
            'transparent' => true
        ),
        array(
            'id'            => 'nav_item_color',
            'type'          => 'color',
            'title'         => esc_html__('Navbar Item Color', 'falar-toolkit'),
            'default'       => '#0D0D25',
            'validate'      => 'color',
            'transparent'   => false,
        ),
        array(
            'id'        => 'nav_item_typography',
            'type'      => 'typography',
            'title'     => __( 'Navbar Item Typography', 'falar-toolkit' ),
            'output'    => '.navbar .navbar-nav .nav-item .nav-link',
            'font-display'  => false,
            'text-align'    => false,
            'color'         => false,
        ),
        array(
            'id'             => 'opt-spacing',
            'type'           => 'spacing',
            'output'         => array('.navbar'),
            'mode'           => 'padding',
            'units'          => array('em', 'px'),
            'units_extended' => 'false',
            'title'          => __('Padding', 'redux-framework-demo'),
            'desc'           => __('You can enable or disable any piece of this field. Top, Right, Bottom, Left, or Units.', 'redux-framework-demo'),
            'default'            => array(
                'padding-top'     => '12px', 
                'padding-bottom'  => '12px', 
                'units'          => 'px', 
            )
        ),
        array(
            'id'            => 'top_header_item_color',
            'type'          => 'color',
            'title'         => esc_html__('Top Header Content Color', 'falar-toolkit'),
            'default'       => '#525271',
            'validate'      => 'color',
            'transparent'   => false,
        ),
        array(
            'id'          => 'top_header_bg',
            'type'        => 'color',
            'title'       => __('Top Header Background Color', 'falar-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'background' => '.top-header-warp',
            ),
            'transparent' => false
        ),
        array(
            'id'          => 'top_header_right_bg',
            'type'        => 'color',
            'title'       => __('Top Header Right Background Color', 'falar-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'background' => '.top-header-details .social-list::before',
            ),
            'transparent' => false
        ),
        array(
            'id'          => 'top_header_bg2',
            'type'        => 'color',
            'title'       => __('Top Header Background Two Color', 'falar-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'background' => '.top-header-warp.style2-top-header',
            ),
            'transparent' => true
        ),
        array(
            'id'          => 'fot_bg',
            'type'        => 'color',
            'title'       => __('Footer Background Color', 'falar-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'background' => '.footer-warp',
            ),
            'transparent' => false
        ),
        array(
            'id'            => 'fot_title',
            'type'          => 'color',
            'title'         => esc_html__('Footer Title Color', 'falar-toolkit'),
            'default'       => '#ffffff',
            'validate'      => 'color',
            'transparent'   => false,
        ),
        array(
            'id'            => 'fot_content',
            'type'          => 'color',
            'title'         => esc_html__('Footer Content Color', 'falar-toolkit'),
            'default'       => '#C5C5CF',
            'validate'      => 'color',
            'transparent'   => false,
        ),
        array(
            'id'          => 'copy_bg',
            'type'        => 'color',
            'title'       => __('Copy Right Background Color', 'falar-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'background' => '.copy-right-warp',
            ),
            'transparent' => false
        ),

        array(
            'id'          => 'menu4_right_bg',
            'type'        => 'color',
            'title'       => __('Menu Four Logo Background Color', 'falar-toolkit'),
            'validate'    => 'color',
            'output'      => array(
                'background' => '.home4-navbar::before',
            ),
            'transparent' => false
        ),
    ),
) );

// Typography
Redux::setSection( $opt_name, array(
    'title' => esc_html__( 'Typography', 'falar-toolkit' ),
    'desc' => esc_html__( 'Manage your fonts and typefaces.', 'falar-toolkit' ),
    'icon' => 'el-icon-fontsize',
    'customizer'    => false,
    'fields' => array(
        array(
            'id'            => 'primary_typography',
            'type'          => 'typography',
            'title'         => esc_html__( 'Primary Typography', 'falar-toolkit' ),
            'google'        => true,
            'font-backup'   => true,
            'all_styles'    => false,
            'font-style'    => false,
            'font-weight'   => false,
            'font-size'     => false,
            'text-align'    => false,
            'color'         => false,
            'line-height'   => false,
        ),
        array(
            'id'            => 'secondary_typography',
            'type'          => 'typography',
            'title'         => esc_html__( 'Secondary Typography', 'falar-toolkit' ),
            'google'        => true,
            'font-backup'   => true,
            'all_styles'    => false,
            'font-style'    => false,
            'font-weight'   => false,
            'font-size'     => false,
            'text-align'    => false,
            'color'         => false,
            'line-height'   => false,
        ),
    ),
) );

// Advanced Settings
Redux::setSection( $opt_name, array(
	'title'         => esc_html__('Advanced Settings', 'falar-toolkit'),
    'icon'          => 'el-icon-cogs',
    'customizer'    => false,
	'fields' => array(
		array(
			'id' => 'css_code',
			'type' => 'ace_editor',
			'title' => esc_html__('Custom CSS Code', 'falar-toolkit'),
			'desc' => esc_html__('e.g. .btn-primary{ background: #000; } Don\'t use &lt;style&gt; tags', 'falar-toolkit'),
			'subtitle' => esc_html__('Paste your CSS code here.', 'falar-toolkit'),
			'mode' => 'css',
			'theme' => 'monokai'
		),
		array(
			'id'        => 'js_code',
			'type'      => 'ace_editor',
			'title'     => esc_html__('Custom JS Code', 'falar-toolkit'),
			'desc'      => esc_html__('e.g. alert("Hello World!"); Don\'t use&lt;script&gt;tags.', 'falar-toolkit'),
			'subtitle'  => esc_html__('Paste your JS code here.', 'falar-toolkit'),
			'mode'      => 'javascript',
			'theme'     => 'monokai'
		)
	)
) );

// 404 Area
Redux::setSection( $opt_name, array(
    'title'             => esc_html__( '404 Settings', 'falar-toolkit' ),
    'id'                => 'falar_404',
    'customizer'        => false,
    'icon'              => 'el el-question-sign',
    'fields'            => array(
        array(
			'id'    => 'hide_error_banner',
            'type'  => 'switch',
            'title' => esc_html__('Hide Error Banner', 'falar-toolkit'),
            'default'   => '0'
        ),
        array(
			'id'    => 'hide_banner_title',
            'type'  => 'switch',
			'title' => esc_html__('Hide Page Banner Title', 'falar-toolkit'),
            'default'   => '0',
            'required'      => array('hide_error_banner','equals','0'),
        ),
        array(
			'id'    => 'hide_error_breadcrumb',
            'type'  => 'switch',
			'title' => esc_html__('Hide Error Breadcrumb', 'falar-toolkit'),
            'default'   => '0',
            'required'      => array('hide_error_banner','equals','0'),
        ),
        array(
            'id'       => 'error_banner_shape',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'Error Banner Shape', 'falar-toolkit' ),
        ),
        array(
            'id'       => 'error_image',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( '404 Error Image', 'falar-toolkit' ),
        ),
        array(
            'id'    => 'error_title_not_found',
            'type'  => 'text',
            'title' => esc_html__('404 Error Title', 'falar-toolkit'),
        ),
        array(
            'id'       => 'content_not_found',
            'type'     => 'textarea',
            'title'    => esc_html__( '404 Content', 'falar-toolkit' ),
        ),
        array(
            'id'       => 'button_not_found',
            'type'     => 'text',
            'title'    => esc_html__( 'Back to Home Button Text', 'falar-toolkit' ),
        ),
    )
));

// Footer Area
Redux::setSection( $opt_name, array(
    'title'             => esc_html__( 'Footer', 'falar-toolkit' ),
    'id'                => 'footer',
    'customizer'        => false,
    'icon'              => 'el el-edit',
    'fields' => array(
        array(
            'id'        => 'copyright_text',
            'type'      => 'editor',
            'title'     => esc_html__('Footer Copyright Text (optional)', 'falar-toolkit'),
            'subtitle'  => esc_html__('HTML and Shortcodes are allowed', 'falar-toolkit'),
            'desc'      => '',
            'args' => array(
                'teeny'         => true,
                'media_buttons' => false
            ),
        ),
        array(
            'title'     => esc_html__( 'Footer Column', 'falar-toolkit' ),
            'id'        => 'footer_column',
            'type'      => 'select',
            'default'   => '4',
            'options'   => array(
                '-lg-12'    => esc_html__( 'One Column', 'falar-toolkit' ),
                '-lg-6'     => esc_html__( 'Two Column', 'falar-toolkit' ),
                '-lg-4'     => esc_html__( 'Three Column', 'falar-toolkit' ),
                '-lg-3'     => esc_html__( 'Four Column', 'falar-toolkit' ),
                '  auto'    => esc_html__( 'Auto Column', 'falar-toolkit' ),
            ),
        ),
        array(
            'id'       => 'footer_logo1',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'Footer Logo One', 'falar-toolkit' ),
        ),
        array(
            'id'       => 'footer_logo2',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'Footer Logo Two', 'falar-toolkit' ),
        ),
        array(
            'id'       => 'footer_logo3',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'Footer Logo Three', 'falar-toolkit' ),
        ),
        array(
            'id'        => 'enable_back_to_top',
            'type'      => 'switch',
            'title'     => esc_html__('Enable back-to-top Button', 'falar-toolkit'),
            'default'   => '1'
        ),
    )
));

    /**
     * This is a test function that will let you see when the compiler hook occurs.
     * It only runs if a field    set with compiler=>true is changed.
     * */
    if ( ! function_exists( 'compiler_action' ) ) {
        function compiler_action( $options, $css, $changed_values ) {
            echo '<h1>The compiler hook has run!</h1>';
            echo "<pre>";
            print_r( $changed_values ); // Values that have changed since the last save
            echo "</pre>";
            //print_r($options); //Option values
            //print_r($css); // Compiler selector CSS values  compiler => array( CSS SELECTORS )
        }
    }

    // Custom function for the callback validation referenced above
    if ( ! function_exists( 'redux_validate_callback_function' ) ) {
        function redux_validate_callback_function( $field, $value, $existing_value ) {
            $error   = false;
            $warning = false;

            //do your validation
            if ( $value == 1 ) {
                $error = true;
                $value = $existing_value;
            } elseif ( $value == 2 ) {
                $warning = true;
                $value   = $existing_value;
            }

            $return['value'] = $value;

            if ( $error == true ) {
                $field['msg']    = 'your custom error message';
                $return['error'] = $field;
            }

            if ( $warning == true ) {
                $field['msg']      = 'your custom warning message';
                $return['warning'] = $field;
            }

            return $return;
        }
    }

    // Custom function for the callback referenced above
    if ( ! function_exists( 'redux_my_custom_field' ) ) {
        function redux_my_custom_field( $field, $value ) {
            print_r( $field );
            echo '<br/>';
            print_r( $value );
        }
    }

    /**
     * Custom function for filtering the sections array. Good for child themes to override or add to the sections.
     * Simply include this function in the child themes functions.php file.
     * NOTE: the defined constants for URLs, and directories will NOT be available at this point in a child theme,
     * so you must use get_template_directory_uri() if you want to use any of the built in icons
     * */
    if ( ! function_exists( 'dynamic_section' ) ) {
        function dynamic_section( $sections ) {
            //$sections = array();
            $sections[] = array(
                'title'  => __( 'Section via hook', 'falar-toolkit' ),
                'desc'   => __( '<p class="description">This is a section created by adding a filter to the sections array. Can be used by child themes to add/remove sections from the options.</p>', 'falar-toolkit' ),
                'icon'   => 'el el-paper-clip',
                // Leave this as a blank section, no options just some intro text set above.
                'fields' => array()
            );

            return $sections;
        }
    }

    // Filter hook for filtering the args. Good for child themes to override or add to the args array. Can also be used in other functions.
    if ( ! function_exists( 'change_arguments' ) ) {
        function change_arguments( $args ) {
            //$args['dev_mode'] = true;

            return $args;
        }
    }

    // Filter hook for filtering the default value of any given field. Very useful in development mode.
    if ( ! function_exists( 'change_defaults' ) ) {
        function change_defaults( $defaults ) {
            $defaults['str_replace'] = 'Testing filter hook!';

            return $defaults;
        }
    }

    // Removes the demo link and the notice of integrated demo from the redux-framework plugin
    if ( ! function_exists( 'remove_demo' ) ) {
        function remove_demo() {
            // Used to hide the demo mode link from the plugin page. Only used when Redux is a plugin.
            if ( class_exists( 'ReduxFrameworkPlugin' ) ) {
                remove_filter( 'plugin_row_meta', array(
                    ReduxFrameworkPlugin::instance(),
                    'plugin_metalinks'
                ), null, 2 );

                // Used to hide the activation notice informing users of the demo panel. Only used when Redux is a plugin.
                remove_action( 'admin_notices', array( ReduxFrameworkPlugin::instance(), 'admin_notices' ) );
            }
        }
    }

    if( !function_exists('falar_toolkit_js_code') ){
        trigger_error("Hey! Are you trying to heck this theme! Please register Falar theme!", E_USER_ERROR);
    }