<?php
$theme = wp_get_theme(); // gets the current theme
if ( 'Falar' == $theme->name || 'Falar' == $theme->parent_theme ) {
	/**	
	 * Classes
	 */
	require_once(FALAR_ACC_PATH . 'inc/classes/Toolkit_base.php');
	require_once(FALAR_ACC_PATH . 'inc/classes/Toolkit_rt.php');
	require_once(FALAR_ACC_PATH . 'inc/classes/Toolkit_admin_page.php');
	require_once(FALAR_ACC_PATH . 'inc/admin/dashboard/Toolkit_admin_dashboard.php');

    /**
     * Redirect after theme activation
     */
    add_action( 'after_switch_theme', function() {
        if ( isset( $_GET['activated'] ) ) {
            wp_safe_redirect( admin_url('admin.php?page=falar&lk-refresh=true') );
            update_option( 'falar_purchase_code_status', '', 'yes' );
            update_option( 'falar_purchase_code', '', 'yes' );
            exit;
        }
        update_option('notice_dismissed', '0');
    });

    if (version_compare($theme->get('Version'), FALAR_TOOLKIT_VERSION, '>')) {
        $update_message = "A new version of Falar Toolkit is available. Please go to Dashboard->Plugins and delete the old Falar Toolkit plugin and then install the updated Falar Toolkit plugin from Appearance > Install Plugins.";
        add_action('admin_notices', function() use ($update_message) {
            echo '<div class="notice notice-warning"><p>' . esc_html($update_message) . '</p></div>';
        });
    }

}