<?php
/**
 * About Five Widget
 */

namespace Elementor;
class Falar_About_Five extends Widget_Base {

	public function get_name() {
        return 'Falar_About_Five';
    }

	public function get_title() {
        return __( 'About Five', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_About_Five_Area',
			[
				'label' => __( 'About Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Mission and Values', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'about_logo',
            [
                'label'       => __( 'About Logo Image', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );

        $this->add_control(
            'content1',
            [
                'label'       => __( 'Content One', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Falar is mission is to produce scientific, cultural and artistic knowledge, offer higher education firmly rooted in research, invest in the social and economic valorization of knowledge and actively participate in the progress of the communities to which the university belongs.', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content2',
            [
                'label'       => __( 'Content Two', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('The University of Falar is a public foundation regulated by private law and with statutory, educational, scientific, cultural, administrative, financial, patrimonial and disciplinary autonomy.', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'about_image',
            [
                'label'       => __( 'About Image', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );
        
        $this->end_controls_section();

        $this->start_controls_section(
			'about_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .about-campus-title h2' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .about-campus-title h2',
                ]
            );
			$this->add_control(
				'content_color',
				[
					'label'     => __( 'Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} about-campus-content p' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} about-campus-content p',
                ]
            );
        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        ?>

        <!-- Inner Style2 Image Warp Start -->
        <div class="about-style2-image-warp ptb-100">
            <div class="container">
                <div class="row g-4">
                    <div class="col-lg-6">
                        <div class="about-campus-title">
                            <?php if( $settings['title']): ?>
                                <h2><?php echo wp_kses_post( $settings['title'] ); ?></h2>
                            <?php endif; ?>
                            <?php if( $settings['about_logo']['url'] != '' ): ?>
                                <div class="about-campus-logo">
                                    <img src="<?php echo esc_url($settings['about_logo']['url'] ) ?>" class="about-logo2" alt="image">
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="about-campus-content">
                            <?php if( $settings['content1']): ?>
                                <p><?php echo wp_kses_post( $settings['content1'] ); ?></p>
                            <?php endif; ?>
                            <?php if( $settings['content2']): ?>
                                <p><?php echo wp_kses_post( $settings['content2'] ); ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <?php if( $settings['about_image']['url'] != '' ): ?>
                    <div class="inner-about-style3-image">
                        <img src="<?php echo esc_url($settings['about_image']['url'] ) ?>" alt="image">
                    </div>
                <?php endif; ?>
            </div>
        </div>
        <!-- Inner Style2 Image Warp End -->
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_About_Five );