<?php
/**
 * About Four Widget
 */

namespace Elementor;
class Falar_About_Four extends Widget_Base {

	public function get_name() {
        return 'Falar_About_Four';
    }

	public function get_title() {
        return __( 'About Four', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_About_Four_Area',
			[
				'label' => __( 'About Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'about_image',
            [
                'label'       => __( 'About Image', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'about_logo',
            [
                'label'       => __( 'About Logo Image', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );

        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Falar University Campus', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content1',
            [
                'label'       => __( 'Content One', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Falar University has the biggest campus in Canada, as well as satellite facilities in several Manhattan neighborhoods. Come visit our campus. Attend one of our public programs. Take a tour of our university. Stop by one of the area’s local restaurants or cafés.', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content2',
            [
                'label'       => __( 'Content Two', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Welcome to Falar, where knowledge meets innovation and where every student is journey to success begins.', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'about_bottom_image1',
            [
                'label'       => __( 'About Bottom Image One', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'about_bottom_image2',
            [
                'label'       => __( 'About Bottom Image Two', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'about_bottom_image3',
            [
                'label'       => __( 'About Bottom Image Three', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
			'about_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .about-campus-title h2' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .about-campus-title h2',
                ]
            );
			$this->add_control(
				'content_color',
				[
					'label'     => __( 'Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .about-campus-content p' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .about-campus-content p',
                ]
            );
        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        ?>

        <!-- Inner Style2 Image Warp Start -->
        <div class="about-style2-image-warp ptb-100">
            <div class="container">
                <?php if( $settings['about_image']['url'] != '' ): ?>
                    <div class="inner-about-style2-image">
                        <img src="<?php echo esc_url($settings['about_image']['url'] ) ?>" alt="image">
                    </div>
                <?php endif; ?>
                <div class="row  g-4">
                    <div class="col-lg-6">
                        <div class="about-campus-title">
                            <?php if( $settings['title']): ?>
                                <h2><?php echo wp_kses_post( $settings['title'] ); ?></h2>
                            <?php endif; ?>
                            <?php if( $settings['about_logo']['url'] != '' ): ?>
                                <div class="about-campus-logo">
                                    <img src="<?php echo esc_url($settings['about_logo']['url'] ) ?>" class="about-logo" alt="image">
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="about-campus-content">
                            <?php if( $settings['content1']): ?>
                                <p><?php echo wp_kses_post( $settings['content1'] ); ?></p>
                            <?php endif; ?>
                            <?php if( $settings['content2']): ?>
                                <p><?php echo wp_kses_post( $settings['content2'] ); ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Inner Style2 Image Warp End -->

        <!-- About Campuses Warp Start -->
        <div class="about-campuses-warp">
            <div class="container">
                <div class="row g-4 align-items-center">
                    <?php if( $settings['about_bottom_image1']['url'] != '' ): ?>
                        <div class="col-lg-3 col-md-4">
                            <div class="campuses-widget">
                                <img src="<?php echo esc_url($settings['about_bottom_image1']['url'] ) ?>" alt="image">
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if( $settings['about_bottom_image2']['url'] != '' ): ?>
                        <div class="col-lg-6 col-md-4">
                            <div class="campuses-widget">
                                <img src="<?php echo esc_url($settings['about_bottom_image2']['url'] ) ?>" alt="image">
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if( $settings['about_bottom_image3']['url'] != '' ): ?>
                        <div class="col-lg-3 col-md-4">
                            <div class="campuses-widget">
                                <img src="<?php echo esc_url($settings['about_bottom_image3']['url'] ) ?>" alt="image">
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <!-- About Campuses Warp End -->
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_About_Four );