<?php
/**
 * About Page links Widget
 */

namespace Elementor;
class Falar_About_Page_links extends Widget_Base {

	public function get_name() {
        return 'Falar_About_Page_links';
    }

	public function get_title() {
        return __( 'About Page links', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_About_Page_links_Area',
			[
				'label' => __( 'About Page links Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $list_items = new Repeater();

            $list_items->add_control(
				'about_text',
				[
					'label'       => __( 'About Page Text', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'about_url',
				[
					'label'       => __( 'About Page Url', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
                'active_style',
                [
                    'label' 	=> esc_html__( 'Active/Inactive Style', 'falar-toolkit' ),
                    'type' 		=> Controls_Manager::SELECT,
                    'options' 	=> [
                        '1'         => esc_html__( 'Inactive', 'falar-toolkit' ),
                        '2'         => esc_html__( 'Active', 'falar-toolkit' ),
                    ],
                    'default' => '1',
                ]
            );
            $this->add_control(
                'about_item',
                [
                    'label' => esc_html__('Add About Page Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'about_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'btn_color',
				[
					'label'     => __( 'Button Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .inner-all-pages .about-pages-list li a' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'btn_bg_color',
				[
					'label'     => __( 'Button Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .inner-all-pages .about-pages-list li a' => 'background: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn_typography',
                    'label'    => __( 'Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .inner-all-pages .about-pages-list li a',
                ]
            );
            $this->add_control(
				'btn_bg_h_color',
				[
					'label'     => __( 'Button Background Hover Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .inner-all-pages .about-pages-list li a.active, .inner-all-pages .about-pages-list li a:hover' => 'background: {{VALUE}}',
					],
				]
			);
            $this->add_control(
				'btn_h_color',
				[
					'label'     => __( 'Button Hover Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .inner-all-pages .about-pages-list li a.active, .inner-all-pages .about-pages-list li a:hover' => 'color: {{VALUE}}',
					],
				]
			);

        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $about_item = $settings['about_item'];
        ?>

        <!-- About All Pages Warp Style Start -->
        <div class="about-all-pages pt-100">
            <div class="container">
                <div class="inner-all-pages">
                    <ul class="about-pages-list">
                        <?php foreach($about_item as $item_about): ?>
                            <li>
                                <a href="<?php echo wp_kses_post( $item_about['about_url'] ); ?>" class="<?php if ($item_about['active_style']=='1'): ?>inactive<?php elseif($item_about['active_style']=='2'): ?>active<?php endif; ?>"><?php echo wp_kses_post( $item_about['about_text'] ); ?></a>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            </div>
        </div>
        <!-- About All Pages Warp Style End -->
        
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_About_Page_links );