<?php
/**
 * About Six Widget
 */

namespace Elementor;
class Falar_About_Six extends Widget_Base {

	public function get_name() {
        return 'Falar_About_Six';
    }

	public function get_title() {
        return __( 'About Six', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_About_Six_Area',
			[
				'label' => __( 'About Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('About Falar University', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'title2',
            [
                'label'       => __( 'Title Two', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => __('Falar is a premier institution dedicated to advancing the field of medicine and improving global health outcomes. At our university, we are committed to academic excellence.', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content',
            [
                'label'       => __( 'Content', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => __('Our mission is to educate and inspire the next generation of healthcare professionals, equipping them with the knowledge, skills, and values necessary to meet the evolving challenges.', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'button_text',
            [
                'label'   => __( 'Button Text', 'falar-toolkit' ),
                'type'    => Controls_Manager::TEXT,
                'default' => __('Find Out More', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'button_url',
            [
                'label'   => __( 'Button Url', 'falar-toolkit' ),
                'type'    => Controls_Manager::TEXT,
                'default' => __('#', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'shape1',
            [
                'label'       => __( 'Shape One', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'shape2',
            [
                'label'       => __( 'Shape Two', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'shape3',
            [
                'label'       => __( 'Shape Three', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'shape4',
            [
                'label'       => __( 'Shape Four', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'shape5',
            [
                'label'       => __( 'Shape Five', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'shape6',
            [
                'label'       => __( 'Shape Six', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'shape7',
            [
                'label'       => __( 'Shape Seven', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'shape8',
            [
                'label'       => __( 'Shape Eight', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'shape9',
            [
                'label'       => __( 'Shape Nine', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'shape10',
            [
                'label'       => __( 'Shape Ten', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'shape11',
            [
                'label'       => __( 'Shape Eleven', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'shape12',
            [
                'label'       => __( 'Shape Twelve', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'shape13',
            [
                'label'       => __( 'Shape Thirteen', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'shape14',
            [
                'label'       => __( 'Shape Fourteen', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'shape15',
            [
                'label'       => __( 'Shape Fifteen', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'shape16',
            [
                'label'       => __( 'Shape Sixteen', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
			'about_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .home-five-about-heading h2' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .home-five-about-heading h2',
                ]
            );
			$this->add_control(
				'title_color2',
				[
					'label'     => __( 'Title Two Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .home-five-about-content h3' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography2',
                    'label'    => __( 'Title Two Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .home-five-about-content h3',
                ]
            );
			$this->add_control(
				'content_color',
				[
					'label'     => __( 'Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .home-five-about-content p' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .home-five-about-content p',
                ]
            );
            $this->add_control(
				'btn_color',
				[
					'label'     => __( 'Button Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .home-five-about-content .default-btn' => 'color: {{VALUE}}',
					],
				]
			);
            $this->add_control(
				'btn_bg_color',
				[
					'label'     => __( 'Button Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .home-five-about-content .default-btn' => 'background: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn_typography',
                    'label'    => __( 'Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .home-five-about-content .default-btn',
                ]
            );
            
        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        ?>

        <!-- Home Five About Area Start -->
        <div class="home-five-about-area pb-100">
            <div class="container">
                <div class="row">
                    <div class="col-lg-5">
                        <div class="home-five-about-heading">
                            <?php if( $settings['title']): ?>
                                <h2><?php echo wp_kses_post( $settings['title'] ); ?></h2>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-lg-7">
                        <div class="home-five-about-content">
                            <?php if( $settings['title2']): ?>
                                <h3><?php echo wp_kses_post( $settings['title2'] ); ?></h3>
                            <?php endif; ?>
                            <?php if( $settings['content']): ?>
                                <p><?php echo wp_kses_post( $settings['content'] ); ?></p>
                            <?php endif; ?>
                            <?php if( $settings['button_url']): ?>
                                <a href="<?php echo wp_kses_post( $settings['button_url'] ); ?>" class="default-btn"><?php echo wp_kses_post( $settings['button_text'] ); ?>
                                    <i class="ti ti-arrow-narrow-right"></i>
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="all-shapes" data-cues="slideInDown">
                <?php if( $settings['shape1']['url'] != '' ): ?>
                    <div class="button">
                        <img src="<?php echo esc_url($settings['shape1']['url'] ) ?>" class="about-ball1 button__like-text"  alt="image">
                    </div>
                <?php endif; ?>
                <?php if( $settings['shape2']['url'] != '' ): ?>
                    <div class="button">
                        <img src="<?php echo esc_url($settings['shape2']['url'] ) ?>" class="about-ball2 button__like-text"  alt="image">
                    </div>
                <?php endif; ?>
                <?php if( $settings['shape3']['url'] != '' ): ?>
                    <div class="button">
                        <img src="<?php echo esc_url($settings['shape3']['url'] ) ?>" class="about-ball3 button__like-text"  alt="image">
                    </div>
                <?php endif; ?>
                <?php if( $settings['shape4']['url'] != '' ): ?>
                    <div class="button">
                        <img src="<?php echo esc_url($settings['shape4']['url'] ) ?>" class="about-ball4 button__like-text"  alt="image">
                    </div>
                <?php endif; ?>
                <?php if( $settings['shape5']['url'] != '' ): ?>
                    <div class="button">
                        <img src="<?php echo esc_url($settings['shape5']['url'] ) ?>" class="about-ball5 button__like-text"  alt="image">
                    </div>
                <?php endif; ?>
                <?php if( $settings['shape6']['url'] != '' ): ?>
                    <div class="button">
                        <img src="<?php echo esc_url($settings['shape6']['url'] ) ?>" class="about-ball6 button__like-text"  alt="image">
                    </div>
                <?php endif; ?>
                <?php if( $settings['shape7']['url'] != '' ): ?>
                    <div class="button">
                        <img src="<?php echo esc_url($settings['shape7']['url'] ) ?>" class="about-ball7 button__like-text"  alt="image">
                    </div>
                <?php endif; ?>
                <?php if( $settings['shape8']['url'] != '' ): ?>
                    <div class="button">
                        <img src="<?php echo esc_url($settings['shape8']['url'] ) ?>" class="about-ball8 button__like-text"  alt="image">
                    </div>
                <?php endif; ?>
                <?php if( $settings['shape9']['url'] != '' ): ?>
                    <div class="button">
                        <img src="<?php echo esc_url($settings['shape9']['url'] ) ?>" class="about-ball9 button__like-text"  alt="image">
                    </div>
                <?php endif; ?>
                <?php if( $settings['shape10']['url'] != '' ): ?>
                    <div class="button">
                        <img src="<?php echo esc_url($settings['shape10']['url'] ) ?>" class="about-ball10 button__like-text"  alt="image">
                    </div>
                <?php endif; ?>
                <?php if( $settings['shape11']['url'] != '' ): ?>
                    <div class="button">
                        <img src="<?php echo esc_url($settings['shape11']['url'] ) ?>" class="about-ball11 button__like-text"  alt="image">
                    </div>
                <?php endif; ?>
                <?php if( $settings['shape12']['url'] != '' ): ?>
                    <div class="button">
                        <img src="<?php echo esc_url($settings['shape12']['url'] ) ?>" class="about-ball12 button__like-text"  alt="image">
                    </div>
                <?php endif; ?>
                <?php if( $settings['shape13']['url'] != '' ): ?>
                    <div class="button">
                        <img src="<?php echo esc_url($settings['shape13']['url'] ) ?>" class="about-ball13 button__like-text"  alt="image">
                    </div>
                <?php endif; ?>
                <?php if( $settings['shape14']['url'] != '' ): ?>
                    <div class="button">
                        <img src="<?php echo esc_url($settings['shape14']['url'] ) ?>" class="about-ball14 button__like-text"  alt="image">
                    </div>
                <?php endif; ?>
                <?php if( $settings['shape15']['url'] != '' ): ?>
                    <div class="button">
                        <img src="<?php echo esc_url($settings['shape15']['url'] ) ?>" class="about-ball15 button__like-text"  alt="image">
                    </div>
                <?php endif; ?>
                <?php if( $settings['shape16']['url'] != '' ): ?>
                    <div class="button">
                        <img src="<?php echo esc_url($settings['shape16']['url'] ) ?>" class="about-ball16 button__like-text"  alt="image">
                    </div>
                <?php endif; ?>
            </div>
        </div>
        <!-- Home Five About Area End -->

        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_About_Six );