<?php
/**
 * About Three Widget
 */

namespace Elementor;
class Falar_About_Three extends Widget_Base {

	public function get_name() {
        return 'Falar_About_Three';
    }

	public function get_title() {
        return __( 'About Three', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_About_Three_Area',
			[
				'label' => __( 'About Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'about_image1',
            [
                'label'       => __( 'About Image One', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'about_image2',
            [
                'label'       => __( 'About Image Two', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'about_logo',
            [
                'label'       => __( 'Logo', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'text_shape',
            [
                'label'       => __( 'Text Shape', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );

        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('About Falar University', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content1',
            [
                'label'       => __( 'Content One', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Study! Your Future Is Here!', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content2',
            [
                'label'       => __( 'Content Three', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Gathering the most complete offer of training programmes in Canada, the 14 Facilities of the Luva offer unique conditions to those who want to build an academic path of excellence and properly valued by the labour market.', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'button_text',
            [
                'label'   => __( 'Button Text', 'falar-toolkit' ),
                'type'    => Controls_Manager::TEXT,
                'default' => __('More About Us', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'link_type',
            [
                'label' 		=> esc_html__( 'Button Link Type', 'falar-toolkit' ),
                'type' 			=> Controls_Manager::SELECT,
                'label_block' 	=> true,
                'options' => [
                    '1'  	=> esc_html__( 'Link To Page', 'falar-toolkit' ),
                    '2' 	=> esc_html__( 'External Link', 'falar-toolkit' ),
                ],
            ]
        );

        $this->add_control(
            'link_to_page',
            [
                'label' 		=> esc_html__( 'Button Link Page', 'falar-toolkit' ),
                'type' 			=> Controls_Manager::SELECT,
                'label_block' 	=> true,
                'options' 		=> falar_toolkit_get_page_as_list(),
                'condition' => [
                    'link_type' => '1',
                ]
            ]
        );

        $this->add_control(
            'ex_link',
            [
                'label'		=> esc_html__('Button External Link', 'falar-toolkit'),
                'type'		=> Controls_Manager:: TEXT,
                'condition' => [
                    'link_type' => '2',
                ]
            ]
        );

        $this->add_control(
            'shape',
            [
                'label'       => __( 'Shape', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
			'about_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .about-style2-content .content h2' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .about-style2-content .content h2',
                ]
            );
			$this->add_control(
				'content_color',
				[
					'label'     => __( 'Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .about-style2-content .content .title' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .about-style2-content .content .title',
                ]
            );
			$this->add_control(
				'content_color2',
				[
					'label'     => __( 'Content Color Two', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .about-style2-content .content p' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography2',
                    'label'    => __( 'Content Typography Two', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .about-style2-content .content p',
                ]
            );
            $this->add_control(
				'btn_color',
				[
					'label'     => __( 'Button Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .about-style2-content .about-link' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn_typography',
                    'label'    => __( 'Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .about-style2-content .about-link',
                ]
            );
            
        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Get Button Link
        $link = '#';
        if( $settings['link_type'] == 1 ){
            $link = get_page_link( $settings['link_to_page'] );
        } else {
            $link = $settings['ex_link'];
        }

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        ?>

        <!-- About Style2 Warp Start -->
        <div class="about-style2-warp ptb-100">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-7">
                        <div class="about-style2-image">
                            <div class="row">
                                <div class="col-lg-6 col-md-6" data-cue="slideInUp">
                                    <?php if( $settings['about_image1']['url'] != '' ): ?>
                                        <div class="image reveal2">
                                            <img src="<?php echo esc_url($settings['about_image1']['url'] ) ?>" alt="image">
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <div class="col-lg-6 col-md-6" data-cue="slideInUp">
                                    <?php if( $settings['about_image2']['url'] != '' ): ?>
                                        <div class="image style2 reveal3">
                                            <img src="<?php echo esc_url($settings['about_image2']['url'] ) ?>" alt="image">
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="round-shape">
                                <?php if( $settings['about_logo']['url'] != '' ): ?>
                                    <div class="image reveal2">
                                        <img src="<?php echo esc_url($settings['about_logo']['url'] ) ?>" class="main-logo" alt="image">
                                    </div>
                                <?php endif; ?>
                                <?php if( $settings['text_shape']['url'] != '' ): ?>
                                    <img src="<?php echo esc_url($settings['text_shape']['url'] ) ?>" class="text-shape" alt="image">
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-5" data-cue="slideInLeft">
                        <div class="about-style2-content">
                            <div class="content">
                                <?php if( $settings['title']): ?>
                                    <h2 class="reveal3"><?php echo wp_kses_post( $settings['title'] ); ?></h2>
                                <?php endif; ?>
                                <?php if( $settings['content1']): ?>
                                    <span class="title"><?php echo wp_kses_post( $settings['content1'] ); ?></span>
                                <?php endif; ?>
                            </div>
                            <?php if( $settings['content2']): ?>
                                <p><?php echo wp_kses_post( $settings['content2'] ); ?></p>
                            <?php endif; ?>
                            <?php if( $settings['button_text']): ?>
                                <a href="<?php echo esc_url( $link ); ?>" class="about-link">
                                    <?php echo esc_html( $settings['button_text'] ); ?>
                                    <i class="ti ti-arrow-narrow-right"></i>
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="all-shapes">
                <?php if( $settings['shape']['url'] != '' ): ?>
                    <img src="<?php echo esc_url($settings['shape']['url'] ) ?>" class="about-logo" alt="image">
                <?php endif; ?>
            </div>
        </div>
        <!-- About Style2 Warp End -->
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_About_Three );