<?php
/**
 * About Two Widget
 */

namespace Elementor;
class Falar_About_Two extends Widget_Base {

	public function get_name() {
        return 'Falar_About_Two';
    }

	public function get_title() {
        return __( 'About Two', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_About_Two_Area',
			[
				'label' => __( 'About Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'about_styles',
            [
                'label' 	=> esc_html__( 'About Style', 'falar-toolkit' ),
                'type' 		=> Controls_Manager::SELECT,
                'options' 	=> [
                    '1'         => esc_html__( 'Style One', 'falar-toolkit' ),
                    '2'         => esc_html__( 'Style Two', 'falar-toolkit' ),
                ],
                'default' => '1',
            ]
        );

        $this->add_control(
            'about_image',
            [
                'label'       => __( 'About Logo Image', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );

        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('About Falar University', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content1',
            [
                'label'       => __( 'Content One', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Study! Your Future Is Here!', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content2',
            [
                'label'       => __( 'Content Two', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Welcome to our university is website! Use the search bar below to explore our diverse range of programs.', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content3',
            [
                'label'       => __( 'Content Three', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Gathering the most complete offer of training programmes in Canada, the 14 Facilities of the Falar offer unique conditions to those who want to build an academic path of excellence and properly valued by the labour market.', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'button_text',
            [
                'label'   => __( 'Button Text', 'falar-toolkit' ),
                'type'    => Controls_Manager::TEXT,
                'default' => __('More About Us', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'link_type',
            [
                'label' 		=> esc_html__( 'Button Link Type', 'falar-toolkit' ),
                'type' 			=> Controls_Manager::SELECT,
                'label_block' 	=> true,
                'options' => [
                    '1'  	=> esc_html__( 'Link To Page', 'falar-toolkit' ),
                    '2' 	=> esc_html__( 'External Link', 'falar-toolkit' ),
                ],
            ]
        );

        $this->add_control(
            'link_to_page',
            [
                'label' 		=> esc_html__( 'Button Link Page', 'falar-toolkit' ),
                'type' 			=> Controls_Manager::SELECT,
                'label_block' 	=> true,
                'options' 		=> falar_toolkit_get_page_as_list(),
                'condition' => [
                    'link_type' => '1',
                ]
            ]
        );

        $this->add_control(
            'ex_link',
            [
                'label'		=> esc_html__('Button External Link', 'falar-toolkit'),
                'type'		=> Controls_Manager:: TEXT,
                'condition' => [
                    'link_type' => '2',
                ]
            ]
        );

        $this->add_control(
            'about_bottom_image',
            [
                'label'       => __( 'About Bottom Image', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
                'condition' => [
                    'about_styles' => '2',
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
			'about_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .about-logo-content .content h3' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .about-logo-content .content h3',
                ]
            );
			$this->add_control(
				'content_color',
				[
					'label'     => __( 'Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .about-logo-content .content p' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .about-logo-content .content p',
                ]
            );
			$this->add_control(
				'content_color2',
				[
					'label'     => __( 'Content Color Two', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .about-content p' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography2',
                    'label'    => __( 'Content Typography Two', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .about-content p',
                ]
            );
            $this->add_control(
				'btn_color',
				[
					'label'     => __( 'Button Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .about-content .about-link' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn_typography',
                    'label'    => __( 'Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .about-content .about-link',
                ]
            );
            
        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Get Button Link
        $link = '#';
        if( $settings['link_type'] == 1 ){
            $link = get_page_link( $settings['link_to_page'] );
        } else {
            $link = $settings['ex_link'];
        }

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        ?>
        <?php if ($settings['about_styles']=='1'): ?>
            <!-- About Warp Start -->
            <div class="about-warp ptb-100">
                <div class="container">
                    <div class="row g-4 align-items-center">
                        <div class="col-lg-6">
                            <div class="about-logo-content">
                                <div class="logo">
                                    <?php if( $settings['about_image']['url'] != '' ): ?>
                                        <div class="logo">
                                            <img src="<?php echo esc_url($settings['about_image']['url'] ) ?>" alt="image">
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <div class="content">
                                    <?php if( $settings['title']): ?>
                                        <h3><?php echo wp_kses_post( $settings['title'] ); ?></h3>
                                    <?php endif; ?>
                                    <?php if( $settings['content1']): ?>
                                        <p><?php echo wp_kses_post( $settings['content1'] ); ?></p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="about-content">
                                <?php if( $settings['content2']): ?>
                                    <p><?php echo wp_kses_post( $settings['content2'] ); ?></p>
                                <?php endif; ?>
                                <?php if( $settings['content3']): ?>
                                    <p><?php echo wp_kses_post( $settings['content3'] ); ?></p>
                                <?php endif; ?>
                                <?php if( $settings['button_text']): ?>
                                    <a href="<?php echo esc_url( $link ); ?>" class="about-link">
                                        <?php echo esc_html( $settings['button_text'] ); ?>
                                        <i class="ti ti-arrow-narrow-right"></i>
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- About Warp End -->
        <?php elseif($settings['about_styles']=='2'): ?>
            <!-- About Warp Start -->
            <div class="about-warp pt-100">
                <div class="container">
                    <div class="row g-4 align-items-center">
                        <div class="col-lg-6">
                            <div class="about-logo-content">
                                <div class="logo">
                                    <?php if( $settings['about_image']['url'] != '' ): ?>
                                        <div class="logo">
                                            <img src="<?php echo esc_url($settings['about_image']['url'] ) ?>" alt="image">
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <div class="content">
                                    <?php if( $settings['title']): ?>
                                        <h3><?php echo wp_kses_post( $settings['title'] ); ?></h3>
                                    <?php endif; ?>
                                    <?php if( $settings['content1']): ?>
                                        <p><?php echo wp_kses_post( $settings['content1'] ); ?></p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="about-content inner-page-about">
                                <?php if( $settings['content2']): ?>
                                    <p><?php echo wp_kses_post( $settings['content2'] ); ?></p>
                                <?php endif; ?>
                                <?php if( $settings['content3']): ?>
                                    <p><?php echo wp_kses_post( $settings['content3'] ); ?></p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- About Warp End -->

            <!-- About Images Warp Start -->
            <?php if( $settings['about_bottom_image']['url'] != '' ): ?>
                <div class="about-images-warp pb-100">
                    <div class="container">
                        <div class="inner-about-images">
                            <img src="<?php echo esc_url($settings['about_bottom_image']['url'] ) ?>" alt="image">
                        </div>
                    </div>
                </div>
            <?php endif; ?>
            <!-- About Images Warp End -->
        <?php endif; ?>
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_About_Two );