<?php
/**
 * About Widget
 */

namespace Elementor;
class Falar_About extends Widget_Base {

	public function get_name() {
        return 'Falar_About';
    }

	public function get_title() {
        return __( 'About', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_About_Area',
			[
				'label' => __( 'About About Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

            $list_items = new Repeater();

            $list_items->add_control(
                'tab_title',
                [
                    'label' => __( 'Tab Title', 'falar-toolkit' ),
                    'default' => __( 'Our Mission', 'falar-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                ]
            );
            $list_items->add_control(
                'about_image',
                [
                    'label' => __( 'About Image', 'falar-toolkit' ),
                    'type' => Controls_Manager::MEDIA,
                ]
            );
            $list_items->add_control(
                'about_shape',
                [
                    'label' => __( 'About Shape', 'falar-toolkit' ),
                    'type' => Controls_Manager::MEDIA,
                ]
            );
            $list_items->add_control(
                'card_title',
                [
                    'label' => __( 'Card Title', 'falar-toolkit' ),
                    'default' => __( 'About The Falar University', 'falar-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                ]
            );
            $list_items->add_control(
                'about_icon',
                [
                    'label' => __( 'About Icon', 'falar-toolkit' ),
                    'type' => Controls_Manager::MEDIA,
                ]
            );
            $list_items->add_control(
                'card_title2',
                [
                    'label' => __( 'Card Title Two', 'falar-toolkit' ),
                    'default' => __( 'Our Mission', 'falar-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                ]
            );
            $list_items->add_control(
                'content',
                [
                    'label' => __( 'Content', 'falar-toolkit' ),
                    'default' => __( 'The mission of Falar is to serve as a digital gateway and information hub for all members of the university community', 'falar-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                ]
            );
            $list_items->add_control(
                'btn_text1',
                [
                    'label' => __( 'Button Text One', 'falar-toolkit' ),
                    'default' => __( 'View Details', 'falar-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                ]
            );
            $list_items->add_control(
                'btn_url1',
                [
                    'label' => __( 'Button Url One', 'falar-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                ]
            );
            $list_items->add_control(
                'btn_text2',
                [
                    'label' => __( 'Button Text Two', 'falar-toolkit' ),
                    'default' => __( 'Take A Campus Tour', 'falar-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                ]
            );
            $list_items->add_control(
                'btn_url2',
                [
                    'label' => __( 'Button Url Two', 'falar-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                ]
            );
            $this->add_control(
                'tabs',
                [
                    'label' => __('Tab Items', 'adin-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'About_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'tab_title_color',
				[
					'label'     => __( 'Tab Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .mission-tab .tablinks .mission-tab-btn' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'top_title_typography',
                    'label'    => __( 'Top Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .mission-tab .tablinks .mission-tab-btn',
                ]
            );
            $this->add_control(
				'tab_title_bg_color',
				[
					'label'     => __( 'Tab Title Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .mission-tab .tablinks .mission-tab-btn' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .mission-content h3' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .mission-content h3',
                ]
            );

            $this->add_control(
				'card_title_color',
				[
					'label'     => __( 'Card Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .mission-content .mission-box h5' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'card_title_typography',
                    'label'    => __( 'Card Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .mission-content .mission-box h5',
                ]
            );
            $this->add_control(
				'card_content_color',
				[
					'label'     => __( 'Card Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .mission-content .mission-box p' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'card_content_typography',
                    'label'    => __( 'Card Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .mission-content .mission-box p',
                ]
            );
            $this->add_control(
				'card_btn_color1',
				[
					'label'     => __( 'Card Button Color One', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .mission-content .mission-box .mission-link' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'card_btn_typography',
                    'label'    => __( 'Card Button Typography One', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .mission-content .mission-box .mission-link',
                ]
            );
            $this->add_control(
				'btn_color',
				[
					'label'     => __( 'Button Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .default-btn' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn_typography',
                    'label'    => __( 'Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .default-btn',
                ]
            );
            $this->add_control(
				'btn_bg_color',
				[
					'label'     => __( 'Button background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .default-btn' => 'background-color: {{VALUE}}',
					],
				]
			);
            $this->add_control(
				'btn_bg_h_color',
				[
					'label'     => __( 'Button background Hover Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .default-btn:hover' => 'background-color: {{VALUE}}',
					],
				]
			);
            $this->add_control(
				'area_bg_color',
				[
					'label'     => __( 'Area background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .bg-FAF6F6' => 'background-color: {{VALUE}}',
					],
				]
			);


        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        
        ?>

        <!-- Mission Warp Start -->
        <div class="mission-warp pt-80 bg-FAF6F6">
            <div class="container">
                <div class="row">
                    <div class="col-lg-4">
                        <div class="mission-tab" id="myTab3" role="tablist">
                            <?php $i = 1; foreach($settings['tabs'] as $tab): ?>
                                <a class="tablinks  <?php if($i == 1): ?>active<?php endif; ?>" id="nz-tab<?php echo esc_attr($i); ?>" href="#nz-tab<?php echo esc_attr($i); ?>" data-bs-toggle="tab" data-bs-target="#nz-tab<?php echo esc_attr($i); ?>-pane" role="tab" aria-controls="nz-tab<?php echo esc_attr($i); ?>-pane" aria-selected="true">
                                    <div class="mission-tab-btn">
                                        <?php echo esc_html($tab['tab_title']); ?>
                                        <div class="icon">
                                            <i class="ti ti-arrow-narrow-right"></i>
                                        </div>
                                    </div>
                                </a>
                            <?php $i++; endforeach; ?>
                        </div>
                    </div>
                    <div class="col-lg-8">
                        <div class="tab-content" id="myTabContent">
                            <?php $tab_i = 1; foreach($settings['tabs'] as $tab): ?>
                                <div class="tabcontent tab-pane fade <?php if($tab_i == 1): ?>show active<?php endif; ?>" id="nz-tab<?php echo esc_attr($tab_i); ?>-pane" role="tabpanel" tabindex="0">
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <div class="mission-image reveal2">
                                                <?php if( $tab['about_image']['url'] != '' ): ?>
                                                    <img src="<?php echo esc_url($tab['about_image']['url'] ) ?>" alt="image">
                                                <?php endif; ?>
                                                <?php if( $tab['about_shape']['url'] != '' ): ?>
                                                    <img src="<?php echo esc_url($tab['about_shape']['url'] ) ?>" class="mission-shape" alt="image">
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="mission-content">
                                                <h3><?php echo esc_html($tab['card_title']); ?></h3>
                                                <div class="mission-box">
                                                    <?php if( $tab['about_icon']['url'] != '' ): ?>
                                                        <div class="icon">
                                                            <img src="<?php echo esc_url($tab['about_icon']['url'] ) ?>" alt="image">
                                                        </div>
                                                    <?php endif; ?>
                                                    <h5><?php echo esc_html($tab['card_title2']); ?></h5>
                                                    <p><?php echo esc_html($tab['content']); ?></p>
                                                    <a href="<?php echo esc_html($tab['btn_url1']); ?>" class="mission-link">
                                                        <span><?php echo esc_html($tab['btn_text1']); ?></span>
                                                        <i class="ti ti-arrow-narrow-right"></i>
                                                    </a>
                                                </div>
                                                <a href="<?php echo esc_html($tab['btn_url2']); ?>" class="default-btn">
                                                    <?php echo esc_html($tab['btn_text2']); ?>
                                                    <i class="ti ti-arrow-narrow-right"></i>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php $tab_i++; endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Mission Warp End -->


        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_About );