<?php
/**
 * Academic Two Widget
 */

namespace Elementor;
class Falar_Academic_Two extends Widget_Base {

	public function get_name() {
        return 'Falar_Academic_Two';
    }

	public function get_title() {
        return __( 'Academic Two', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Academic_Two_Area',
			[
				'label' => __( 'Academic Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Current Academic Students', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        $list_items = new Repeater();

            $list_items->add_control(
				'academic_image',
				[
					'label'       => __( 'Academic Image', 'falar-toolkit' ),
					'type'        => Controls_Manager::MEDIA,
				]
			);
            $list_items->add_control(
				'card_top_title',
				[
					'label'       => __( 'Card Top Title', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'card_top_title_link',
				[
					'label'       => __( 'Card Top Title Link', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'card_title',
				[
					'label'       => __( 'Card Title', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'card_link',
				[
					'label'       => __( 'Card Link', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'button_text',
				[
					'label'       => __( 'Button Text', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'default'     => __('Fees & Financial Resources', 'falar-toolkit'),
                    'label_block' => true,
				]
			);
            $this->add_control(
                'academic_item',
                [
                    'label' => esc_html__('Add Academic Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );

            $this->add_control(
                'main_button_text',
                [
                    'label'   => __( 'Main Button Text', 'falar-toolkit' ),
                    'type'    => Controls_Manager::TEXT,
                    'default' => __('View All Program', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
    
            $this->add_control(
                'link_type',
                [
                    'label' 		=> esc_html__( 'Button Link Type', 'falar-toolkit' ),
                    'type' 			=> Controls_Manager::SELECT,
                    'label_block' 	=> true,
                    'options' => [
                        '1'  	=> esc_html__( 'Link To Page', 'falar-toolkit' ),
                        '2' 	=> esc_html__( 'External Link', 'falar-toolkit' ),
                    ],
                ]
            );
    
            $this->add_control(
                'link_to_page',
                [
                    'label' 		=> esc_html__( 'Button Link Page', 'falar-toolkit' ),
                    'type' 			=> Controls_Manager::SELECT,
                    'label_block' 	=> true,
                    'options' 		=> falar_toolkit_get_page_as_list(),
                    'condition' => [
                        'link_type' => '1',
                    ]
                ]
            );
    
            $this->add_control(
                'ex_link',
                [
                    'label'		=> esc_html__('Button External Link', 'falar-toolkit'),
                    'type'		=> Controls_Manager:: TEXT,
                    'condition' => [
                        'link_type' => '2',
                    ]
                ]
            );

            $this->add_control(
				'academic_card_image',
				[
					'label'       => __( 'Academic Card Image', 'falar-toolkit' ),
					'type'        => Controls_Manager::MEDIA,
				]
			);
            $this->add_control(
                'academic_card_top_title',
                [
                    'label'       => __( 'Academic Card Title', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('Convocation', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'academic_card_top_title_link',
                [
                    'label'       => __( 'Academic Card Title Link', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('#', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'academic_card_title',
                [
                    'label'       => __( 'Academic Card Title', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('Get ready for fall convocation', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'academic_card_content',
                [
                    'label'       => __( 'Academic Card Content', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('Registration started at 24 September for convocation.', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'view_btn',
                [
                    'label'       => __( 'View Buutton Text', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('Falar Convocation', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'view_link',
                [
                    'label'       => __( 'View Buutton Link', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );

            //Site Content
            $list_item = new Repeater();

                $list_item->add_control(
                    'date_title',
                    [
                        'label'       => __( 'Date Title', 'falar-toolkit' ),
                        'type'        => Controls_Manager::TEXT,
                        'default'     => __('Important Dates', 'falar-toolkit'),
                        'label_block' => true,
                    ]
                );
                $list_item->add_control(
                    'date_text1',
                    [
                        'label'       => __( 'Important Date Text One', 'falar-toolkit' ),
                        'type'        => Controls_Manager::TEXT,
                        'default'     => __('View Full Academic Calendar', 'falar-toolkit'),
                        'label_block' => true,
                    ]
                );
                $list_item->add_control(
                    'date_url1',
                    [
                        'label'       => __( 'Important Date Url One', 'falar-toolkit' ),
                        'type'        => Controls_Manager::TEXT,
                        'default'     => __('#', 'falar-toolkit'),
                        'label_block' => true,
                    ]
                );
                $list_item->add_control(
                    'date_text2',
                    [
                        'label'       => __( 'Important Date Text Two', 'falar-toolkit' ),
                        'type'        => Controls_Manager::TEXT,
                        'default'     => __('View All Recruitment Events', 'falar-toolkit'),
                        'label_block' => true,
                    ]
                );
                $list_item->add_control(
                    'date_url2',
                    [
                        'label'       => __( 'Important Date Url Two', 'falar-toolkit' ),
                        'type'        => Controls_Manager::TEXT,
                        'default'     => __('#', 'falar-toolkit'),
                        'label_block' => true,
                    ]
                );
                $list_item->add_control(
                    'book_title',
                    [
                        'label'       => __( 'Book Title', 'falar-toolkit' ),
                        'type'        => Controls_Manager::TEXT,
                        'default'     => __('Book Now', 'falar-toolkit'),
                        'label_block' => true,
                    ]
                );
                $list_item->add_control(
                    'book_text1',
                    [
                        'label'       => __( 'Book Text One', 'falar-toolkit' ),
                        'type'        => Controls_Manager::TEXT,
                        'default'     => __('Book A Program Ad', 'falar-toolkit'),
                        'label_block' => true,
                    ]
                );
                $list_item->add_control(
                    'book_url1',
                    [
                        'label'       => __( 'Book Url One', 'falar-toolkit' ),
                        'type'        => Controls_Manager::TEXT,
                        'default'     => __('#', 'falar-toolkit'),
                        'label_block' => true,
                    ]
                );
                $list_item->add_control(
                    'book_text2',
                    [
                        'label'       => __( 'Book Text Two', 'falar-toolkit' ),
                        'type'        => Controls_Manager::TEXT,
                        'default'     => __('Book A General Campus Tour', 'falar-toolkit'),
                        'label_block' => true,
                    ]
                );
                $list_item->add_control(
                    'book_url2',
                    [
                        'label'       => __( 'Book Url Two', 'falar-toolkit' ),
                        'type'        => Controls_Manager::TEXT,
                        'default'     => __('#', 'falar-toolkit'),
                        'label_block' => true,
                    ]
                );
                $list_item->add_control(
                    'academic_date_one',
                    [
                        'label'       => __( 'Academic Date One', 'falar-toolkit' ),
                        'type'        => Controls_Manager::TEXT,
                        'default'     => __('Jan 28', 'falar-toolkit'),
                        'label_block' => true,
                    ]
                );
                $list_item->add_control(
                    'academic_date_text1',
                    [
                        'label'       => __( 'Academic Text One', 'falar-toolkit' ),
                        'type'        => Controls_Manager::TEXT,
                        'default'     => __('Thanks giving - college closed.', 'falar-toolkit'),
                        'label_block' => true,
                    ]
                );
                $list_item->add_control(
                    'academic_date_two',
                    [
                        'label'       => __( 'Academic Date Two', 'falar-toolkit' ),
                        'type'        => Controls_Manager::TEXT,
                        'default'     => __('Jan 06', 'falar-toolkit'),
                        'label_block' => true,
                    ]
                );
                $list_item->add_control(
                    'academic_date_text2',
                    [
                        'label'       => __( 'Academic Text Two', 'falar-toolkit' ),
                        'type'        => Controls_Manager::TEXT,
                        'default'     => __('Tuition Deposit Due For Winter 2024', 'falar-toolkit'),
                        'label_block' => true,
                    ]
                );
                $list_item->add_control(
                    'academic_date_url2',
                    [
                        'label'       => __( 'Academic Text Url Two', 'falar-toolkit' ),
                        'type'        => Controls_Manager::TEXT,
                        'default'     => __('#', 'falar-toolkit'),
                        'label_block' => true,
                    ]
                );
                $list_item->add_control(
                    'academic_date_three',
                    [
                        'label'       => __( 'Academic Date Three', 'falar-toolkit' ),
                        'type'        => Controls_Manager::TEXT,
                        'default'     => __('Jan 26', 'falar-toolkit'),
                        'label_block' => true,
                    ]
                );
                $list_item->add_control(
                    'academic_date_text3',
                    [
                        'label'       => __( 'Academic Text Three', 'falar-toolkit' ),
                        'type'        => Controls_Manager::TEXT,
                        'default'     => __('Balance Of Winter Tuition Fees Due', 'falar-toolkit'),
                        'label_block' => true,
                    ]
                );
                $list_item->add_control(
                    'academic_date_url3',
                    [
                        'label'       => __( 'Academic Text Url Three', 'falar-toolkit' ),
                        'type'        => Controls_Manager::TEXT,
                        'default'     => __('#', 'falar-toolkit'),
                        'label_block' => true,
                    ]
                );
            $this->add_control(
                'academic_slider_item',
                [
                    'label' => esc_html__('Add Academic Slider Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_item->get_controls(),
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'academic_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Number Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .section-title h2' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Number Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .section-title h2',
                ]
            );
            $this->add_control(
				'card_title_color',
				[
					'label'     => __( 'Card Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .academic-item .academic-card h3 a, .academic-box h3 a' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'card_title_typography',
                    'label'    => __( 'Card Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .academic-item .academic-card h3, .academic-box h3',
                ]
            );
            $this->add_control(
				'card_btn_color',
				[
					'label'     => __( 'Card Button Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .default-btn' => 'color: {{VALUE}}',
					],
				]
			);
            $this->add_control(
				'card_btn_bg_color',
				[
					'label'     => __( 'Card Button Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .default-btn' => 'background-color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'card_btn_typography',
                    'label'    => __( 'Card Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .default-btn',
                ]
            );
            $this->add_control(
				'card_btn_color2',
				[
					'label'     => __( 'Card Button Color Two', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .academic-box .default-btn' => 'color: {{VALUE}}',
					],
				]
			);
            $this->add_control(
				'card_btn_bg_color2',
				[
					'label'     => __( 'Card Button Background Color Two', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .academic-box .default-btn' => 'background-color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'card_btn_typography2',
                    'label'    => __( 'Card Button Two Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .academic-box .default-btn',
                ]
            );
            $this->add_control(
				'card_bg_color',
				[
					'label'     => __( 'Card Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .academic-item' => 'background-color: {{VALUE}}',
					],
				]
			);
            $this->add_control(
				'academic_slider_title_color',
				[
					'label'     => __( 'Academic Slider Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .academic-option .content h3' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'academic_slider_title_typography',
                    'label'    => __( 'Academic  Slider Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .academic-option .content h3',
                ]
            );
            $this->add_control(
				'academic_slider_link_color',
				[
					'label'     => __( 'Academic Slider Link Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .academic-option .content .academic-link' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'academic_slider_link_typography',
                    'label'    => __( 'Academic Slider Link Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .academic-option .content .academic-link',
                ]
            );
            $this->add_control(
				'slider_bg_color',
				[
					'label'     => __( 'Slider Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .academic-slider-warp' => 'background-color: {{VALUE}}',
					],
				]
			);


        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Get Button Link
        $link = '#';
        if( $settings['link_type'] == 1 ){
            $link = get_page_link( $settings['link_to_page'] );
        } else {
            $link = $settings['ex_link'];
        }

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $academic_item = $settings['academic_item'];
        $academic_slider_item = $settings['academic_slider_item'];
        ?>

        <!-- Academic Warp Start -->
        <div class="academic-warp ptb-100">
            <div class="container">
                <div class="section-title">
                    <?php if( $settings['title']): ?>
                        <h2 class="reveal2">
                            <?php echo wp_kses_post( $settings['title'] ); ?>
                        </h2>
                    <?php endif; ?> 
                </div>
                <div class="row g-4 align-items-center">
                    <div class="col-lg-4">
                        <div class="news-optional-item">
                            <?php $i = 1; foreach($academic_item as $item_academic): ?>
                                <div class="news-item">
                                    <div class="image">
                                        <?php if( $item_academic['academic_image']['url'] != '' ): ?>
                                            <div class="image">
                                                <a href="<?php echo wp_kses_post( $item_academic['card_link'] ); ?>">
                                                    <img src="<?php echo esc_url($item_academic['academic_image']['url'] ) ?>" alt="image">
                                                </a>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    <div class="content">
                                        <a href="<?php echo wp_kses_post( $item_academic['card_top_title_link'] ); ?>"><span class="title"><?php echo wp_kses_post( $item_academic['card_top_title'] ); ?></span></a>
                                        <h3>
                                            <a href="<?php echo wp_kses_post( $item_academic['card_link'] ); ?>">
                                                <?php echo wp_kses_post( $item_academic['card_title'] ); ?>
                                            </a>
                                        </h3>
                                        <?php if( $item_academic['card_link']): ?>
                                            <a href="<?php echo wp_kses_post( $item_academic['card_link'] ); ?>" class="news-link">
                                                <span><?php echo wp_kses_post( $item_academic['button_text'] ); ?></span>
                                                <i class="ti ti-arrow-narrow-right"></i>
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            <?php $i++; endforeach; ?>
                            <?php if( $settings['main_button_text']): ?>
                                <a href="<?php echo esc_url( $link ); ?>" class="default-btn">
                                    <?php echo esc_html( $settings['main_button_text'] ); ?>
                                    <i class="ti ti-arrow-narrow-right"></i>
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <div class="academic-box style2">
                            <div class="image">
                                <?php if( $settings['academic_card_image']['url'] != '' ): ?>
                                    <a href="<?php echo wp_kses_post( $settings['view_link'] ); ?>">
                                        <img src="<?php echo esc_url($settings['academic_card_image']['url'] ) ?>" alt="image">
                                    </a>
                                <?php endif; ?>
                            </div>
                            <div class="content">
                                <?php if( $settings['academic_card_top_title']): ?>
                                    <a href="<?php echo wp_kses_post( $settings['academic_card_top_title_link'] ); ?>"><span><?php echo wp_kses_post( $settings['academic_card_top_title'] ); ?></span></a>
                                <?php endif; ?> 
                                <?php if( $settings['academic_card_title']): ?>
                                    <h3>
                                        <a href="<?php echo wp_kses_post( $settings['view_link'] ); ?>">
                                            <?php echo wp_kses_post( $settings['academic_card_title'] ); ?>
                                        </a>
                                    </h3>
                                <?php endif; ?>
                                <?php if( $settings['academic_card_content']): ?>
                                    <p><?php echo wp_kses_post( $settings['academic_card_content'] ); ?></p>
                                <?php endif; ?>
                                <?php if( $settings['view_link']): ?>
                                    <a href="<?php echo wp_kses_post( $settings['view_link'] ); ?>" class="default-btn">
                                        <?php echo wp_kses_post( $settings['view_btn'] ); ?>
                                        <i class="ti ti-arrow-narrow-right"></i>
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <div class="academic-slider-warp">
                            <div class="swiper academic-slider">
                                <div class="swiper-wrapper">
                                    <?php foreach($academic_slider_item as $item_academic_slider): ?>
                                        <div class="swiper-slide">
                                            <div class="academic-option">
                                                <div class="content">
                                                    <?php if( $item_academic_slider['date_title']): ?>
                                                        <h3><?php echo wp_kses_post( $item_academic_slider['date_title'] ); ?></h3>
                                                    <?php endif; ?> 
                                                    <?php if( $item_academic_slider['date_text1']): ?>
                                                        <a href="<?php echo wp_kses_post( $item_academic_slider['date_url1'] ); ?>" class="academic-link">
                                                            <span><?php echo wp_kses_post( $item_academic_slider['date_text1'] ); ?></span>
                                                            <i class="ti ti-arrow-narrow-right"></i>
                                                        </a>
                                                    <?php endif; ?> 
                                                    <?php if( $item_academic_slider['date_text2']): ?>
                                                        <a href="<?php echo wp_kses_post( $item_academic_slider['date_url2'] ); ?>" class="academic-link">
                                                            <span><?php echo wp_kses_post( $item_academic_slider['date_text2'] ); ?></span>
                                                            <i class="ti ti-arrow-narrow-right"></i>
                                                        </a>
                                                    <?php endif; ?> 
                                                </div>
                                                <div class="content">
                                                    <?php if( $item_academic_slider['book_title']): ?>
                                                        <h3><?php echo wp_kses_post( $item_academic_slider['book_title'] ); ?></h3>
                                                    <?php endif; ?> 
                                                    <?php if( $item_academic_slider['book_text1']): ?>
                                                        <a href="<?php echo wp_kses_post( $item_academic_slider['book_url1'] ); ?>" class="academic-link">
                                                            <span><?php echo wp_kses_post( $item_academic_slider['book_text1'] ); ?></span>
                                                            <i class="ti ti-arrow-narrow-right"></i>
                                                        </a>
                                                    <?php endif; ?>
                                                    <?php if( $item_academic_slider['book_text2']): ?>
                                                        <a href="<?php echo wp_kses_post( $item_academic_slider['book_url2'] ); ?>" class="academic-link">
                                                            <span><?php echo wp_kses_post( $item_academic_slider['book_text2'] ); ?></span>
                                                            <i class="ti ti-arrow-narrow-right"></i>
                                                        </a>
                                                    <?php endif; ?>
                                                </div>
                                                <div class="academic-date">
                                                    <span class="title"><?php echo wp_kses_post( $item_academic_slider['academic_date_one'] ); ?></span>
                                                    <p><?php echo wp_kses_post( $item_academic_slider['academic_date_text1'] ); ?></p>
                                                </div>
                                                <div class="academic-date">
                                                    <span class="title"><?php echo wp_kses_post( $item_academic_slider['academic_date_two'] ); ?></span>
                                                    <?php if( $item_academic_slider['academic_date_text2']): ?>
                                                        <a href="<?php echo wp_kses_post( $item_academic_slider['academic_date_url2'] ); ?>" class="date-link">
                                                            <span><?php echo wp_kses_post( $item_academic_slider['academic_date_text2'] ); ?></span>
                                                            <i class="ti ti-arrow-narrow-right"></i>
                                                        </a>
                                                    <?php endif; ?>
                                                </div>
                                                <div class="academic-date">
                                                    <span class="title"><?php echo wp_kses_post( $item_academic_slider['academic_date_three'] ); ?></span>
                                                    <?php if( $item_academic_slider['academic_date_text3']): ?>
                                                        <a href="<?php echo wp_kses_post( $item_academic_slider['academic_date_url3'] ); ?>" class="date-link">
                                                            <span><?php echo wp_kses_post( $item_academic_slider['academic_date_text3'] ); ?></span>
                                                            <i class="ti ti-arrow-narrow-right"></i>
                                                        </a>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>

                                </div>
                                <div class="pagination-bullet-btn text-center">
                                    <div class="swiper-pagination2"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Academic Warp End -->
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Academic_Two );