<?php
/**
 * Administration Course Widget
 */

namespace Elementor;
class Falar_Administration_Course extends Widget_Base {

	public function get_name() {
        return 'Falar_Administration_Course';
    }

	public function get_title() {
        return __( 'Administration Course', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Administration_Course_Area',
			[
				'label' => __( 'Administration Course Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Courses', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content',
            [
                'label'       => __( 'Content', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => __('Creative, innovative learning is at the core of all Falar’s courses. Here are the courses you’ll take in this program.', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        $list_item = new Repeater();
            $list_item->add_control(
                'question_title',
                [
                    'label' => __( 'Question Title', 'falar-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                ]
            );
            $list_item->add_control(
                'question_content',
                [
                    'label' => __( 'Question Content', 'falar-toolkit' ),
                    'type' => Controls_Manager::WYSIWYG,
                ]
            );
            $this->add_control(
                'question_item',
                [
                    'label' => esc_html__('Add Question Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_item->get_controls(),
                ]
            );

        $this->add_control(
            'title2',
            [
                'label'       => __( 'Info Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Information', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        $list_items = new Repeater();

            $list_items->add_control(
				'info_title',
				[
					'label'       => __( 'Info Title', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'info',
				[
					'label'       => __( 'Info', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXTAREA,
                    'label_block' => true,
				]
			);
            $this->add_control(
                'info_item',
                [
                    'label' => esc_html__('Add Information Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );

            $this->add_control(
                'btn_text1',
                [
                    'label'       => __( 'Button Text One', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('Apply Today', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'btn_url1',
                [
                    'label'       => __( 'Button Url One', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('#', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'btn_text2',
                [
                    'label'       => __( 'Button Text Two', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('Book A Campus Tour', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'btn_url2',
                [
                    'label'       => __( 'Button Url Two', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('#', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'administration_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .administration-content .content-one h2' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .administration-content .content-one h2',
                ]
            );
			$this->add_control(
				'content_color',
				[
					'label'     => __( 'Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .administration-content .content-one p' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .administration-content .content-one p',
                ]
            );

            $this->add_control(
				'faq_title_color',
				[
					'label'     => __( 'Faq Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .administration-accordion .accordion-item .accordion-button' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'faq_title_typography',
                    'label'    => __( 'Faq Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .administration-accordion .accordion-item .accordion-button',
                ]
            );

            $this->add_control(
				'title_color2',
				[
					'label'     => __( 'Title Color Two', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .administration-small-widget h5' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography2',
                    'label'    => __( 'Title Typography Two', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .administration-small-widget h5',
                ]
            );

            $this->add_control(
				'site_info_title_color',
				[
					'label'     => __( 'Site Info Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .administration-small-widget .administration-item span' => 'color: {{VALUE}}',
					],
				]
			);
			
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'site_info_title_typography',
                    'label'    => __( 'Site Info Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .administration-small-widget .administration-item span',
                ]
            );
            $this->add_control(
				'site_info_color',
				[
					'label'     => __( 'Site Info Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .administration-small-widget .administration-item p' => 'color: {{VALUE}}',
					],
				]
			);
			
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'site_info_typography',
                    'label'    => __( 'Site Info Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .administration-small-widget .administration-item p',
                ]
            );
            $this->add_control(
				'site_area_bg_color',
				[
					'label'     => __( 'Site Area Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .administration-small-widget' => 'background: {{VALUE}}',
					],
				]
			);

            $this->add_control(
				'btn_color',
				[
					'label'     => __( 'Button Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .administration-small' => 'color: {{VALUE}}',
					],
				]
			);
			
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn_typography',
                    'label'    => __( 'Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .administration-small',
                ]
            );
            
        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $question_item = $settings['question_item'];
        $info_item     = $settings['info_item'];
        ?>

        <!-- Administration Courses Warp Start -->
        <div class="administration-warp ptb-100">
            <div class="container">
                <div class="row">
                    <div class="col-lg-8">
                        <div class="administration-content">
                            <div class="content-one">
                                <?php if( $settings['title']): ?>
                                    <h2><?php echo wp_kses_post( $settings['title'] ); ?></h2>
                                <?php endif; ?>
                                <?php if( $settings['content']): ?>
                                    <p><?php echo wp_kses_post( $settings['content'] ); ?></p>
                                <?php endif; ?>
                            </div>
                            <div class="accordion administration-accordion" id="faqAccordion">
                                <?php $i = 1;  foreach( $question_item as $item_question ): 
                                    $cl='';
                                    if ($i == 1) {
                                        $cl='';
                                    }else {
                                        $cl='collapsed';
                                    }

                                    if($i <= 30):
                                ?>
                                <?php if( $item_question['question_title']): ?>
                                <div class="accordion-item">
                                    <button class="accordion-button <?php echo esc_attr($cl); ?>" type="button" data-bs-toggle="collapse" data-bs-target="#collapse1<?php echo $i; ?>" aria-expanded="true" aria-controls="collapse1<?php echo $i; ?>">
                                        <?php echo esc_attr( $item_question['question_title']) ?>
                                    </button>
                                    <div id="collapse1<?php echo $i; ?>" class="accordion-collapse collapse <?php if($i == 1): ?>show<?php endif; ?>" data-bs-parent="#faqAccordion">
                                        <div class="accordion-body">
                                            <?php echo wp_kses_post( $item_question['question_content']) ?>
                                        </div>
                                    </div>
                                </div>
                                <?php endif; ?>
                                <?php endif; $i++; endforeach; ?>
                              </div>
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <div class="administration-small-widget">
                            <?php if( $settings['title2']): ?>
                                <h5><?php echo wp_kses_post( $settings['title2'] ); ?></h5>
                            <?php endif; ?>
                            <?php foreach($info_item as $item_info): ?>
                                <div class="administration-item">
                                    <span><?php echo wp_kses_post( $item_info['info_title'] ); ?></span>
                                    <p><?php echo wp_kses_post( $item_info['info'] ); ?></p>
                                </div>
                            <?php endforeach; ?>
                        </div>
                        <?php if( $settings['btn_url1']): ?>
                            <a href="<?php echo wp_kses_post( $settings['btn_url1'] ); ?>" class="default-btn administration-small"><?php echo wp_kses_post( $settings['btn_text1'] ); ?>
                                <i class="ti ti-arrow-narrow-right"></i>
                            </a>
                        <?php endif; ?>
                        <?php if( $settings['btn_url2']): ?>
                            <a href="<?php echo wp_kses_post( $settings['btn_url2'] ); ?>" class="administration-requirements"><?php echo wp_kses_post( $settings['btn_text2'] ); ?>
                                <i class="ti ti-arrow-narrow-right"></i>
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        <!-- Administration Overview Warp End -->
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Administration_Course );