<?php
/**
 * Administration Finance Widget
 */

namespace Elementor;
class Falar_Administration_Finance extends Widget_Base {

	public function get_name() {
        return 'Falar_Administration_Finance';
    }

	public function get_title() {
        return __( 'Administration Finance', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Administration_Finance_Area',
			[
				'label' => __( 'Administration Finance Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Fees & Financial Aid', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content',
            [
                'label'       => __( 'Content', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => __('Creative, innovative learning is at the core of all Falar’s courses. Here are the courses you’ll take in this program.', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $list_item = new Repeater();

            $list_item->add_control(
				'finance_title',
				[
					'label'       => __( 'Finance Title', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_item->add_control(
				'finance_content',
				[
					'label'       => __( 'Price', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXTAREA,
                    'label_block' => true,
				]
			);
            $this->add_control(
                'finance_item',
                [
                    'label' => esc_html__('Add Finance Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_item->get_controls(),
                ]
            );
            $this->add_control(
                'content_box',
                [
                    'label'       => __( 'Content Box', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'label_block' => true,
                ]
            );
        $this->add_control(
            'title2',
            [
                'label'       => __( 'Info Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Information', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        $list_items = new Repeater();

            $list_items->add_control(
				'info_title',
				[
					'label'       => __( 'Info Title', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'info',
				[
					'label'       => __( 'Info', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXTAREA,
                    'label_block' => true,
				]
			);
            $this->add_control(
                'info_item',
                [
                    'label' => esc_html__('Add Information Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );

            $this->add_control(
                'btn_text1',
                [
                    'label'       => __( 'Button Text One', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('Apply Today', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'btn_url1',
                [
                    'label'       => __( 'Button Url One', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('#', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'btn_text2',
                [
                    'label'       => __( 'Button Text Two', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('Book A Campus Tour', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'btn_url2',
                [
                    'label'       => __( 'Button Url Two', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('#', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'administration_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .administration-content .content-one h2' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .administration-content .content-one h2',
                ]
            );
			$this->add_control(
				'content_color',
				[
					'label'     => __( 'Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .administration-content .content-one p' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .administration-content .content-one p',
                ]
            );

            $this->add_control(
				'faq_title_color',
				[
					'label'     => __( 'Finance Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .administration-finance-item h3' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'faq_title_typography',
                    'label'    => __( 'Finance Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .administration-finance-item h3',
                ]
            );
            $this->add_control(
				'price_color',
				[
					'label'     => __( 'Price Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .administration-finance-item h1' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'price_typography',
                    'label'    => __( 'price Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .administration-finance-item h1',
                ]
            );

            $this->add_control(
				'title_color2',
				[
					'label'     => __( 'Title Color Two', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .administration-finance-content h4' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography2',
                    'label'    => __( 'Title Typography Two', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .administration-finance-content h4',
                ]
            );

            $this->add_control(
				'site_info_title_color',
				[
					'label'     => __( 'Site Info Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .administration-small-widget .administration-item span' => 'color: {{VALUE}}',
					],
				]
			);
			
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'site_info_title_typography',
                    'label'    => __( 'Site Info Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .administration-small-widget .administration-item span',
                ]
            );
            $this->add_control(
				'site_info_color',
				[
					'label'     => __( 'Site Info Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .administration-small-widget .administration-item p' => 'color: {{VALUE}}',
					],
				]
			);
			
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'site_info_typography',
                    'label'    => __( 'Site Info Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .administration-small-widget .administration-item p',
                ]
            );
            $this->add_control(
				'site_area_bg_color',
				[
					'label'     => __( 'Site Area Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .administration-small-widget' => 'background: {{VALUE}}',
					],
				]
			);

            $this->add_control(
				'btn_color',
				[
					'label'     => __( 'Button Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .administration-small' => 'color: {{VALUE}}',
					],
				]
			);
			
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn_typography',
                    'label'    => __( 'Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .administration-small',
                ]
            );
            
        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $finance_item     = $settings['finance_item'];
        $info_item        = $settings['info_item'];
        ?>

        <!-- Administration Courses Warp Start -->
        <div class="administration-warp ptb-100">
            <div class="container">
                <div class="row">
                    <div class="col-lg-8">
                        <div class="administration-content">
                            <div class="content-one">
                                <?php if( $settings['title']): ?>
                                    <h2><?php echo wp_kses_post( $settings['title'] ); ?></h2>
                                <?php endif; ?>
                                <?php if( $settings['content']): ?>
                                    <?php echo wp_kses_post( $settings['content'] ); ?>
                                <?php endif; ?>
                            </div>
                            <?php foreach($finance_item as $item_finance): ?>
                                <div class="administration-finance-item">
                                    <h3><?php echo wp_kses_post( $item_finance['finance_title'] ); ?></h3>
                                    <h1><?php echo wp_kses_post( $item_finance['finance_content'] ); ?></h1>
                                </div>
                            <?php endforeach; ?>
                            <?php if( $settings['content_box']): ?>
                                <div class="administration-finance-content">
                                    <?php echo wp_kses_post( $settings['content_box'] ); ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <div class="administration-small-widget">
                            <?php if( $settings['title2']): ?>
                                <h5><?php echo wp_kses_post( $settings['title2'] ); ?></h5>
                            <?php endif; ?>
                            <?php foreach($info_item as $item_info): ?>
                                <div class="administration-item">
                                    <span><?php echo wp_kses_post( $item_info['info_title'] ); ?></span>
                                    <p><?php echo wp_kses_post( $item_info['info'] ); ?></p>
                                </div>
                            <?php endforeach; ?>
                        </div>
                        <?php if( $settings['btn_url1']): ?>
                            <a href="<?php echo wp_kses_post( $settings['btn_url1'] ); ?>" class="default-btn administration-small"><?php echo wp_kses_post( $settings['btn_text1'] ); ?>
                                <i class="ti ti-arrow-narrow-right"></i>
                            </a>
                        <?php endif; ?>
                        <?php if( $settings['btn_url2']): ?>
                            <a href="<?php echo wp_kses_post( $settings['btn_url2'] ); ?>" class="administration-requirements"><?php echo wp_kses_post( $settings['btn_text2'] ); ?>
                                <i class="ti ti-arrow-narrow-right"></i>
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        <!-- Administration Overview Warp End -->
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Administration_Finance );