<?php
/**
 * Admission One Widget
 */

namespace Elementor;
class Falar_Admission extends Widget_Base {

	public function get_name() {
        return 'Falar_Admission';
    }

	public function get_title() {
        return __( 'Admission', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Admission_Area',
			[
				'label' => __( 'Admission Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'admission_img',
            [
                'label'       => __( 'Admission Image', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );

        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Admission & Aid', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content',
            [
                'label'       => __( 'Content One', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('At Falar University, we prepare you to launch your career by providing a supportive, creative, and professional environment from which to learn practical skills.', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        $list_items = new Repeater();

            $list_items->add_control(
				'link_content',
				[
					'label'       => __( 'Link Content', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'default'     => __('Process Overview', 'falar-toolkit'),
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'link_url',
				[
					'label'       => __( 'Link Url', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'default'     => __('#', 'falar-toolkit'),
                    'label_block' => true,
				]
			);
            $this->add_control(
                'admission_item',
                [
                    'label' => esc_html__('Add Admission Feature Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'admission_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Number Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .admission-content h3, .admission-content .h3' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Number Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .admission-content h3, .admission-content .h3',
                ]
            );
			$this->add_control(
				'content_color',
				[
					'label'     => __( 'Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .admission-content p' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .admission-content p',
                ]
            );
            $this->add_control(
				'feature_title_color',
				[
					'label'     => __( 'Link Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .admission-content .admission-list li a' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'feature_title_typography',
                    'label'    => __( 'Link Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .admission-content .admission-list li a',
                ]
            );

        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $admission_item = $settings['admission_item'];
        ?>

        <!-- Admission Warp Start -->
        <div class="admission-warp pb-100">
            <div class="container">
                <div class="row align-items-center g-4">
                    <div class="col-lg-7">
                        <?php if( $settings['admission_img']['url'] != '' ): ?>
                            <div class="admission-image reveal2">
                                <img src="<?php echo esc_url($settings['admission_img']['url'] ) ?>" alt="image">
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="col-lg-5">
                        <div class="admission-content">
                            <?php if( $settings['title']): ?>
                                <h3 class="reveal3">
                                    <?php echo wp_kses_post( $settings['title'] ); ?>
                                </h3>
                            <?php endif; ?> 
                            <?php if( $settings['content']): ?>
                                <p>
                                    <?php echo wp_kses_post( $settings['content'] ); ?>
                                </p>
                            <?php endif; ?> 
                            <ul class="admission-list">
                                <?php foreach($admission_item as $item_admission): ?>
                                    <li>
                                        <a href="<?php echo wp_kses_post( $item_admission['link_url'] ); ?>">
                                            <?php echo wp_kses_post( $item_admission['link_content'] ); ?>
                                            <i class="ti ti-arrow-narrow-right"></i>
                                        </a>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Admission Warp End -->
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Admission );