<?php
/**
 * Alumni Stories Widget
 */

namespace Elementor;
class Falar_Alumni_Stories extends Widget_Base {

	public function get_name() {
        return 'Falar_Alumni_Stories';
    }

	public function get_title() {
        return __( 'Alumni Stories', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Alumni_Stories_Area',
			[
				'label' => __( 'Alumni Stories Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Alumni Stories', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        $list_items = new Repeater();

            $list_items->add_control(
				'alumni_image',
				[
					'label'       => __( 'Alumni Image', 'falar-toolkit' ),
					'type'        => Controls_Manager::MEDIA,
				]
			);
            $list_items->add_control(
				'card_top_title',
				[
					'label'       => __( 'Card Top Title', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'card_top_title_link',
				[
					'label'       => __( 'Card Top Title Link', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'card_title',
				[
					'label'       => __( 'Card Title', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'card_link',
				[
					'label'       => __( 'Card Link', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'button_text',
				[
					'label'       => __( 'Button Text', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'default'     => __('Fees & Financial Resources', 'falar-toolkit'),
                    'label_block' => true,
				]
			);
            $this->add_control(
                'alumni_item',
                [
                    'label' => esc_html__('Add Alumni Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );

            $this->add_control(
                'main_button_text',
                [
                    'label'   => __( 'Main Button Text', 'falar-toolkit' ),
                    'type'    => Controls_Manager::TEXT,
                    'default' => __('View All Program', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
    
            $this->add_control(
                'link_type',
                [
                    'label' 		=> esc_html__( 'Button Link Type', 'falar-toolkit' ),
                    'type' 			=> Controls_Manager::SELECT,
                    'label_block' 	=> true,
                    'options' => [
                        '1'  	=> esc_html__( 'Link To Page', 'falar-toolkit' ),
                        '2' 	=> esc_html__( 'External Link', 'falar-toolkit' ),
                    ],
                ]
            );
    
            $this->add_control(
                'link_to_page',
                [
                    'label' 		=> esc_html__( 'Button Link Page', 'falar-toolkit' ),
                    'type' 			=> Controls_Manager::SELECT,
                    'label_block' 	=> true,
                    'options' 		=> falar_toolkit_get_page_as_list(),
                    'condition' => [
                        'link_type' => '1',
                    ]
                ]
            );
    
            $this->add_control(
                'ex_link',
                [
                    'label'		=> esc_html__('Button External Link', 'falar-toolkit'),
                    'type'		=> Controls_Manager:: TEXT,
                    'condition' => [
                        'link_type' => '2',
                    ]
                ]
            );

            $this->add_control(
				'alumni_card_image',
				[
					'label'       => __( 'Alumni Card Image', 'falar-toolkit' ),
					'type'        => Controls_Manager::MEDIA,
				]
			);
            $this->add_control(
                'alumni_card_top_title',
                [
                    'label'       => __( 'Alumni Card Title', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('Convocation', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'alumni_card_top_title_link',
                [
                    'label'       => __( 'Alumni Card Title Link', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('#', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'alumni_card_title',
                [
                    'label'       => __( 'Alumni Card Title', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('Get ready for fall convocation', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'alumni_card_content',
                [
                    'label'       => __( 'Alumni Card Content', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('Registration started at 24 November.', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'view_link',
                [
                    'label'       => __( 'View Buutton Link', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'alumni_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Number Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .section-warp h2' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Number Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .section-warp h2',
                ]
            );
			$this->add_control(
				'btn_color',
				[
					'label'     => __( 'Button Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .section-warp .section-link .article-link' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn_typography',
                    'label'    => __( 'Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .section-warp .section-link .article-link',
                ]
            );
            $this->add_control(
				'card_top_title_color',
				[
					'label'     => __( 'Card Top Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .article-item .content .title' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'card_top_title_typography',
                    'label'    => __( 'Card Top Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .article-item .content .title',
                ]
            );
            $this->add_control(
				'card_title_color',
				[
					'label'     => __( 'Card Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .article-item .content h3 a, .article-card .content h3 a' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'card_title_typography',
                    'label'    => __( 'Card Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .article-item .content h3, .article-card .content h3',
                ]
            );
            $this->add_control(
				'card_btn_color',
				[
					'label'     => __( 'Card Button Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .article-item .content .news-link' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'card_btn_typography',
                    'label'    => __( 'Card Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .article-item .content .news-link',
                ]
            );
            $this->add_control(
				'card_bg_color',
				[
					'label'     => __( 'Card Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .article-card .content' => 'background-color: {{VALUE}}',
					],
				]
			);

        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Get Button Link
        $link = '#';
        if( $settings['link_type'] == 1 ){
            $link = get_page_link( $settings['link_to_page'] );
        } else {
            $link = $settings['ex_link'];
        }

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $alumni_item = $settings['alumni_item'];
        ?>

        <!-- International Article Warp Start -->
        <div class="international-article-warp ptb-100 bg-EEEEF5">
            <div class="container">
                <div class="section-warp">
                    <?php if( $settings['title']): ?>
                        <h2 class="reveal2">
                            <?php echo wp_kses_post( $settings['title'] ); ?>
                        </h2>
                    <?php endif; ?> 
                    <div class="section-link">
                        <?php if( $settings['main_button_text']): ?>
                            <a href="<?php echo esc_url( $link ); ?>" class="article-link">
                                <span><?php echo esc_html( $settings['main_button_text'] ); ?></span>
                                <i class="ti ti-arrow-narrow-right"></i>
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="row g-5 align-items-center">
                    <div class="col-lg-4">
                        <?php $i = 1; foreach($alumni_item as $item_alumni): ?>
                            <?php if($i <= 2): ?>
                            <div class="article-item">
                                <div class="image">
                                    <?php if( $item_alumni['alumni_image']['url'] != '' ): ?>
                                        <div class="image">
                                            <a href="<?php echo wp_kses_post( $item_alumni['card_link'] ); ?>">
                                                <img src="<?php echo esc_url($item_alumni['alumni_image']['url'] ) ?>" alt="image">
                                            </a>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <div class="content">
                                    <a href="<?php echo wp_kses_post( $item_alumni['card_top_title_link'] ); ?>"><span class="title"><?php echo wp_kses_post( $item_alumni['card_top_title'] ); ?></span></a>
                                    <h3>
                                        <a href="<?php echo wp_kses_post( $item_alumni['card_link'] ); ?>">
                                            <?php echo wp_kses_post( $item_alumni['card_title'] ); ?>
                                        </a>
                                    </h3>
                                    <?php if( $item_alumni['card_link']): ?>
                                        <a href="<?php echo wp_kses_post( $item_alumni['card_link'] ); ?>" class="news-link">
                                            <span><?php echo wp_kses_post( $item_alumni['button_text'] ); ?></span>
                                            <i class="ti ti-arrow-narrow-right"></i>
                                        </a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endif; $i++; endforeach; ?>
                    </div>
                    <div class="col-lg-4">
                        <div class="article-card">
                            <?php if( $settings['alumni_card_image']['url'] != '' ): ?>
                                <div class="image">
                                    <a href="<?php echo wp_kses_post( $settings['view_link'] ); ?>">
                                        <img src="<?php echo esc_url($settings['alumni_card_image']['url'] ) ?>" alt="image">
                                    </a>
                                </div>
                            <?php endif; ?>
                            <div class="content">
                                <?php if( $settings['alumni_card_top_title']): ?>
                                    <a href="<?php echo wp_kses_post( $settings['alumni_card_top_title_link'] ); ?>"><span class="title"><?php echo wp_kses_post( $settings['alumni_card_top_title'] ); ?></span></a>
                                <?php endif; ?> 
                                <?php if( $settings['alumni_card_title']): ?>
                                    <h3>
                                        <a href="<?php echo wp_kses_post( $settings['view_link'] ); ?>">
                                            <?php echo wp_kses_post( $settings['alumni_card_title'] ); ?>
                                        </a>
                                    </h3>
                                <?php endif; ?>
                                <?php if( $settings['alumni_card_content']): ?>
                                    <p><?php echo wp_kses_post( $settings['alumni_card_content'] ); ?></p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <?php $i = 1; foreach($alumni_item as $item_alumni): ?>
                            <?php if($i >= 3): ?>
                            <div class="article-item style2">
                                <div class="image">
                                    <?php if( $item_alumni['alumni_image']['url'] != '' ): ?>
                                        <div class="image">
                                            <a href="<?php echo wp_kses_post( $item_alumni['card_link'] ); ?>">
                                                <img src="<?php echo esc_url($item_alumni['alumni_image']['url'] ) ?>" alt="image">
                                            </a>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <div class="content">
                                    <a href="<?php echo wp_kses_post( $item_alumni['card_top_title_link'] ); ?>"><span class="title"><?php echo wp_kses_post( $item_alumni['card_top_title'] ); ?></span></a>
                                    <h3>
                                        <a href="<?php echo wp_kses_post( $item_alumni['card_link'] ); ?>">
                                            <?php echo wp_kses_post( $item_alumni['card_title'] ); ?>
                                        </a>
                                    </h3>
                                    <?php if( $item_alumni['card_link']): ?>
                                        <a href="<?php echo wp_kses_post( $item_alumni['card_link'] ); ?>" class="news-link">
                                            <span><?php echo wp_kses_post( $item_alumni['button_text'] ); ?></span>
                                            <i class="ti ti-arrow-narrow-right"></i>
                                        </a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endif; $i++; endforeach; ?>
                    </div>
                </div>
            </div>
        </div>
        <!-- International Article Warp End -->
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Alumni_Stories );