<?php
/**
 * Apply One Widget
 */

namespace Elementor;
class Falar_Apply extends Widget_Base {

	public function get_name() {
        return 'Falar_Apply';
    }

	public function get_title() {
        return __( 'Apply', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Apply_Area',
			[
				'label' => __( 'Apply Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Apply Falar University In 3 Easy Steps', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        $list_items = new Repeater();

            $list_items->add_control(
				'apply_icon',
				[
					'label'       => __( 'Apply Card Icon', 'falar-toolkit' ),
					'type'        => Controls_Manager::MEDIA,
				]
			);
            $list_items->add_control(
				'apply_title',
				[
					'label'       => __( 'Apply Card Title', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'apply_content',
				[
					'label'       => __( 'Apply Card Content', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'apply_btn_text',
				[
					'label'       => __( 'Apply Button Text', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'apply_btn_url',
				[
					'label'       => __( 'Apply Button Url', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $this->add_control(
                'apply_item',
                [
                    'label' => esc_html__('Add Apply Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );
            $this->add_control(
				'shape',
				[
					'label'       => __( 'Shape', 'falar-toolkit' ),
					'type'        => Controls_Manager::MEDIA,
				]
			);

        $this->end_controls_section();

        $this->start_controls_section(
			'apply_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .section-title h2' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .section-title h2',
                ]
            );
			$this->add_control(
				'card_title_color',
				[
					'label'     => __( 'Card Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .apply-card h3' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'card_title_typography',
                    'label'    => __( 'Card Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .apply-card h3',
                ]
            );
            $this->add_control(
				'card_content_color',
				[
					'label'     => __( 'Card Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .apply-card p' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'card_content_typography',
                    'label'    => __( 'Card Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .apply-card p',
                ]
            );
            $this->add_control(
				'card_btn_color',
				[
					'label'     => __( 'Card Button Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .apply-card .apply-link' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'card_btn_typography',
                    'label'    => __( 'Card Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .apply-card .apply-link',
                ]
            );
            $this->add_control(
				'card_bg_color',
				[
					'label'     => __( 'Card Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .apply-card' => 'background: {{VALUE}}',
					],
				]
			);
            $this->add_control(
				'area_bg_color',
				[
					'label'     => __( 'Area Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .apply-warp' => 'background: {{VALUE}}',
					],
				]
			);

        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $apply_item = $settings['apply_item'];
        ?>

        <!-- Apply Warp Start  -->
        <div class="apply-warp ptb-100">
            <div class="container">
                <div class="section-title">
                    <?php if( $settings['title']): ?>
                        <h2 class="reveal3"><?php echo wp_kses_post( $settings['title'] ); ?></h2>
                    <?php endif; ?>
                </div>
                <div class="row justify-content-center align-items-center g-4 gx-5">
                    <?php foreach($apply_item as $item_apply): ?>
                    <div class="col-lg-4 col-md-6" data-cue="slideInUp">
                        <div class="apply-card">
                            <?php if( $item_apply['apply_icon']['url'] != '' ): ?>
                                <div class="icon">
                                    <img src="<?php echo esc_url($item_apply['apply_icon']['url'] ) ?>" alt="image">
                                </div>
                            <?php endif; ?>
                            <h3><?php echo wp_kses_post( $item_apply['apply_title'] ); ?></h3>
                            <p><?php echo wp_kses_post( $item_apply['apply_content'] ); ?></p>
                            <?php if( $item_apply['apply_btn_url']): ?>
                                <a href="<?php echo wp_kses_post( $item_apply['apply_btn_url'] ); ?>" class="apply-link">
                                    <span><?php echo wp_kses_post( $item_apply['apply_btn_text'] ); ?></span>
                                    <i class="ti ti-arrow-narrow-right"></i>
                                </a>
                            <?php endif; ?>
                        </div> 
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
            <div class="all-shapes">
                <?php if( $settings['shape']['url'] != '' ): ?>
                    <div class="icon">
                        <img src="<?php echo esc_url($settings['shape']['url'] ) ?>" class="apply-shape1" alt="image">
                    </div>
                <?php endif; ?>
            </div>
        </div>
        <!-- Apply Warp End  -->
        
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Apply );