<?php
/**
 * Athletic Widget
 */

namespace Elementor;
class Falar_Athletic extends Widget_Base {

	public function get_name() {
        return 'Falar_Athletic';
    }

	public function get_title() {
        return __( 'Athletic', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Athletic_Area',
			[
				'label' => __( 'Athletic Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Student Athletic Spotlight', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'athletic_image',
            [
                'label'       => __( 'Athletic Image', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );
        
        $this->add_control(
            'content1',
            [
                'label'       => __( 'Content One', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Lorem ipsum dolor sit amet consectetur. Odio diam mi pulvinar sit. Purus euismod imperdiet dignissim amet enim netus faucibus sit. Semper molestie urna quam aliquet. Aliquet lectus donec amet risus.', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content2',
            [
                'label'       => __( 'Content Two', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Lorem ipsum dolor sit amet consectetur. Eget rhoncus dolor malesu ada pulvinar ullamcorper condimentum venenatis.', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        
        $this->end_controls_section();

        $this->start_controls_section(
			'athletic_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .section-title h2' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .section-title h2',
                ]
            );
			$this->add_control(
				'content_color',
				[
					'label'     => __( 'Paragraph Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} p' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Paragraph Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} p',
                ]
            );
            
        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        ?>

        <!-- Athletic Spotlight Warp Start -->
        <div class="athletic-spotlight-warp ptb-100">
            <div class="container">
                <div class="inner-athletic-warp">
                    <div class="section-title">
                        <?php if( $settings['title']): ?>
                            <h2><?php echo wp_kses_post( $settings['title'] ); ?></h2>
                        <?php endif; ?>
                    </div>
                    <div class="athletic-image">
                        <?php if( $settings['athletic_image']['url'] != '' ): ?>
                            <img src="<?php echo esc_url($settings['athletic_image']['url'] ) ?>" alt="image">
                        <?php endif; ?>
                    </div>
                    <div class="row">
                        <div class="col-lg-6">
                            <?php if( $settings['content1']): ?>
                                <p><?php echo wp_kses_post( $settings['content1'] ); ?></p>
                            <?php endif; ?>
                        </div>
                        <div class="col-lg-6">
                            <?php if( $settings['content2']): ?>
                                <p><?php echo wp_kses_post( $settings['content2'] ); ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Athletic Spotlight Warp End -->
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Athletic );