<?php
/**
 * Campus Widget
 */

namespace Elementor;
class Falar_Build_Campus extends Widget_Base {

	public function get_name() {
        return 'Falar_Build_Campus';
    }

	public function get_title() {
        return __( 'Build Campus', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Build_Campus_Area',
			[
				'label' => __( 'Campus Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Our campus build lifelong friendships with students who share your interests, passions, and perspectives', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content1',
            [
                'label'       => __( 'Content One', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Falar University has the biggest campus in Canada, as well as satellite facilities in several Manhattan neighborhoods. Come visit our campus. Attend one of our public programs. Take a tour of our university. Stop by one of the area’s local restaurants or cafés.', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content2',
            [
                'label'       => __( 'Content Two', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Welcome to Falar, where knowledge meets innovation and where every student is journey to success begins.', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        $list_items = new Repeater();

            $list_items->add_control(
				'feature_text',
				[
					'label'       => __( 'Feature Text', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'feature_link',
				[
					'label'       => __( 'Feature Link', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $this->add_control(
                'campus_item',
                [
                    'label' => esc_html__('Add Campus feature Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'campus_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .build-campus-title h2' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .build-campus-title h2',
                ]
            );
            $this->add_control(
				'content_color',
				[
					'label'     => __( 'Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .build-campus-content p' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .build-campus-content p',
                ]
            );
            $this->add_control(
				'f_title_color',
				[
					'label'     => __( 'Feature Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .build-campus-list .build-list li a' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'f_title_typography',
                    'label'    => __( 'Feature Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .build-campus-list .build-list li a',
                ]
            );

        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $campus_item = $settings['campus_item'];
        ?>

        <!-- Build Campus Warp Start -->
        <div class="build-campus pb-100">
            <div class="container">
                <div class="build-campus-title">
                    <?php if( $settings['title']): ?>
                        <h2>
                            <?php echo wp_kses_post( $settings['title'] ); ?>
                        </h2>
                    <?php endif; ?> 
                </div>
                <div class="row">
                    <div class="col-lg-6">
                        <div class="build-campus-content">
                            <?php if( $settings['content1']): ?>
                                <p>
                                    <?php echo wp_kses_post( $settings['content1'] ); ?>
                                </p>
                            <?php endif; ?> 
                            <?php if( $settings['content2']): ?>
                                <p>
                                    <?php echo wp_kses_post( $settings['content2'] ); ?>
                                </p>
                            <?php endif; ?> 
                        </div>
                    </div>
                    <div class="col-lg-6 ">
                        <div class="build-campus-list">
                            <div class="row">
                                <div class="col-lg-6 col-sm-6">
                                    <ul class="build-list style1">
                                        <?php $i = 1; foreach($campus_item as $item_campus): ?>
                                            <?php if($i <= 4): ?>
                                            <li>
                                                <a href="<?php echo wp_kses_post( $item_campus['feature_link'] ); ?>">
                                                    <?php echo wp_kses_post( $item_campus['feature_text'] ); ?>
                                                    <i class="ti ti-arrow-narrow-right"></i>
                                                </a>
                                            </li>
                                        <?php endif; $i++; endforeach; ?>
                                    </ul>
                                </div>
                                <div class="col-lg-6 col-sm-6">
                                    <ul class="build-list style2">
                                        <?php $i = 1; foreach($campus_item as $item_campus): ?>
                                            <?php if($i >= 5): ?>
                                            <li>
                                                <a href="<?php echo wp_kses_post( $item_campus['feature_link'] ); ?>">
                                                    <?php echo wp_kses_post( $item_campus['feature_text'] ); ?>
                                                    <i class="ti ti-arrow-narrow-right"></i>
                                                </a>
                                            </li>
                                        <?php endif; $i++; endforeach; ?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Build Campus Warp End -->
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Build_Campus );