<?php
/**
 * Building Widget
 */

namespace Elementor;
class Falar_Building extends Widget_Base {

	public function get_name() {
        return 'Falar_Building';
    }

	public function get_title() {
        return __( 'Building', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Building_Area',
			[
				'label' => __( 'Building Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Falar University Building Hours', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content1',
            [
                'label'       => __( 'Content One', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Access to academic buildings is by reservation only. The four buildings below will be open <span>Monday - Friday</span> and closed on the weekends from September 15th through December 25th.', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content2',
            [
                'label'       => __( 'Content Two', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Monday to Friday <span>-</span> 8:00 am to 10:00 pm', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content3',
            [
                'label'       => __( 'Content Three', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Saturday to Sunday <span>-</span> Closed', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        
        $this->end_controls_section();

        $this->start_controls_section(
			'building_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .building-hours-title h2' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .building-hours-title h2',
                ]
            );
            $this->add_control(
				'content_color',
				[
					'label'     => __( 'Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .building-hours-content p' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .building-hours-content p',
                ]
            );
            $this->add_control(
				'f_title_color',
				[
					'label'     => __( 'Feature Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .building-hours-content .building-hours-list li' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'f_title_typography',
                    'label'    => __( 'Feature Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .building-hours-content .building-hours-list li',
                ]
            );
            $this->add_control(
				'f_title_color2',
				[
					'label'     => __( 'Feature Title Color Two', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .building-hours-content .building-hours-list li:last-child' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'f_title_typography2',
                    'label'    => __( 'Feature Title Typography Two', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .building-hours-content .building-hours-list li:last-child',
                ]
            );

        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        ?>

        <!-- Building Hours Warp Start -->
        <div class="building-hours-warp pb-100">
            <div class="container">
                <div class="row">
                    <div class="col-lg-6">
                        <div class="building-hours-title">
                            <?php if( $settings['title']): ?>
                                <h2>
                                    <?php echo wp_kses_post( $settings['title'] ); ?>
                                </h2>
                            <?php endif; ?> 
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="building-hours-content">
                            <?php if( $settings['content1']): ?>
                                <p>
                                    <?php echo wp_kses_post( $settings['content1'] ); ?>
                                </p>
                            <?php endif; ?> 
                            <ul class="building-hours-list">
                                <?php if( $settings['content2']): ?>
                                    <li>
                                        <?php echo wp_kses_post( $settings['content2'] ); ?>
                                    </li>
                                <?php endif; ?> 
                                <?php if( $settings['content3']): ?>
                                    <li>
                                        <?php echo wp_kses_post( $settings['content3'] ); ?>
                                    </li>
                                <?php endif; ?> 
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Building Hours Warp End -->
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Building );