<?php
/**
 * Calender Widget
 */

namespace Elementor;
class Falar_Calender extends Widget_Base {

	public function get_name() {
        return 'Falar_Calender';
    }

	public function get_title() {
        return __( 'Calender', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Calender_Area',
			[
				'label' => __( 'Calender Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Fall 2024', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        $list_item = new Repeater();

            $list_item->add_control(
				'card_top_title',
				[
					'label'       => __( 'Card Top Title', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_item->add_control(
				'card_title',
				[
					'label'       => __( 'Card Title', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_item->add_control(
				'card_link',
				[
					'label'       => __( 'Card Link', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_item->add_control(
				'link_text',
				[
					'label'       => __( 'Link Text', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'default'     => __('Add In Google Calendar', 'falar-toolkit'),
                    'label_block' => true,
				]
			);
            $list_item->add_control(
				'location',
				[
					'label'       => __( 'Location', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'default'     => __('32/6, Western Hill, Canada', 'falar-toolkit'),
                    'label_block' => true,
				]
			);
            $list_item->add_control(
				'time',
				[
					'label'       => __( 'Time', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'default'     => __('Thursday - Friday', 'falar-toolkit'),
                    'label_block' => true,
				]
			);
            $list_item->add_control(
				'date',
				[
					'label'       => __( 'Date', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'default'     => __('Feb 02 - Feb 03', 'falar-toolkit'),
                    'label_block' => true,
				]
			);
            $list_item->add_control(
				'year',
				[
					'label'       => __( 'Year', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'default'     => __('2024', 'falar-toolkit'),
                    'label_block' => true,
				]
			);
            $this->add_control(
                'calender_item',
                [
                    'label' => esc_html__('Add Calender Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_item->get_controls(),
                ]
            );

        $this->add_control(
            'title2',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Summer 2024', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        $list_items = new Repeater();

            $list_items->add_control(
                'card_top_title2',
                [
                    'label'       => __( 'Card Top Title', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );
            $list_items->add_control(
                'card_title2',
                [
                    'label'       => __( 'Card Title', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );
            $list_items->add_control(
                'card_link2',
                [
                    'label'       => __( 'Card Link', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );
            $list_items->add_control(
                'link_text2',
                [
                    'label'       => __( 'Link Text', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('Add In Google Calendar', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
            $list_items->add_control(
                'location2',
                [
                    'label'       => __( 'Location', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('32/6, Western Hill, Canada', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
            $list_items->add_control(
                'time2',
                [
                    'label'       => __( 'Time', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('Thursday - Friday', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
            $list_items->add_control(
                'date2',
                [
                    'label'       => __( 'Date', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('Feb 02 - Feb 03', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
            $list_items->add_control(
                'year2',
                [
                    'label'       => __( 'Year', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('2024', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'calender_item2',
                [
                    'label' => esc_html__('Add Calender Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );

            $this->add_control(
                'title3',
                [
                    'label'       => __( 'Title', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );
    
            $list_itemss = new Repeater();
    
                $list_itemss->add_control(
                    'card_top_title3',
                    [
                        'label'       => __( 'Card Top Title', 'falar-toolkit' ),
                        'type'        => Controls_Manager::TEXT,
                        'label_block' => true,
                    ]
                );
                $list_itemss->add_control(
                    'card_title3',
                    [
                        'label'       => __( 'Card Title', 'falar-toolkit' ),
                        'type'        => Controls_Manager::TEXT,
                        'label_block' => true,
                    ]
                );
                $list_itemss->add_control(
                    'card_link3',
                    [
                        'label'       => __( 'Card Link', 'falar-toolkit' ),
                        'type'        => Controls_Manager::TEXT,
                        'label_block' => true,
                    ]
                );
                $list_itemss->add_control(
                    'link_text3',
                    [
                        'label'       => __( 'Link Text', 'falar-toolkit' ),
                        'type'        => Controls_Manager::TEXT,
                        'default'     => __('Add In Google Calendar', 'falar-toolkit'),
                        'label_block' => true,
                    ]
                );
                $list_itemss->add_control(
                    'location3',
                    [
                        'label'       => __( 'Location', 'falar-toolkit' ),
                        'type'        => Controls_Manager::TEXT,
                        'default'     => __('32/6, Western Hill, Canada', 'falar-toolkit'),
                        'label_block' => true,
                    ]
                );
                $list_itemss->add_control(
                    'time3',
                    [
                        'label'       => __( 'Time', 'falar-toolkit' ),
                        'type'        => Controls_Manager::TEXT,
                        'default'     => __('Thursday - Friday', 'falar-toolkit'),
                        'label_block' => true,
                    ]
                );
                $list_itemss->add_control(
                    'date3',
                    [
                        'label'       => __( 'Date', 'falar-toolkit' ),
                        'type'        => Controls_Manager::TEXT,
                        'default'     => __('Feb 02 - Feb 03', 'falar-toolkit'),
                        'label_block' => true,
                    ]
                );
                $list_itemss->add_control(
                    'year3',
                    [
                        'label'       => __( 'Year', 'falar-toolkit' ),
                        'type'        => Controls_Manager::TEXT,
                        'default'     => __('2024', 'falar-toolkit'),
                        'label_block' => true,
                    ]
                );
                $this->add_control(
                    'calender_item3',
                    [
                        'label' => esc_html__('Add Calender Item', 'falar-toolkit'),
                        'type' => Controls_Manager::REPEATER,
                        'fields' => $list_itemss->get_controls(),
                    ]
                ); 
                
        $this->add_control(
            'title4',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $list_itemsss = new Repeater();

            $list_itemsss->add_control(
                'card_top_title4',
                [
                    'label'       => __( 'Card Top Title', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );
            $list_itemsss->add_control(
                'card_title4',
                [
                    'label'       => __( 'Card Title', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );
            $list_itemsss->add_control(
                'card_link4',
                [
                    'label'       => __( 'Card Link', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );
            $list_itemsss->add_control(
                'link_text4',
                [
                    'label'       => __( 'Link Text', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('Add In Google Calendar', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
            $list_itemsss->add_control(
                'location4',
                [
                    'label'       => __( 'Location', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('32/6, Western Hill, Canada', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
            $list_itemsss->add_control(
                'time4',
                [
                    'label'       => __( 'Time', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('Thursday - Friday', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
            $list_itemsss->add_control(
                'date4',
                [
                    'label'       => __( 'Date', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('Feb 02 - Feb 03', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
            $list_itemsss->add_control(
                'year4',
                [
                    'label'       => __( 'Year', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('2024', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'calender_item4',
                [
                    'label' => esc_html__('Add Calender Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_itemsss->get_controls(),
                ]
            ); 
            $this->add_control(
                'title5',
                [
                    'label'       => __( 'Title', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );
    
        $list_itemssss = new Repeater();

            $list_itemssss->add_control(
                'card_top_title5',
                [
                    'label'       => __( 'Card Top Title', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );
            $list_itemssss->add_control(
                'card_title5',
                [
                    'label'       => __( 'Card Title', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );
            $list_itemssss->add_control(
                'card_link5',
                [
                    'label'       => __( 'Card Link', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );
            $list_itemssss->add_control(
                'link_text5',
                [
                    'label'       => __( 'Link Text', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('Add In Google Calendar', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
            $list_itemssss->add_control(
                'location5',
                [
                    'label'       => __( 'Location', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('32/6, Western Hill, Canada', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
            $list_itemssss->add_control(
                'time5',
                [
                    'label'       => __( 'Time', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('Thursday - Friday', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
            $list_itemssss->add_control(
                'date5',
                [
                    'label'       => __( 'Date', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('Feb 02 - Feb 03', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
            $list_itemssss->add_control(
                'year5',
                [
                    'label'       => __( 'Year', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('2024', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'calender_item5',
                [
                    'label' => esc_html__('Add Calender Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_itemssss->get_controls(),
                ]
            );    
    

        $this->end_controls_section();

        $this->start_controls_section(
			'calender_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Number Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .blog-title h2' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Number Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .blog-title h2',
                ]
            );
            $this->add_control(
				'card_title_color',
				[
					'label'     => __( 'Card Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .academic-item-date .academic-event-content h3' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'card_title_typography',
                    'label'    => __( 'Card Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .academic-item-date .academic-event-content h3, .calender-box h3',
                ]
            );
            $this->add_control(
				'card_btn_color',
				[
					'label'     => __( 'Card Button Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .academic-item-date .academic-event-content .academic-list li:first-child a' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'card_btn_typography',
                    'label'    => __( 'Card Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .academic-item-date .academic-event-content .academic-list li:first-child a',
                ]
            );
            $this->add_control(
				'card_bg_color',
				[
					'label'     => __( 'Card Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .academic-item-date' => 'background-color: {{VALUE}}',
					],
				]
			);

            $this->add_control(
				'card_bg_color2',
				[
					'label'     => __( 'Card Background Color two', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .academic-item-date .date-box' => 'background-color: {{VALUE}}',
					],
				]
			);

        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $calender_item = $settings['calender_item'];
        $calender_item2 = $settings['calender_item2'];
        $calender_item3 = $settings['calender_item3'];
        $calender_item4 = $settings['calender_item4'];
        $calender_item5 = $settings['calender_item5'];
        ?>

        
        <?php if( $settings['title']): ?>
            <!-- Academic Calender Warp Start -->
            <div class="academic-calender-warp pb-100">
                <div class="container">
                    <?php if( $settings['title']): ?>
                        <h2 class="blog-title">
                            <?php echo wp_kses_post( $settings['title'] ); ?>
                        </h2>
                    <?php endif; ?> 
                    <?php $i = 1; foreach($calender_item as $item_calender): ?>
                        <div class="academic-item-date">
                            <div class="academic-event-content">
                                <span><?php echo wp_kses_post( $item_calender['card_top_title'] ); ?></span>
                                <h3>
                                    <?php echo wp_kses_post( $item_calender['card_title'] ); ?>
                                </h3>
                                <ul class="academic-list">
                                    <?php if( $item_calender['link_text']): ?>
                                        <li>
                                            <i class="ti ti-calendar"></i>
                                            <a href="<?php echo wp_kses_post( $item_calender['card_link'] ); ?>" target="_blank"> <?php echo wp_kses_post( $item_calender['link_text'] ); ?></a>
                                        </li>
                                    <?php endif; ?> 
                                    <?php if( $item_calender['location']): ?>
                                        <li>
                                            <i class="ti ti-map-pin"></i>
                                            <?php echo wp_kses_post( $item_calender['location'] ); ?>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                            <div class="date-box">
                                <div class="dot"></div>
                                <p><?php echo wp_kses_post( $item_calender['time'] ); ?></p>
                                <h4><?php echo wp_kses_post( $item_calender['date'] ); ?></h4>
                                <span><?php echo wp_kses_post( $item_calender['year'] ); ?></span>
                            </div>
                        </div>
                    <?php $i++; endforeach; ?>
                </div>
            </div>
            <!-- Academic Calender Warp End -->
        <?php endif; ?>
        <?php if( $settings['title2']): ?>
            <!-- Academic Calender Warp Start -->
            <div class="academic-calender-warp pb-100">
                <div class="container">
                    <?php if( $settings['title2']): ?>
                        <h2 class="blog-title">
                            <?php echo wp_kses_post( $settings['title2'] ); ?>
                        </h2>
                    <?php endif; ?> 
                    <?php $i = 1; foreach($calender_item2 as $item_calender2): ?>
                        <div class="academic-item-date">
                            <div class="academic-event-content">
                                <span><?php echo wp_kses_post( $item_calender2['card_top_title2'] ); ?></span>
                                <h3>
                                    <?php echo wp_kses_post( $item_calender2['card_title2'] ); ?>
                                </h3>
                                <ul class="academic-list">
                                    <?php if( $item_calender2['link_text2']): ?>
                                        <li>
                                            <i class="ti ti-calendar"></i>
                                            <a href="<?php echo wp_kses_post( $item_calender2['card_link2'] ); ?>" target="_blank"> <?php echo wp_kses_post( $item_calender2['link_text2'] ); ?></a>
                                        </li>
                                    <?php endif; ?> 
                                    <?php if( $item_calender2['location2']): ?>
                                        <li>
                                            <i class="ti ti-map-pin"></i>
                                            <?php echo wp_kses_post( $item_calender2['location2'] ); ?>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                            <div class="date-box">
                                <div class="dot"></div>
                                <p><?php echo wp_kses_post( $item_calender2['time2'] ); ?></p>
                                <h4><?php echo wp_kses_post( $item_calender2['date2'] ); ?></h4>
                                <span><?php echo wp_kses_post( $item_calender2['year2'] ); ?></span>
                            </div>
                        </div>
                    <?php $i++; endforeach; ?>
                </div>
            </div>
            <!-- Academic Calender Warp End -->
        <?php endif; ?>
        <?php if( $settings['title3']): ?>
            <!-- Academic Calender Warp Start -->
            <div class="academic-calender-warp pb-100">
                <div class="container">
                    <?php if( $settings['title3']): ?>
                        <h2 class="blog-title">
                            <?php echo wp_kses_post( $settings['title3'] ); ?>
                        </h2>
                    <?php endif; ?> 
                    <?php $i = 1; foreach($calender_item3 as $item_calender3): ?>
                        <div class="academic-item-date">
                            <div class="academic-event-content">
                                <span><?php echo wp_kses_post( $item_calender3['card_top_title3'] ); ?></span>
                                <h3>
                                    <?php echo wp_kses_post( $item_calender3['card_title3'] ); ?>
                                </h3>
                                <ul class="academic-list">
                                    <?php if( $item_calender3['link_text3']): ?>
                                        <li>
                                            <i class="ti ti-calendar"></i>
                                            <a href="<?php echo wp_kses_post( $item_calender3['card_link3'] ); ?>" target="_blank"> <?php echo wp_kses_post( $item_calender3['link_text3'] ); ?></a>
                                        </li>
                                    <?php endif; ?> 
                                    <?php if( $item_calender3['location3']): ?>
                                        <li>
                                            <i class="ti ti-map-pin"></i>
                                            <?php echo wp_kses_post( $item_calender3['location3'] ); ?>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                            <div class="date-box">
                                <div class="dot"></div>
                                <p><?php echo wp_kses_post( $item_calender3['time3'] ); ?></p>
                                <h4><?php echo wp_kses_post( $item_calender3['date3'] ); ?></h4>
                                <span><?php echo wp_kses_post( $item_calender3['year3'] ); ?></span>
                            </div>
                        </div>
                    <?php $i++; endforeach; ?>
                </div>
            </div>
            <!-- Academic Calender Warp End -->
        <?php endif; ?>
        <?php if( $settings['title4']): ?>
            <!-- Academic Calender Warp Start -->
            <div class="academic-calender-warp pb-100">
                <div class="container">
                    <?php if( $settings['title4']): ?>
                        <h2 class="blog-title">
                            <?php echo wp_kses_post( $settings['title4'] ); ?>
                        </h2>
                    <?php endif; ?> 
                    <?php $i = 1; foreach($calender_item4 as $item_calender4): ?>
                        <div class="academic-item-date">
                            <div class="academic-event-content">
                                <span><?php echo wp_kses_post( $item_calender4['card_top_title4'] ); ?></span>
                                <h3>
                                    <?php echo wp_kses_post( $item_calender4['card_title4'] ); ?>
                                </h3>
                                <ul class="academic-list">
                                    <?php if( $item_calender4['link_text4']): ?>
                                        <li>
                                            <i class="ti ti-calendar"></i>
                                            <a href="<?php echo wp_kses_post( $item_calender4['card_link4'] ); ?>" target="_blank"> <?php echo wp_kses_post( $item_calender4['link_text4'] ); ?></a>
                                        </li>
                                    <?php endif; ?> 
                                    <?php if( $item_calender4['location4']): ?>
                                        <li>
                                            <i class="ti ti-map-pin"></i>
                                            <?php echo wp_kses_post( $item_calender4['location4'] ); ?>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                            <div class="date-box">
                                <div class="dot"></div>
                                <p><?php echo wp_kses_post( $item_calender4['time4'] ); ?></p>
                                <h4><?php echo wp_kses_post( $item_calender4['date4'] ); ?></h4>
                                <span><?php echo wp_kses_post( $item_calender4['year4'] ); ?></span>
                            </div>
                        </div>
                    <?php $i++; endforeach; ?>
                </div>
            </div>
            <!-- Academic Calender Warp End -->
        <?php endif; ?>
        <?php if( $settings['title5']): ?>
            <!-- Academic Calender Warp Start -->
            <div class="academic-calender-warp pb-100">
                <div class="container">
                    <?php if( $settings['title5']): ?>
                        <h2 class="blog-title">
                            <?php echo wp_kses_post( $settings['title5'] ); ?>
                        </h2>
                    <?php endif; ?> 
                    <?php $i = 1; foreach($calender_item5 as $item_calender5): ?>
                        <div class="academic-item-date">
                            <div class="academic-event-content">
                                <span><?php echo wp_kses_post( $item_calender5['card_top_title5'] ); ?></span>
                                <h3>
                                    <?php echo wp_kses_post( $item_calender5['card_title5'] ); ?>
                                </h3>
                                <ul class="academic-list">
                                    <?php if( $item_calender5['link_text5']): ?>
                                        <li>
                                            <i class="ti ti-calendar"></i>
                                            <a href="<?php echo wp_kses_post( $item_calender5['card_link5'] ); ?>" target="_blank"> <?php echo wp_kses_post( $item_calender5['link_text5'] ); ?></a>
                                        </li>
                                    <?php endif; ?> 
                                    <?php if( $item_calender5['location5']): ?>
                                        <li>
                                            <i class="ti ti-map-pin"></i>
                                            <?php echo wp_kses_post( $item_calender5['location5'] ); ?>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                            <div class="date-box">
                                <div class="dot"></div>
                                <p><?php echo wp_kses_post( $item_calender5['time5'] ); ?></p>
                                <h4><?php echo wp_kses_post( $item_calender5['date5'] ); ?></h4>
                                <span><?php echo wp_kses_post( $item_calender5['year5'] ); ?></span>
                            </div>
                        </div>
                    <?php $i++; endforeach; ?>
                </div>
            </div>
            <!-- Academic Calender Warp End -->
        <?php endif; ?>
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Calender );