<?php
/**
 * Contact Widget
 */

namespace Elementor;
class Falar_Contact extends Widget_Base {

	public function get_name() {
        return 'Falar_Contact';
    }

	public function get_title() {
        return __( 'Contact', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Contact_Area',
			[
				'label' => __( 'Contact Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Contact Information', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'title2',
            [
                'label'       => __( 'Title Two', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Keep In Touch, We Want To Hear From You - Send Us Message', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        
        $list_items = new Repeater();

            $list_items->add_control(
				'info_title',
				[
					'label'       => __( 'Info Title', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'info',
				[
					'label'       => __( 'Info', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXTAREA,
                    'label_block' => true,
				]
			);
            $this->add_control(
                'info_item',
                [
                    'label' => esc_html__('Add Information Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );
            $this->add_control(
                'social_title',
                [
                    'label'       => __( 'Social Title', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('Social Media:', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
            
        $list_item = new Repeater();

            $list_item->add_control(
				'social_icon',
				[
					'label'       => __( 'Social Icon', 'falar-toolkit' ),
					'type'        => Controls_Manager::MEDIA,
				]
			);
            $list_item->add_control(
				'social_url',
				[
					'label'       => __( 'Social Url', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $this->add_control(
                'social_item',
                [
                    'label' => esc_html__('Add Social Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_item->get_controls(),
                ]
            );

            $this->add_control(
                'shortcode',
                [
                    'label'   => __( 'Contact Form Shortcode', 'falar-toolkit' ),
                    'type'    => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'contact_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .contact-small-widget h5' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .contact-small-widget h5',
                ]
            );

            $this->add_control(
				'info_title_color',
				[
					'label'     => __( 'Info Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .contact-small-widget .contact-item span' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'info_title_typography',
                    'label'    => __( 'Info Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .contact-small-widget .contact-item span',
                ]
            );
            $this->add_control(
				'info_content_color',
				[
					'label'     => __( 'Info Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .contact-small-widget .contact-item p' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'info_content_typography',
                    'label'    => __( 'Info Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .contact-small-widget .contact-item p',
                ]
            );

            $this->add_control(
				'info_bg_color',
				[
					'label'     => __( 'Info Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .contact-small-widget' => 'background: {{VALUE}}',
					],
				]
			);

            $this->add_control(
				'title_color2',
				[
					'label'     => __( 'Title Color Two', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .blog-title h2' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography2',
                    'label'    => __( 'Title Typography Two', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .blog-title h2',
                ]
            );

            $this->add_control(
				'btn_color',
				[
					'label'     => __( 'Button Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .default-btn' => 'color: {{VALUE}}',
					],
				]
			);
            $this->add_control(
				'btn_bg_color',
				[
					'label'     => __( 'Button Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .default-btn' => 'background: {{VALUE}}',
					],
				]
			);
			
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn_typography',
                    'label'    => __( 'Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .default-btn',
                ]
            );
            
        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $info_item        = $settings['info_item'];
        $social_item      = $settings['social_item'];
        ?>

        <!-- Main Contact Warp Start -->
       <div class="main-contact-warp ptb-100">
            <div class="container">
                <div class="row g-5">
                    <div class="col-lg-4">
                        <div class="contact-small-widget">
                            <?php if( $settings['title']): ?>
                                <h5><?php echo wp_kses_post( $settings['title'] ); ?></h5>
                            <?php endif; ?>
                            <?php foreach($info_item as $item_info): ?>
                                <div class="contact-item">
                                    <span><?php echo wp_kses_post( $item_info['info_title'] ); ?></span>
                                    <?php echo wp_kses_post( $item_info['info'] ); ?>
                                </div>
                            <?php endforeach; ?>
                            <div class="contact-item">
                                <?php if( $settings['social_title']): ?>
                                    <span><?php echo wp_kses_post( $settings['social_title'] ); ?></span>
                                <?php endif; ?>
                                <ul class="social-list">
                                    <?php foreach($social_item as $item_social): ?>
                                        <li>
                                            <a href="<?php echo wp_kses_post( $item_social['social_url'] ); ?>" target="_blank" class="icon">
                                                <?php if( $item_social['social_icon']['url'] != '' ): ?>
                                                    <img src="<?php echo esc_url($item_social['social_icon']['url'] ) ?>" alt="image">
                                                <?php endif; ?>
                                            </a>
                                        </li>
                                    <?php endforeach; ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-8">
                        <div class="main-contact-content">
                            <div class="blog-title">
                                <?php if( $settings['title2']): ?>
                                    <h2><?php echo wp_kses_post( $settings['title2'] ); ?></h2>
                                <?php endif; ?>
                            </div>
                            <div class="contact-form">
                                <?php echo do_shortcode( $settings['shortcode'] ); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
       </div>
       <!-- Main Contact Warp End -->
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Contact );