<?php
/**
 * Culture One Widget
 */

namespace Elementor;
class Falar_Culture extends Widget_Base {

	public function get_name() {
        return 'Falar_Culture';
    }

	public function get_title() {
        return __( 'Culture', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Culture_Area',
			[
				'label' => __( 'Culture Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $list_items = new Repeater();

            $list_items->add_control(
				'culture_image',
				[
					'label'       => __( 'Culture Image', 'falar-toolkit' ),
					'type'        => Controls_Manager::MEDIA,
				]
			);
            $list_items->add_control(
				'card_title',
				[
					'label'       => __( 'Card Title', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'content',
				[
					'label'       => __( 'Content', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'btn_text',
				[
					'label'       => __( 'Button text', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'btn_url',
				[
					'label'       => __( 'Button Url', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $this->add_control(
                'culture_item',
                [
                    'label' => esc_html__('Add Culture Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'culture_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Card Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .culture-box .content h3 a' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Card Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .culture-box .content h3',
                ]
            );
            $this->add_control(
				'content_color',
				[
					'label'     => __( 'Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .culture-box .content p' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .culture-box .content p',
                ]
            );
            $this->add_control(
				'content_btn_color',
				[
					'label'     => __( 'Card Button Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .culture-box .content .culture-link' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'card_btn_typography',
                    'label'    => __( 'Card Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .culture-box .content .culture-link',
                ]
            );

        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $culture_item = $settings['culture_item'];
        ?>

        <!-- Culture Warp Start -->
        <div class="culture-warp">
            <div class="container-fluid">
                <div class="row g-0">
                    <?php foreach($culture_item as $item_culture): ?>
                        <div class="col-lg-6">
                            <div class="culture-box">
                                <?php if( $item_culture['culture_image']['url'] != '' ): ?>
                                    <img src="<?php echo esc_url($item_culture['culture_image']['url'] ) ?>" alt="image">
                                <?php endif; ?>
                                <div class="content">
                                    <h3>
                                        <a href="<?php echo wp_kses_post( $item_culture['btn_url'] ); ?>"><?php echo wp_kses_post( $item_culture['card_title'] ); ?></a>
                                    </h3>
                                    <p><?php echo wp_kses_post( $item_culture['content'] ); ?></p>
                                    <a href="<?php echo wp_kses_post( $item_culture['btn_url'] ); ?>" class="culture-link">
                                        <span><?php echo wp_kses_post( $item_culture['btn_text'] ); ?></span>
                                        <i class="ti ti-arrow-narrow-right"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
        <!-- Culture Warp End -->
        
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Culture );