<?php
/**
 * Document Widget
 */

namespace Elementor;
class Falar_Document_Form extends Widget_Base {

	public function get_name() {
        return 'Falar_Document_Form';
    }

	public function get_title() {
        return __( 'Document Form', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Document_Area',
			[
				'label' => __( 'Document Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => __('Upload educational and English proficiency documents to the folders below', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content',
            [
                'label'       => __( 'Content', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => __('Please click on the download button to preview each document ensuring the document has been uploaded successfully and can be read clearly.Within each section, please upload documents as one file not exceeding 10MB using the following file types: PDF, JPG, PNG, GIF, DOC and DOCX', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
            $this->add_control(
                'shortcode',
                [
                    'label'   => __( 'Form Form Shortcode', 'falar-toolkit' ),
                    'type'    => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'document_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .document-small-widget h5' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .document-small-widget h5',
                ]
            );

            $this->add_control(
				'info_title_color',
				[
					'label'     => __( 'Info Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .document-small-widget .document-item span' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'info_title_typography',
                    'label'    => __( 'Info Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .document-small-widget .document-item span',
                ]
            );
            $this->add_control(
				'info_content_color',
				[
					'label'     => __( 'Info Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .document-small-widget .document-item p' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'info_content_typography',
                    'label'    => __( 'Info Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .document-small-widget .document-item p',
                ]
            );

            $this->add_control(
				'info_bg_color',
				[
					'label'     => __( 'Info Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .document-small-widget' => 'background: {{VALUE}}',
					],
				]
			);

            $this->add_control(
				'title_color2',
				[
					'label'     => __( 'Title Color Two', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .blog-title h2' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography2',
                    'label'    => __( 'Title Typography Two', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .blog-title h2',
                ]
            );

            $this->add_control(
				'btn_color',
				[
					'label'     => __( 'Button Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .default-btn' => 'color: {{VALUE}}',
					],
				]
			);
            $this->add_control(
				'btn_bg_color',
				[
					'label'     => __( 'Button Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .default-btn' => 'background: {{VALUE}}',
					],
				]
			);
			
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn_typography',
                    'label'    => __( 'Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .default-btn',
                ]
            );
            
        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        ?>

        <!-- Document Form Warp Start -->
        <div class="document-warp pb-100">
            <div class="container">
                <div class="document-content">
                    <?php if( $settings['title']): ?>
                        <h4><?php echo wp_kses_post( $settings['title'] ); ?></h4>
                    <?php endif; ?>
                    <?php if( $settings['content']): ?>
                        <p><?php echo wp_kses_post( $settings['content'] ); ?></p>
                    <?php endif; ?>
                </div>
                <?php echo do_shortcode( $settings['shortcode'] ); ?>
            </div>
        </div>
        <!-- Document Form Warp End -->
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Document_Form );