<?php
/**
 * Donate Two Widget
 */

namespace Elementor;
class Falar_Donate_Two extends Widget_Base {

	public function get_name() {
        return 'Falar_Donate_Two';
    }

	public function get_title() {
        return __( 'Donate Two', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Donate_Area',
			[
				'label' => __( 'Donate Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'donate_image',
            [
                'label'       => __( 'Donate Logo Image', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );

        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Help create an Unlimited future for Falar students.', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'button_text',
            [
                'label'   => __( 'Button Text', 'falar-toolkit' ),
                'type'    => Controls_Manager::TEXT,
                'default' => __('Donate Today', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'link_type',
            [
                'label' 		=> esc_html__( 'Button Link Type', 'falar-toolkit' ),
                'type' 			=> Controls_Manager::SELECT,
                'label_block' 	=> true,
                'options' => [
                    '1'  	=> esc_html__( 'Link To Page', 'falar-toolkit' ),
                    '2' 	=> esc_html__( 'External Link', 'falar-toolkit' ),
                ],
            ]
        );

        $this->add_control(
            'link_to_page',
            [
                'label' 		=> esc_html__( 'Button Link Page', 'falar-toolkit' ),
                'type' 			=> Controls_Manager::SELECT,
                'label_block' 	=> true,
                'options' 		=> falar_toolkit_get_page_as_list(),
                'condition' => [
                    'link_type' => '1',
                ]
            ]
        );

        $this->add_control(
            'ex_link',
            [
                'label'		=> esc_html__('Button External Link', 'falar-toolkit'),
                'type'		=> Controls_Manager:: TEXT,
                'default' => __('#', 'falar-toolkit'),
                'condition' => [
                    'link_type' => '2',
                ]
            ]
        );

        $this->add_control(
            'donate_image2',
            [
                'label'       => __( 'Donate Logo Image', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );

        $this->add_control(
            'title2',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Strategic Plan 2024-25', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'button_text2',
            [
                'label'   => __( 'Button Text', 'falar-toolkit' ),
                'type'    => Controls_Manager::TEXT,
                'default' => __('View Now', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'link_type2',
            [
                'label' 		=> esc_html__( 'Button Link Type', 'falar-toolkit' ),
                'type' 			=> Controls_Manager::SELECT,
                'label_block' 	=> true,
                'options' => [
                    '1'  	=> esc_html__( 'Link To Page', 'falar-toolkit' ),
                    '2' 	=> esc_html__( 'External Link', 'falar-toolkit' ),
                ],
            ]
        );

        $this->add_control(
            'link_to_page2',
            [
                'label' 		=> esc_html__( 'Button Link Page', 'falar-toolkit' ),
                'type' 			=> Controls_Manager::SELECT,
                'label_block' 	=> true,
                'options' 		=> falar_toolkit_get_page_as_list(),
                'condition' => [
                    'link_type' => '1',
                ]
            ]
        );

        $this->add_control(
            'ex_link2',
            [
                'label'		=> esc_html__('Button External Link', 'falar-toolkit'),
                'type'		=> Controls_Manager:: TEXT,
                'default' => __('#', 'falar-toolkit'),
                'condition' => [
                    'link_type' => '2',
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
			'donate_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .home-four-donate .content h6' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .home-four-donate .content h6',
                ]
            );
			$this->add_control(
				'btn_color',
				[
					'label'     => __( 'Button Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .home-four-donate .content .donate-link' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn_typography',
                    'label'    => __( 'Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .home-four-donate .content .donate-link',
                ]
            );
            $this->add_control(
				'card_bg_color',
				[
					'label'     => __( 'Card Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .home-four-donate' => 'background: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'btn_color2',
				[
					'label'     => __( 'Button Color Two', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .home-four-donate .content .donate-link.style2' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn_typography2',
                    'label'    => __( 'Button Typography Two', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .home-four-donate .content .donate-link.style2',
                ]
            );
            $this->add_control(
				'card_bg_color2',
				[
					'label'     => __( 'Card Background Color Two', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .home-four-donate.bg2' => 'background: {{VALUE}}',
					],
				]
			);
            $this->add_control(
				'area_bg_color',
				[
					'label'     => __( 'Area Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .home-four-donate.bg2' => 'background: {{VALUE}}',
					],
				]
			);
            
        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Get Button Link
        $link = '#';
        if( $settings['link_type'] == 1 ){
            $link = get_page_link( $settings['link_to_page'] );
        } else {
            $link = $settings['ex_link'];
        }

         // Get Button Link
         $link2 = '#';
         if( $settings['link_type2'] == 1 ){
             $link2 = get_page_link( $settings['link_to_page2'] );
         } else {
             $link2 = $settings['ex_link2'];
         }

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        ?>

        <!-- Strategic Donate Area Start -->
        <div class="strategic-donate-area">
            <div class="container">
                <div class="row g-4">
                    <div class="col-lg-8 col-md-7">
                        <div class="home-four-donate">
                            <?php if( $settings['donate_image']['url'] != '' ): ?>
                                <div class="icon">
                                    <img src="<?php echo esc_url($settings['donate_image']['url'] ) ?>" alt="image">
                                </div>
                            <?php endif; ?>
                            <div class="content">
                                <?php if( $settings['title']): ?>
                                    <h6><?php echo wp_kses_post( $settings['title'] ); ?></h6>
                                <?php endif; ?>
                                <?php if( $settings['button_text']): ?>
                                    <a href="<?php echo esc_url( $link ); ?>" class="donate-link">
                                        <?php echo esc_html( $settings['button_text'] ); ?>
                                        <i class="ti ti-arrow-narrow-right"></i>
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-5">
                        <div class="home-four-donate bg2">
                            <?php if( $settings['donate_image2']['url'] != '' ): ?>
                                <div class="icon">
                                    <img src="<?php echo esc_url($settings['donate_image2']['url'] ) ?>" alt="image">
                                </div>
                            <?php endif; ?>
                            <div class="content">
                                <?php if( $settings['title2']): ?>
                                    <h6><?php echo wp_kses_post( $settings['title2'] ); ?></h6>
                                <?php endif; ?>
                                <?php if( $settings['button_text2']): ?>
                                    <a href="<?php echo esc_url( $link2 ); ?>" class="donate-link style2">
                                        <?php echo esc_html( $settings['button_text2'] ); ?>
                                        <i class="ti ti-arrow-narrow-right"></i>
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Strategic Donate Area End -->
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Donate_Two );