<?php
/**
 * English Widget
 */

namespace Elementor;
class Falar_English_Proficiency extends Widget_Base {

	public function get_name() {
        return 'Falar_English_Proficiency';
    }

	public function get_title() {
        return __( 'English Proficiency', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_English_Area',
			[
				'label' => __( 'English Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
            'content',
            [
                'label'       => __( 'Content', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => __('Please tell us how you plan to meet Faral’s English Language requirement.', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
            $this->add_control(
                'shortcode',
                [
                    'label'   => __( 'Proficiency Form Shortcode', 'falar-toolkit' ),
                    'type'    => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'english_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'content_color',
				[
					'label'     => __( 'Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .english-proficiency-content p' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .english-proficiency-content p',
                ]
            );

            $this->add_control(
				'btn_color',
				[
					'label'     => __( 'Button Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .default-btn' => 'color: {{VALUE}}',
					],
				]
			);
            $this->add_control(
				'btn_bg_color',
				[
					'label'     => __( 'Button Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .default-btn' => 'background: {{VALUE}}',
					],
				]
			);
			
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn_typography',
                    'label'    => __( 'Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .default-btn',
                ]
            );
            
        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        ?>

       <!-- English Proficiency Warp Start -->
       <div class="english-proficiency-warp pb-100">
            <div class="container">
                <div class="english-proficiency-content">
                    <?php if( $settings['content']): ?>
                        <p><?php echo wp_kses_post( $settings['content'] ); ?></p>
                    <?php endif; ?>
                    <?php echo do_shortcode( $settings['shortcode'] ); ?>
                </div>
            </div>
        </div>
        <!-- English Proficiency Warp  End -->
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_English_Proficiency );