<?php
/**
 * Events Five Widget
*/

namespace Elementor;
class Falar_Events_Five extends Widget_Base {

	public function get_name() {
        return 'Events_Five';
    }

	public function get_title() {
        return __( 'Events Five', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-person';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'events_five_section',
			[
				'label' => __( 'Events Five', 'falar-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

        $this->add_control(
            'top_title',
            [
                'label'       => __( 'Top Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('9. EVENTS', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Upcoming Events', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'btn_text',
            [
                'label'       => __( 'Button Text', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('View All', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'btn_url',
            [
                'label'       => __( 'Button Url', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('#', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'btn_icon',
            [
                'type'    => Controls_Manager::ICON,
                'label'   => esc_html__( 'Button One Arrow Icon', 'falar-toolkit' ),
                'label_block' => true,
                'options' => falar_icons(),
            ]
        );
        $this->add_control(
            'expired_date',
            [
                'label'       => __( 'Upcoming Events Not Available', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Upcoming  Events Not Available!', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

            $this->add_control(
                'cat_name',
                [
                    'label' => __( 'Choose Category', 'falar-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => falar_toolkit_get_page_events_cat_el(),
                ]
            );

            $this->add_control(
                'order',
                [
                    'label' => __( 'Events Order By', 'falar-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'DESC'      => __( 'DESC', 'falar-toolkit' ),
                        'ASC'       => __( 'ASC', 'falar-toolkit' ),
                    ],
                    'default' => 'DESC',
                ]
            );

            $this->add_control(
                'count',
                [
                    'label' => __( 'Post Per Page', 'falar-toolkit' ),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 4,
                    'description' => __('If you want to see all post, type -1','falar-toolkit')
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'events_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
            'top_title_color',
            [
                'label'     => __( 'Top Title Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .event-contest-heading .title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'top_title_typography',
                'label'    => __( 'Top Title Typography', 'falar-toolkit' ),
                'selector' => '{{WRAPPER}} .event-contest-heading .title',
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label'     => __( 'Title Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .event-contest-heading h2' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'title_typography',
                'label'    => __( 'Title Typography', 'falar-toolkit' ),
                'selector' => '{{WRAPPER}} .event-contest-heading h2',
            ]
        );
        $this->add_control(
            'btn_color',
            [
                'label'     => __( 'Button Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .event-contest-heading .event-link' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'btn_typography',
                'label'    => __( 'Button Typography', 'falar-toolkit' ),
                'selector' => '{{WRAPPER}} .event-contest-heading .event-link',
            ]
        );
        $this->add_control(
            'card_top_color',
            [
                'label'     => __( 'Card Top Title Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .event-contest-card .tags' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'card_top_bg_color',
            [
                'label'     => __( 'Card Top Title Background Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .event-contest-card .tags' => 'background: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'title_content_typography',
                'label'    => __( 'Card top title Typography', 'falar-toolkit' ),
                'selector' => '{{WRAPPER}} .event-contest-card .tags',
            ]
        );
        $this->add_control(
            'card_title_color',
            [
                'label'     => __( 'Card Title Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .event-contest-card h3 a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'card_title_typography',
                'label'    => __( 'Card Title Typography', 'falar-toolkit' ),
                'selector' => '{{WRAPPER}} .event-contest-card h3',
            ]
        );
        $this->add_control(
            'card_content_color',
            [
                'label'     => __( 'Card Content Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .event-contest-card ul li' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'card_content_typography',
                'label'    => __( 'Card Content Typography', 'falar-toolkit' ),
                'selector' => '{{WRAPPER}} .event-contest-card ul li',
            ]
        );
        $this->add_control(
            'card_bg_color',
            [
                'label'     => __( 'Card Background Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .event-contest-card' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'area_bg_color',
            [
                'label'     => __( 'Area Background Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .event-contest-area::before' => 'background: {{VALUE}}',
                ],
            ]
        );
        
        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        // Events Query
        if( $settings['cat_name'] != '' ) {
            $args = array(
                'post_type'     => 'events',
                'posts_per_page'=> $settings['count'],
                'order'         => $settings['order'],
                'tax_query'     => array(
                    array(
                        'taxonomy'      => 'events_cat',
                        'field'         => 'slug',
                        'terms'         => $settings['cat_name'],
                        'hide_empty'    => false
                    )
                )
            );
        } else {
            $args = array(
                'post_type'         => 'events',
                'posts_per_page'    => $settings['count'],
                'order'             => $settings['order']
            );
        }
        $events_array = new \WP_Query( $args );

        ?>

        <!-- Event Contest Area Start -->
        <div class="event-contest-area ptb-100">
            <div class="container">
                <div class="row ">
                    <div class="col-lg-2">
                        <?php if( $settings['top_title']): ?>
                            <div class="event-contest-heading">
                                <span class="title"><?php echo wp_kses_post( $settings['top_title'] ); ?></span>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="col-lg-8">
                        <?php if( $settings['title']): ?>
                            <div class="event-contest-heading">
                                <h2><?php echo wp_kses_post( $settings['title'] ); ?></h2>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="col-lg-2">
                        
                        <div class="event-contest-heading text-end">
                            <?php if( $settings['btn_url']): ?>
                                <a href="<?php echo wp_kses_post( $settings['btn_url'] ); ?>" class="event-link">
                                    <span><?php echo wp_kses_post( $settings['btn_text'] ); ?></span>
                                    <i class="<?php echo wp_kses_post( $settings['btn_icon'] ); ?>"></i>
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="event-contest-slider-widget">
                    <div class="swiper contest-slider">
                        <div class="swiper-wrapper">

                            <?php
                                $i=1;
                                $c=0;
                                while($events_array->have_posts()):
                                    $events_array->the_post();
                                    $id                =  get_the_ID();
                                    $events_date       = get_field( 'events_date' );
                                    $events_location   = get_field( 'events_location' );
                                    $timestamp         = strtotime($events_date);
                                ?>
                                <?php if ($timestamp > time()):
                                    $c++; ?>
                                    <div class="swiper-slide">
                                        <div class="event-contest-card">
                                            <?php
                                                $post_categories = get_the_terms(get_the_ID(), 'events_cat');

                                                if ($post_categories && !is_wp_error($post_categories)) {
                                                    foreach ($post_categories as $category) {
                                                        ?>
                                                        <a class="tags" href="<?php echo esc_url(get_term_link($category)); ?>">
                                                            <?php echo esc_html($category->name); ?>
                                                        </a>
                                                        <?php
                                                    }
                                                }
                                            ?>
                                            <h3>
                                                <a href="<?php echo esc_url(get_the_permalink($id)); ?>">
                                                    <?php the_title(); ?>
                                                </a>
                                            </h3>
                                            <ul class="event-list">
                                                <?php if($events_date): ?>
                                                    <li>
                                                        <i class="ti ti-calendar"></i>
                                                        <?php echo wp_kses_post($events_date); ?>
                                                    </li>
                                                <?php endif; ?>
                                                <?php if($events_location): ?>
                                                    <li>
                                                        <i class="ti ti-map-pin"></i>
                                                        <?php echo wp_kses_post($events_location); ?>
                                                    </li>
                                                <?php endif; ?>
                                            </ul>
                                        </div>
                                    </div>
                                <?php endif;  ?>
                            <?php $i++; endwhile; wp_reset_postdata();?>
                        </div>
                    </div>
                    <div class="swiper-pagination3"></div>
                </div>
                <?php if($c == 0): ?>
                    <div class="no-upcoming">
                        <h3><?php echo wp_kses_post( $settings['expired_date'] ); ?></h3>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        <!-- Event Contest Area End -->
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Events_Five );