<?php
/**
 * Events Three Widget
*/

namespace Elementor;
class Falar_Events_Three extends Widget_Base {

	public function get_name() {
        return 'Events_Three';
    }

	public function get_title() {
        return __( 'Events Three', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-person';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'events_three_section',
			[
				'label' => __( 'Events Three', 'falar-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Join Our Exciting Event', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'short_content1',
            [
                'label'       => __( 'Shorting Content One', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Default Sorting', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'short_content2',
            [
                'label'       => __( 'Shorting Content Two', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Upcoming Events', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'short_content3',
            [
                'label'       => __( 'Shorting Content Three', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Past Events', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

            $this->add_control(
                'cat_name',
                [
                    'label' => __( 'Choose Category', 'falar-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => falar_toolkit_get_page_events_cat_el(),
                ]
            );

            $this->add_control(
                'order',
                [
                    'label' => __( 'Events Order By', 'falar-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'DESC'      => __( 'DESC', 'falar-toolkit' ),
                        'ASC'       => __( 'ASC', 'falar-toolkit' ),
                    ],
                    'default' => 'DESC',
                ]
            );

            $this->add_control(
                'count',
                [
                    'label' => __( 'Post Per Page', 'falar-toolkit' ),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 4,
                    'description' => __('If you want to see all post, type -1','falar-toolkit')
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'events_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
            'title_color',
            [
                'label'     => __( 'Title Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .event-title-select .event-title h2' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'title_typography',
                'label'    => __( 'Title Typography', 'falar-toolkit' ),
                'selector' => '{{WRAPPER}} .event-title-select .event-title h2',
            ]
        );
        $this->add_control(
            'card_top_color',
            [
                'label'     => __( 'Card Top Title Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .event-widget span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'card_top_bg_color',
            [
                'label'     => __( 'Card Top Title Background Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .event-widget span' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'title_content_typography',
                'label'    => __( 'Card top title Typography', 'falar-toolkit' ),
                'selector' => '{{WRAPPER}} .event-widget span',
            ]
        );
        $this->add_control(
            'card_title_color',
            [
                'label'     => __( 'Card Title Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .event-widget h3 a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'card_title_typography',
                'label'    => __( 'Card Title Typography', 'falar-toolkit' ),
                'selector' => '{{WRAPPER}} .event-widget h3',
            ]
        );
        $this->add_control(
            'card_content_color',
            [
                'label'     => __( 'Card Content Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .event-widget .event-list li' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'card_content_typography',
                'label'    => __( 'Card Content Typography', 'falar-toolkit' ),
                'selector' => '{{WRAPPER}} .event-widget .event-list li',
            ]
        );
        $this->add_control(
            'card_bg_color',
            [
                'label'     => __( 'Card Background Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .event-widget' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        
        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        $order = $settings['order'];
        $sOrder = '';

        if(isset($_GET['order'])){
            if($_GET['order']){
                $order = $_GET['order'];
                $sOrder = $_GET['order'];
            }
        }

        // Events Query
        if( $settings['cat_name'] != '' ) {
            $args = array(
                'post_type'     => 'events',
                'posts_per_page'=> $settings['count'],
                'order'         => $order,
                'paged' => get_query_var('paged') ? get_query_var('paged') : 1,
                'tax_query'     => array(
                    array(
                        'taxonomy'      => 'events_cat',
                        'field'         => 'slug',
                        'terms'         => $settings['cat_name'],
                        'hide_empty'    => false
                    )
                )
            );
        } else {
            $args = array(
                'post_type'         => 'events',
                'posts_per_page'    => $settings['count'],
                'paged' => get_query_var('paged') ? get_query_var('paged') : 1,
                'order'             => $order
            );
        }

        $events_array = new \WP_Query( $args );
            global $wp;
            $event_filter_url = home_url( $wp->request )
        ?>

        <!-- Events Warp Start -->
       <div class="main-event-warp ptb-100">
            <div class="container">
                <div class="event-title-select">
                    <div class="row align-items-center">
                        <div class="col-lg-6 col-md-6">
                            <div class="event-title">
                                <?php if( $settings['title']): ?>
                                    <h2><?php echo wp_kses_post( $settings['title'] ); ?></h2>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php if( $settings['short_content1']): ?>
                            <div class="col-lg-6 col-md-6">
                                <div class="event-select text-end">
                                    <form method="GET" action="<?php echo esc_url($event_filter_url); ?>" id="eventFilter">
                                        <select class="form-select" name="order" id="eventFilterOption">
                                            <?php if($sOrder == 'upcomming'): ?>
                                                <option value="default"><?php echo wp_kses_post( $settings['short_content1'] ); ?></option>
                                                <option selected value="upcomming"><?php echo wp_kses_post( $settings['short_content2'] ); ?></option>
                                                <option value="past"><?php echo wp_kses_post( $settings['short_content3'] ); ?></option>
                                            <?php elseif($sOrder == 'past'): ?>
                                                <option value="default"><?php echo wp_kses_post( $settings['short_content1'] ); ?></option>
                                                <option value="upcomming"><?php echo wp_kses_post( $settings['short_content2'] ); ?></option>
                                                <option selected value="past"><?php echo wp_kses_post( $settings['short_content3'] ); ?></option>
                                            <?php else: ?>
                                                <option value="default" selected><?php echo wp_kses_post( $settings['short_content1'] ); ?></option>
                                                <option value="upcomming"><?php echo wp_kses_post( $settings['short_content2'] ); ?></option>
                                                <option value="past"><?php echo wp_kses_post( $settings['short_content3'] ); ?></option>
                                            <?php endif; ?>
                                        </select>
                                    </form> 
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="row g-4">
                    <?php
                        $i=1;
                        $c=0;
                        while($events_array->have_posts()):
                        $events_array->the_post();
                        $id                =  get_the_ID();
                        $events_date       = get_field( 'events_date' );
                        $events_location   = get_field( 'events_location' );
                        $timestamp         = strtotime($events_date);

                        if( $sOrder == 'past'){
                            if ($timestamp < time()):
                                $c++;
                                ?>
                                <div class="col-lg-6">
                                    <div class="event-widget style2 bg-<?php echo esc_attr($i); ?>">
                                        <?php
                                            $post_categories = get_the_terms(get_the_ID(), 'events_cat');

                                            if ($post_categories && !is_wp_error($post_categories)) {
                                                foreach ($post_categories as $category) {
                                                    ?>
                                                    <a href="<?php echo esc_url(get_term_link($category)); ?>">
                                                        <span><?php echo esc_html($category->name); ?></span>
                                                    </a>
                                                    <?php
                                                }
                                            }
                                        ?>
                                        <h3>
                                            <a href="<?php echo esc_url(get_the_permalink($id)); ?>">
                                                <?php the_title(); ?>
                                            </a>
                                        </h3>
                                        <ul class="event-list">
                                            <?php if($events_date): ?>
                                                <li>
                                                    <i class="ti ti-calendar"></i>
                                                    <?php echo wp_kses_post($events_date); ?>
                                                </li>
                                            <?php endif; ?>
                                            <?php if($events_location): ?>
                                                <li>
                                                    <i class="ti ti-map-pin"></i>
                                                    <?php echo wp_kses_post($events_location); ?>
                                                </li>
                                            <?php endif; ?>
                                        </ul>
                                    </div>
                                </div>
                                <?php
                            endif;
                        }elseif($sOrder == 'upcomming'){
                            if ($timestamp > time()):
                                $c++;
                                ?>
                                <div class="col-lg-6">
                                    <div class="event-widget style2 bg-<?php echo esc_attr($i); ?>">
                                        <?php
                                            $post_categories = get_the_terms(get_the_ID(), 'events_cat');

                                            if ($post_categories && !is_wp_error($post_categories)) {
                                                foreach ($post_categories as $category) {
                                                    ?>
                                                    <a href="<?php echo esc_url(get_term_link($category)); ?>">
                                                        <span><?php echo esc_html($category->name); ?></span>
                                                    </a>
                                                    <?php
                                                }
                                            }
                                        ?>
                                        <h3>
                                            <a href="<?php echo esc_url(get_the_permalink($id)); ?>">
                                                <?php the_title(); ?>
                                            </a>
                                        </h3>
                                        <ul class="event-list">
                                            <?php if($events_date): ?>
                                                <li>
                                                    <i class="ti ti-calendar"></i>
                                                    <?php echo wp_kses_post($events_date); ?>
                                                </li>
                                            <?php endif; ?>
                                            <?php if($events_location): ?>
                                                <li>
                                                    <i class="ti ti-map-pin"></i>
                                                    <?php echo wp_kses_post($events_location); ?>
                                                </li>
                                            <?php endif; ?>
                                        </ul>
                                    </div>
                                </div>
                                <?php
                            endif;
                        }else{
                            $c++;
                            ?>
                            <div class="col-lg-6">
                                <div class="event-widget style2 bg-<?php echo esc_attr($i); ?>">
                                    <?php
                                        $post_categories = get_the_terms(get_the_ID(), 'events_cat');

                                        if ($post_categories && !is_wp_error($post_categories)) {
                                            foreach ($post_categories as $category) {
                                                ?>
                                                <a href="<?php echo esc_url(get_term_link($category)); ?>">
                                                    <span><?php echo esc_html($category->name); ?></span>
                                                </a>
                                                <?php
                                            }
                                        }
                                    ?>

                                    <h3>
                                        <a href="<?php echo esc_url(get_the_permalink($id)); ?>">
                                            <?php the_title(); ?>
                                        </a>
                                    </h3>
                                    <ul class="event-list">
                                        <?php if($events_date): ?>
                                            <li>
                                                <i class="ti ti-calendar"></i>
                                                <?php echo wp_kses_post($events_date); ?>
                                            </li>
                                        <?php endif; ?>
                                        <?php if($events_location): ?>
                                            <li>
                                                <i class="ti ti-map-pin"></i>
                                                <?php echo wp_kses_post($events_location); ?>
                                            </li>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                            </div>
                            <?php
                        }
                    ?>
                    <?php $i++; endwhile; wp_reset_postdata();?>
                </div>
                <?php if( $sOrder == 'past'): ?>
                    <?php if($c >= $settings['count']): ?>
                    <div class="pagination-area">
                        <nav aria-label="navigation" class="inner-pages-pagination text-center style2">
                            <?php 
                            $big = 999999999; // need an unlikely integer
                            echo paginate_links( array(
                                'base' => str_replace( $big, '%#%', get_pagenum_link( $big ) ),
                                'format' => '?paged=%#%',
                                'current' => max(1, get_query_var('paged') ),
                                'total' =>  $events_array->max_num_pages,
                                'prev_text' => '<i class="ti ti-chevron-left"></i>',
                                'next_text' => '<i class="ti ti-chevron-right"></i>',
                            ) ); ?>  
                        </nav>
                    </div>
                    <?php endif; ?>
                <?php elseif($sOrder == 'upcomming'): ?>
                    <?php if($c >= $settings['count']): ?>
                        <div class="pagination-area">
                            <nav aria-label="navigation" class="inner-pages-pagination text-center style2">
                                <?php 
                                $big = 999999999; // need an unlikely integer
                                echo paginate_links( array(
                                    'base' => str_replace( $big, '%#%', get_pagenum_link( $big ) ),
                                    'format' => '?paged=%#%',
                                    'current' => max(1, get_query_var('paged') ),
                                    'total' =>  $events_array->max_num_pages,
                                    'prev_text' => '<i class="ti ti-chevron-left"></i>',
                                    'next_text' => '<i class="ti ti-chevron-right"></i>',
                                ) ); ?>  
                            </nav>
                        </div>
                    <?php endif; ?>
                <?php else: ?>
                    <div class="pagination-area">
                        <nav aria-label="navigation" class="inner-pages-pagination text-center style2">
                            <?php 
                            $big = 999999999; // need an unlikely integer
                            echo paginate_links( array(
                                'base' => str_replace( $big, '%#%', get_pagenum_link( $big ) ),
                                'format' => '?paged=%#%',
                                'current' => max(1, get_query_var('paged') ),
                                'total' =>  $events_array->max_num_pages,
                                'prev_text' => '<i class="ti ti-chevron-left"></i>',
                                'next_text' => '<i class="ti ti-chevron-right"></i>',
                            ) ); ?>  
                        </nav>
                    </div>
                <?php endif; ?>
            </div>
       </div>
       <!-- Events Warp End -->
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Events_Three );