<?php
/**
 * Financial Image Widget
 */

namespace Elementor;
class Falar_Financial_Image extends Widget_Base {

	public function get_name() {
        return 'Falar_Financial_Image';
    }

	public function get_title() {
        return __( 'Financial Image', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Financial_Image_Area',
			[
				'label' => __( 'Financial Image Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
            'financial_image',
            [
                'label'       => __( 'Financial Image', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'content',
            [
                'label'       => __( 'Content', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('More than 100+ Scholarships Worth More Than', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'num',
            [
                'label'       => __( 'Number', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('$320M', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
			'financial_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'content_color',
				[
					'label'     => __( 'Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .financial-image .info-content p' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .financial-image .info-content p',
                ]
            );

            $this->add_control(
				'title_color',
				[
					'label'     => __( 'Number Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .financial-image .info-content h2' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Number Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .financial-image .info-content h2',
                ]
            );

            $this->add_control(
				'card_bg_color',
				[
					'label'     => __( 'Card Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .financial-image .info-content' => 'background: {{VALUE}}',
					],
				]
			);
            
        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        ?>

            <div class="financial-image">
                <?php if( $settings['financial_image']['url'] != '' ): ?>
                    <img src="<?php echo esc_url($settings['financial_image']['url'] ) ?>" class="financial-info-image" alt="image">
                <?php endif; ?>
                <div class="info-content">
                    <p><?php echo wp_kses_post( $settings['content'] ); ?></p>
                    <h2><?php echo wp_kses_post( $settings['num'] ); ?></h2>
                </div>
            </div>
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Financial_Image );