<?php
/**
 * Find Program Four Widget
 */

namespace Elementor;
class Falar_Find_Program_Four extends Widget_Base {

	public function get_name() {
        return 'Falar_Find_Program_Four';
    }

	public function get_title() {
        return __( 'Find Program Four', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Program_Four_Area',
			[
				'label' => __( 'Program Four Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Find Your Program', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content',
            [
                'label'       => __( 'Content', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Welcome to our university is website! Use the search bar below to explore our diverse range of programs.', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'search_placeholder',
            [
                'label'       => __( 'Search Placeholder', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Find your program like “Nursing”', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'popular_search_title',
            [
                'label'       => __( 'Popular Search Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Popular Search:', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
			'program_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

            $this->add_control(
				'input_bg_color',
				[
					'label'     => __( 'Search Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .find-program-widget ul li span' => 'color: {{VALUE}}',
					],
				]
			);
            $this->add_control(
				'search_title_color',
				[
					'label'     => __( 'Search Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .find-program-widget ul li span' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'search_title_typography',
                    'label'    => __( 'Search Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .find-program-widget ul li span',
                ]
            );
            $this->add_control(
				'search_tag_color',
				[
					'label'     => __( 'Search Tag Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .find-program-widget ul li a' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'search_tag_typography',
                    'label'    => __( 'Search Tag Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .find-program-widget ul li a',
                ]
            );
            
        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        ?>

        <!-- Find Program Area Start -->
        <div class="find-program-area">
            <div class="container">
                <div class="find-program-widget">
                    <?php if( $settings['search_placeholder']): ?>
                        <div class="find-program-input">
                            <form role="search" method="get" id="search2" action="<?php echo esc_url( home_url( '/' ) );?>">
                                <input type="text" value="<?php echo get_search_query(); ?>" name="s" id="s1" required  class="form-control" placeholder="<?php echo wp_kses_post( $settings['search_placeholder'] ); ?>">
                                <i class="ti ti-search"></i>
                            </form>
                        </div>
                    <?php endif; ?>
                    <?php if ( get_tags() ) {  ?>
                        <ul class="program-list">
                            <li>
                                <span><?php echo wp_kses_post( $settings['popular_search_title'] ); ?></span>
                            </li>
                            <?php $tags = get_tags();
                                $i = 1;
                                foreach ($tags as $tag ) {  ?>
                                <?php if($i <= 6): ?>
                                <li>
                                    <a href="<?php echo esc_url(get_tag_link($tag->term_id)); ?>">
                                        <?php echo esc_html($tag->name) ?>
                                    </a>
                                </li>
                                <?php endif; $i++;
                            } ?>
                        </ul>
                    <?php } ?>
                </div>
            </div>
        </div>
        <!-- Find Program Area End -->

        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Find_Program_Four );