<?php
/**
 * Find Program Two Widget
 */

namespace Elementor;
class Falar_Find_Program_Two extends Widget_Base {

	public function get_name() {
        return 'Falar_Find_Program_Two';
    }

	public function get_title() {
        return __( 'Find Program Two', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Program_Area',
			[
				'label' => __( 'Program Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'top_title',
            [
                'label'       => __( 'Top Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Find Your Program', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content',
            [
                'label'       => __( 'Content', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Welcome to our university is website! Use the search bar below to explore our diverse range of programs and discover the perfect academic path that suits your interests and career goals.', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'search_placeholder',
            [
                'label'       => __( 'Search Placeholder', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Find your program like “Graphic Design”', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'search_icon',
            [
                'label'       => __( 'Search Icon', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'popular_search_title',
            [
                'label'       => __( 'Popular Search Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Popular Search:', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'program_card_image',
            [
                'label'       => __( 'Program Card Image', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'program_card_top_title',
            [
                'label'       => __( 'Program card Top Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Popular Program', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'program_card_title',
            [
                'label'       => __( 'Program card Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Advertising and Marketing Communications', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'program_card_link',
            [
                'label'       => __( 'Program card Link', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('#', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'program_img1',
            [
                'label'       => __( 'Program Image One', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'program_img2',
            [
                'label'       => __( 'Program Image Two', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );

        $this->add_control(
            'campus_logo',
            [
                'label'       => __( 'campus Logo', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );
        
        $this->add_control(
            'number',
            [
                'label'       => __( 'Number', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('156', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'target',
            [
                'label'       => __( 'Target', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('+', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'funfact_content',
            [
                'label'       => __( 'Funfacts Content', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Programs Available For Students', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'shape',
            [
                'label'       => __( 'Shape', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
			'program_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'num_color',
				[
					'label'     => __( 'Number Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .program-images .logo-content .content h2' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'num_typography',
                    'label'    => __( 'Number Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .program-images .logo-content .content h2',
                ]
            );
			$this->add_control(
				'fun_color',
				[
					'label'     => __( 'Funfact Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .program-images .logo-content .content p' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'fun_typography',
                    'label'    => __( 'Funfact Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .program-images .logo-content .content p',
                ]
            );
            $this->add_control(
				'fun_bg_color',
				[
					'label'     => __( 'Funfact Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .program-images.style2 .logo-content' => 'background: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'top_title_color',
				[
					'label'     => __( 'Top Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .program-content .title' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'top_title_typography',
                    'label'    => __( 'Top Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .program-content .title',
                ]
            );
			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .program-content h2' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .program-content h2',
                ]
            );
			$this->add_control(
				'content_color',
				[
					'label'     => __( 'Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .program-content p' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .program-content p',
                ]
            );
            $this->add_control(
				'search_title_color',
				[
					'label'     => __( 'Search Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .program-content .search-list' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'search_title_typography',
                    'label'    => __( 'Search Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .program-content .search-list',
                ]
            );
            $this->add_control(
				'search_tag_color',
				[
					'label'     => __( 'Search Tag Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .program-content .program-list li a' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'search_tag_typography',
                    'label'    => __( 'Search Tag Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .program-content .program-list li a',
                ]
            );
            $this->add_control(
				'program_top_title_color',
				[
					'label'     => __( 'Program Top Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .program-content .program-item .content span' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'program_top_title_typography',
                    'label'    => __( 'Program Top Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .program-content .program-item .content span',
                ]
            );
            $this->add_control(
				'program_top_title_bg_color',
				[
					'label'     => __( 'Program Top Title Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .program-content .program-item .content span' => 'color: {{VALUE}}',
					],
				]
			);

            $this->add_control(
				'program_title_color',
				[
					'label'     => __( 'Program Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .program-content .program-item .content h4 a' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'program_title_typography',
                    'label'    => __( 'Program Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .program-content .program-item .content h4',
                ]
            );

            $this->add_control(
				'program_btn_color',
				[
					'label'     => __( 'Program Button Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .program-content .program-item .icon' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'program_btn_typography',
                    'label'    => __( 'Program Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .program-content .program-item .icon',
                ]
            );

            $this->add_control(
				'program_btn_bg_color',
				[
					'label'     => __( 'Program Button Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .program-content .program-item .icon' => 'background-color: {{VALUE}}',
					],
				]
			);
            $this->add_control(
				'area_bg_color',
				[
					'label'     => __( 'Area Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .bg-FAFAFA' => 'background-color: {{VALUE}}',
					],
				]
			);

        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        ?>

        <div class="find-program-warp style2 pb-100 bg-FAFAFA">
            <div class="container">
                <div class="row g-4">
                    <div class="col-lg-6" data-cue="slideInLeft">
                        <div class="program-content style2">
                            <?php if( $settings['top_title']): ?>
                                <span class="title"><?php echo wp_kses_post( $settings['top_title'] ); ?></span>
                            <?php endif; ?>
                            <?php if( $settings['title']): ?>
                                <h2 class="reveal2"><?php echo wp_kses_post( $settings['title'] ); ?></h2>
                            <?php endif; ?>
                            <?php if( $settings['content']): ?>
                                <p class="reveal2"><?php echo wp_kses_post( $settings['content'] ); ?></p>
                            <?php endif; ?>
                            <?php if( $settings['search_placeholder']): ?>
                                <div class="program-input">
                                    <form role="search" method="get" id="search2" action="<?php echo esc_url( home_url( '/' ) );?>">
                                        <input type="text" value="<?php echo get_search_query(); ?>" name="s" id="s1" required  class="form-control" placeholder="<?php echo wp_kses_post( $settings['search_placeholder'] ); ?>">
                                        <button class="search-btn" type="submit">
                                            <?php if( $settings['search_icon']['url'] != '' ): ?>
                                                <img src="<?php echo esc_url($settings['search_icon']['url'] ) ?>" alt="image">
                                            <?php endif; ?>
                                        </button>
                                    </form>
                                </div>
                            <?php endif; ?>
                            <?php if( $settings['popular_search_title']): ?>
                                <div class="row">
                                    <div class="col-lg-3">
                                        <span class="search-list"><?php echo wp_kses_post( $settings['popular_search_title'] ); ?></span>
                                    </div>
                                    <div class="col-lg-9">
                                        <?php if ( get_tags() ) {  ?>
                                            <ul class="program-list">
                                            <?php $tags = get_tags();
                                                $i = 1;
                                                foreach ($tags as $tag ) {  ?>
                                                <?php if($i <= 6): ?>
                                                <li>
                                                    <a href="<?php echo esc_url(get_tag_link($tag->term_id)); ?>">
                                                        <?php echo esc_html($tag->name) ?>
                                                    </a>
                                                </li>
                                                <?php endif; $i++;
                                                } ?>
                                            </ul>
                                        <?php } ?>
                                    </div>
                                </div>
                            <?php endif; ?>
                            
                            <div class="program-item">
                                <div class="image">
                                    <?php if( $settings['program_card_image']['url'] != '' ): ?>
                                        <div class="image">
                                            <img src="<?php echo esc_url($settings['program_card_image']['url'] ) ?>" alt="image">
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <div class="content">
                                    <?php if( $settings['program_card_top_title']): ?>
                                        <span><?php echo wp_kses_post( $settings['program_card_top_title'] ); ?></span>
                                    <?php endif; ?>
                                    <?php if( $settings['program_card_title']): ?>
                                        <h4><a href="<?php echo wp_kses_post( $settings['program_card_link'] ); ?>"><?php echo wp_kses_post( $settings['program_card_title'] ); ?></a></h4>
                                    <?php endif; ?>
                                </div>
                                <?php if( $settings['program_card_link']): ?>
                                    <a href="<?php echo wp_kses_post( $settings['program_card_link'] ); ?>" class="icon">
                                        <i class="ti ti-arrow-narrow-right"></i>
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6" data-cue="slideInUp">
                        <div class="program-images style2">
                            <div class="row g-4">
                                <div class="col-lg-5 col-md-6">
                                    <?php if( $settings['program_img1']['url'] != '' ): ?>
                                        <div class="image reveal2">
                                            <img src="<?php echo esc_url($settings['program_img1']['url'] ) ?>" alt="image">
                                        </div>
                                    <?php endif; ?>
                                    <div class="logo-content">
                                        <div class="logo">
                                            <?php if( $settings['campus_logo']['url'] != '' ): ?>
                                                <div class="logo">
                                                    <img src="<?php echo esc_url($settings['campus_logo']['url'] ) ?>" alt="image">
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                        <div class="content">
                                            <div class="d-flex">
                                                <?php if( $settings['number']): ?>
                                                    <h2 class="counter"><?php echo wp_kses_post( $settings['number'] ); ?></h2>
                                                <?php endif; ?>
                                                <?php if( $settings['target']): ?>
                                                    <h2 class="plus"><?php echo wp_kses_post( $settings['target'] ); ?></h2>
                                                <?php endif; ?>
                                            </div>
                                            <?php if( $settings['funfact_content']): ?>
                                                <p><?php echo wp_kses_post( $settings['funfact_content'] ); ?></p>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-7 col-md-6">
                                    <?php if( $settings['program_img2']['url'] != '' ): ?>
                                        <div class="big-image reveal3">
                                            <img src="<?php echo esc_url($settings['program_img2']['url'] ) ?>" alt="image">
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="all-shapes">
                <?php if( $settings['shape']['url'] != '' ): ?>
                    <img src="<?php echo esc_url($settings['shape']['url'] ) ?>" class="program-shape" alt="image">
                <?php endif; ?>
            </div>
        </div>

        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Find_Program_Two );