<?php
/**
 * Feature One Widget
 */

namespace Elementor;
class Falar_Feature_Right_Side extends Widget_Base {

	public function get_name() {
        return 'Falar_Feature_Right_Side';
    }

	public function get_title() {
        return __( 'Feature Right Side', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Feature_Right_Side_Area',
			[
				'label' => __( 'Feature Right Side Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Future Student', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        $list_items = new Repeater();

            
            $list_items->add_control(
				'card_top_title',
				[
					'label'       => __( 'Card Top Title', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'card_title',
				[
					'label'       => __( 'Card Title', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'card_link',
				[
					'label'       => __( 'Card Link', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'button_text',
				[
					'label'       => __( 'Button Text', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'default'     => __('See Guideline', 'falar-toolkit'),
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'feature_image',
				[
					'label'       => __( 'Feature Image', 'falar-toolkit' ),
					'type'        => Controls_Manager::MEDIA,
				]
			);
            $this->add_control(
                'feature_item',
                [
                    'label' => esc_html__('Add Feature Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'feature_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .section-warp h2' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .section-warp h2',
                ]
            );
            $this->add_control(
				'card_top_title_color',
				[
					'label'     => __( 'Card Top Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .future-student-item .content .tags' => 'color: {{VALUE}}',
					],
				]
			);
            $this->add_control(
				'card_top_title_bg_color',
				[
					'label'     => __( 'Card Top Title Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .future-student-item .content .tags' => 'background: {{VALUE}}',
					],
				]
			);
            $this->add_control(
				'card_top_title_bg_color2',
				[
					'label'     => __( 'Card Top Title Background Color Two', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .future-student-item .content .tags.bg-2' => 'background: {{VALUE}}',
					],
				]
			);
            $this->add_control(
				'card_top_title_bg_color3',
				[
					'label'     => __( 'Card Top Title Background Color Three', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .future-student-item .content .tags.bg-3' => 'background: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'card_top_title_typography',
                    'label'    => __( 'Card Top Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .future-student-item .content .tags',
                ]
            );
            $this->add_control(
				'card_title_color',
				[
					'label'     => __( 'Card Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .future-student-item .content h3 a' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'card_title_typography',
                    'label'    => __( 'Card Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .future-student-item .content h3 a',
                ]
            );
            $this->add_control(
				'card_btn_color',
				[
					'label'     => __( 'Card Button Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .future-student-item .content .view-link span' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'card_btn_typography',
                    'label'    => __( 'Card Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .future-student-item .content .view-link span',
                ]
            );

            $this->add_control(
				'card_border_color',
				[
					'label'     => __( 'Card Border Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .future-student-item' => 'border-color: {{VALUE}}',
					],
				]
			);
        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $feature_item = $settings['feature_item'];
        ?>

        <div class="future-student-right-side">
            <div class="section-warp">
                <?php if( $settings['title']): ?>
                    <h2 class="reveal2">
                        <?php echo wp_kses_post( $settings['title'] ); ?>
                    </h2>
                <?php endif; ?> 
            </div>
            <?php $i = 1; foreach($feature_item as $item_feature): ?>
                <div class="future-student-item">
                    <div class="content">
                        <span class="tags <?php if($i == 2): ?>bg-2<?php endif; ?> <?php if($i == 3): ?>bg-3<?php endif; ?>"><?php echo wp_kses_post( $item_feature['card_top_title'] ); ?></span>
                        <h3>
                            <a href="<?php echo wp_kses_post( $item_feature['card_link'] ); ?>">
                                <?php echo wp_kses_post( $item_feature['card_title'] ); ?>
                            </a>
                        </h3>
                        <a href="<?php echo wp_kses_post( $item_feature['card_link'] ); ?>" class="view-link"><span><?php echo wp_kses_post( $item_feature['button_text'] ); ?></span>
                            <i class="ti ti-arrow-narrow-right"></i>
                        </a>
                    </div>
                    <div class="image">
                        <?php if( $item_feature['feature_image']['url'] != '' ): ?>
                            <img src="<?php echo esc_url($item_feature['feature_image']['url'] ) ?>" alt="image">
                        <?php endif; ?>
                    </div>
                </div>
            <?php $i++; endforeach; ?>
        </div>
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Feature_Right_Side );