<?php
/**
 * Feature One Widget
 */

namespace Elementor;
class Falar_Feature_Widget extends Widget_Base {

	public function get_name() {
        return 'Falar_Feature_Widget';
    }

	public function get_title() {
        return __( 'Feature Widget', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Feature_Widget_Area',
			[
				'label' => __( 'Feature Widget Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
            'feature_image',
            [
                'label'       => __( 'Feature Image', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'top_title',
            [
                'label'       => __( 'Top Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Freshers’ Guideline', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Bring your talent onto the bioard', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'title_Url',
            [
                'label'       => __( 'Title Url', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('#', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'video_link',
            [
                'label'       => __( 'Video Link', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $this->add_control(
            'video_btn_text',
            [
                'label'       => __( 'Card Top Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Watch Full Video', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'video_btn_url',
            [
                'label'       => __( 'Video Button Url', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('#', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
			'feature_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'top_title_color',
				[
					'label'     => __( 'Top Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .future-students-widget .tags' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'top_title_bg_color',
				[
					'label'     => __( 'Top Title Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .future-students-widget .tags' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'top_title_typography',
                    'label'    => __( 'Top Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .future-students-widget .tags',
                ]
            );
            $this->add_control(
				'card_title_color',
				[
					'label'     => __( 'Card Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .future-students-widget h3 a' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'card_title_typography',
                    'label'    => __( 'Card Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .future-students-widget h3',
                ]
            );
            $this->add_control(
				'card_btn_color',
				[
					'label'     => __( 'Card Button Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .future-students-widget .view-link' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'card_btn_typography',
                    'label'    => __( 'Card Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .future-students-widget .view-link',
                ]
            );

        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        ?>

            <div class="future-students-widget">
                <div class="image">
                    <?php if( $settings['feature_image']['url'] != '' ): ?>
                        <img src="<?php echo esc_url($settings['feature_image']['url'] ) ?>" class="future-studnts" alt="image">
                    <?php endif; ?>
                    <?php if( $settings['video_link']): ?>
                        <a class="video-btn popup-youtube" href="<?php echo wp_kses_post( $settings['video_link'] ); ?>">
                            <i class="ti ti-player-play-filled"></i>
                        </a>
                    <?php endif; ?>
                </div>
                <?php if( $settings['top_title']): ?>
                    <span class="tags"><?php echo wp_kses_post( $settings['top_title'] ); ?></span>
                <?php endif; ?>
                <?php if( $settings['title']): ?>
                    <h3>
                        <a href="<?php echo wp_kses_post( $settings['title_Url'] ); ?>">
                            <?php echo wp_kses_post( $settings['title'] ); ?>
                        </a>
                    </h3>
                <?php endif; ?>
                <?php if( $settings['video_btn_url']): ?>
                    <a href="<?php echo wp_kses_post( $settings['video_btn_url'] ); ?>" class="view-link popup-youtube">
                        <span><?php echo wp_kses_post( $settings['video_btn_text'] ); ?></span>
                        <i class="ti ti-arrow-narrow-right"></i>
                    </a>
                <?php endif; ?>
            </div>
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Feature_Widget );