<?php
/**
 * Health Service Widget
 */

namespace Elementor;
class Falar_Health_Service extends Widget_Base {

	public function get_name() {
        return 'Falar_Health_Service';
    }

	public function get_title() {
        return __( 'Health Service', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Health_Service_Area',
			[
				'label' => __( 'Health Service Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Health Service', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content',
            [
                'label'       => __( 'Content', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => __('Our Davis, Hazel McCallion (HMC) and Trafalgar Campus Health Centres are open for in-person appointments. However, all appointments will begin with a virtual consultation with a nurse, nurse practitioner or doctor, who will determine whether an in-person appointment is needed.', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'title_two',
            [
                'label'       => __( 'Title Two', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Students may call the Health Centres below to book an appointment.', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $list_item = new Repeater();

            $list_item->add_control(
				'ser_title',
				[
					'label'       => __( 'Service Title', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_item->add_control(
				'ser_content',
				[
					'label'       => __( 'Service Content', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_item->add_control(
				'ser_date',
				[
					'label'       => __( 'Service Date', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_item->add_control(
				'number',
				[
					'label'       => __( 'Number', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $this->add_control(
                'service_item',
                [
                    'label' => esc_html__('Add Service Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_item->get_controls(),
                ]
            );
        $this->add_control(
            'content_box1',
            [
                'label'       => __( 'Content Box One', 'falar-toolkit' ),
                'type'        => Controls_Manager::WYSIWYG,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content_box2',
            [
                'label'       => __( 'Content Box Two', 'falar-toolkit' ),
                'type'        => Controls_Manager::WYSIWYG,
                'label_block' => true,
            ]
        );

        $list_items = new Repeater();

            $list_items->add_control(
				'link_text',
				[
					'label'       => __( 'Link Text', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'link_url',
				[
					'label'       => __( 'Link Url', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
                'active_style',
                [
                    'label' 	=> esc_html__( 'Active/Inactive Style', 'falar-toolkit' ),
                    'type' 		=> Controls_Manager::SELECT,
                    'options' 	=> [
                        '1'         => esc_html__( 'Inactive', 'falar-toolkit' ),
                        '2'         => esc_html__( 'Active', 'falar-toolkit' ),
                    ],
                    'default' => '1',
                ]
            );
            $this->add_control(
                'link_item',
                [
                    'label' => esc_html__('Add Link Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'health_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .blog-title h2' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .blog-title h2',
                ]
            );
			$this->add_control(
				'content_color',
				[
					'label'     => __( 'Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .blog-title p' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .blog-title p',
                ]
            );

            $this->add_control(
				'title_color2',
				[
					'label'     => __( 'Title Color Two', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .health-service-content .health-service-location-widget h4' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography2',
                    'label'    => __( 'Title Typography Two', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .health-service-content .health-service-location-widget h4',
                ]
            );

            $this->add_control(
				'paragraph_color',
				[
					'label'     => __( 'Paragraph Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} p' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'paragraph_typography',
                    'label'    => __( 'Paragraph Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} p',
                ]
            );

            $this->add_control(
				'site_btn_color',
				[
					'label'     => __( 'Site Button Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .accessibility-link-widget .accessibility-link-list a' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'site_btn_bg_color',
				[
					'label'     => __( 'Site Button Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .accessibility-link-widget .accessibility-link-list a' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'site_btn_typography',
                    'label'    => __( 'Site Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .accessibility-link-widget .accessibility-link-list a',
                ]
            );
            
        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $service_item = $settings['service_item'];
        $link_item    = $settings['link_item'];
        ?>

        <!-- Health Service Warp Start -->
        <div class="health-service-warp ptb-100">
            <div class="container">
                <div class="row">
                    <div class="col-lg-8">
                        <div class="health-service-content">
                            <div class="blog-title">
                                <?php if( $settings['title']): ?>
                                    <h2><?php echo wp_kses_post( $settings['title'] ); ?></h2>
                                <?php endif; ?>
                                <?php if( $settings['content']): ?>
                                    <p><?php echo wp_kses_post( $settings['content'] ); ?></p>
                                <?php endif; ?>
                            </div>
                            <div class="health-service-location-widget">
                                <?php if( $settings['title_two']): ?>
                                    <h4><?php echo wp_kses_post( $settings['title_two'] ); ?></h4>
                                <?php endif; ?>
                                <?php foreach($service_item as $item_service): ?>
                                    <div class="health-service-item">
                                        <h5><?php echo wp_kses_post( $item_service['ser_title'] ); ?></h5>
                                        <ul class="parking-item-list">
                                            <li><?php echo wp_kses_post( $item_service['ser_content'] ); ?></li>
                                            <li><?php echo wp_kses_post( $item_service['ser_date'] ); ?></li>
                                            <li>
                                                <a href="tel:<?php echo wp_kses_post( $item_service['number'] ); ?>"><?php echo wp_kses_post( $item_service['number'] ); ?></a>
                                            </li>
                                        </ul>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                            <?php if( $settings['content_box1']): ?>
                                <div class="health-service-appointment">
                                    <?php echo wp_kses_post( $settings['content_box1'] ); ?>
                                </div>
                            <?php endif; ?>
                            <?php if( $settings['content_box2']): ?>
                                <div class="health-service-contact">
                                    <?php echo wp_kses_post( $settings['content_box2'] ); ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <div class="accessibility-link-widget">
                            <div class="accessibility-link-list">
                                <?php foreach($link_item as $item_link): ?>
                                    <a href="<?php echo wp_kses_post( $item_link['link_url'] ); ?>" class="item <?php if ($item_link['active_style']=='1'): ?>inactive<?php elseif($item_link['active_style']=='2'): ?>active<?php endif; ?>"><?php echo wp_kses_post( $item_link['link_text'] ); ?>
                                        <div class="icon">
                                            <i class="ti ti-caret-right-filled"></i>
                                        </div>
                                    </a>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Health Service Warp End -->
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Health_Service );