<?php
/**
 * Links One Widget
 */

namespace Elementor;
class Falar_Links extends Widget_Base {

	public function get_name() {
        return 'Falar_Links';
    }

	public function get_title() {
        return __( 'Links', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Links_Area',
			[
				'label' => __( 'Links Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'link_text',
            [
                'label'       => __( 'Link Text', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Overview', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'arrow_icon',
            [
                'type'    => Controls_Manager::ICON,
                'label'   => esc_html__( 'Arrow Icon', 'falar-toolkit' ),
                'label_block' => true,
                'options' => falar_icons(),
            ]
        );
        $this->add_control(
            'link_url',
            [
                'label'       => __( 'Link Url', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('#', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
			'links_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'link_color',
				[
					'label'     => __( 'Link Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .over-view-widget a' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'link_typography',
                    'label'    => __( 'Link Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .over-view-widget a',
                ]
            );

            $this->add_control(
				'border_color',
				[
					'label'     => __( 'Border Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .over-view-widget a' => 'border-color: {{VALUE}}',
					],
				]
			);

        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        ?>
        <?php if( $settings['link_text']): ?>
            <div class="over-view-widget">
                <a href="<?php echo wp_kses_post( $settings['link_url'] ); ?>">
                    <?php echo wp_kses_post( $settings['link_text'] ); ?>
                    <i class="<?php echo esc_attr( $settings['arrow_icon']) ?>"></i>
                </a>
            </div>
        <?php endif; ?>
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Links );