<?php
/**
 * Events Optional Widget
 */

namespace Elementor;
class Falar_Optional_Events extends Widget_Base {

	public function get_name() {
        return 'Falar_Optional_Events';
    }

	public function get_title() {
        return __( 'Optional Events', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Optional_Events_Area',
			[
				'label' => __( 'Optional Events Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $list_items = new Repeater();

            $list_items->add_control(
				'events_image',
				[
					'label'       => __( 'Card Image', 'falar-toolkit' ),
					'type'        => Controls_Manager::MEDIA,
				]
			);
            $list_items->add_control(
				'card_title',
				[
					'label'       => __( 'Card Title', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'card_link',
				[
					'label'       => __( 'card Link', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $this->add_control(
                'events_item',
                [
                    'label' => esc_html__('Add Events Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'events_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Card Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .optional-event-widget .optional-content' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Card Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .optional-event-widget .optional-content',
                ]
            );

        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $events_item = $settings['events_item'];
        ?>

        <!-- Optional Events Warp Start -->
        <div class="optional-events-warp">
            <div class="container-fluid">
                <div class="optional-event-slider-warp">
                    <div class="swiper optional-event-slider">
                        <div class="swiper-wrapper">
                            <?php foreach($events_item as $item_events): ?>
                                <div class="swiper-slide">
                                    <div class="optional-event-widget">
                                        <?php if( $item_events['events_image']['url'] != '' ): ?>
                                            <img src="<?php echo esc_url($item_events['events_image']['url'] ) ?>" alt="image">
                                        <?php endif; ?>
                                        <?php if( $item_events['card_link']): ?>
                                            <a href="<?php echo wp_kses_post( $item_events['card_link'] ); ?>" class="optional-content"><?php echo wp_kses_post( $item_events['card_title'] ); ?></a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Optional Events Warp End -->
        
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Optional_Events );