<?php
/**
 * Parking Locker Widget
 */

namespace Elementor;
class Falar_Parking_Locker extends Widget_Base {

	public function get_name() {
        return 'Falar_Parking_Locker';
    }

	public function get_title() {
        return __( 'Parking Locker', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Parking_Locker_Area',
			[
				'label' => __( 'Parking Locker Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Parking and Locker Services', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content',
            [
                'label'       => __( 'Content', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => __('Visit Falar is online portal, ePark. Students can find information about locker rentals on Falar Central.', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'title_two',
            [
                'label'       => __( 'Title Two', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Parking Office Locations, Hours and Contact Information', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $list_item = new Repeater();

            $list_item->add_control(
				'feature_title',
				[
					'label'       => __( 'Feature Title', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_item->add_control(
				'feature_content',
				[
					'label'       => __( 'Feature Content', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_item->add_control(
				'date',
				[
					'label'       => __( 'Feature Date', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_item->add_control(
				'number',
				[
					'label'       => __( 'Number', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $this->add_control(
                'locker_item',
                [
                    'label' => esc_html__('Add Locker Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_item->get_controls(),
                ]
            );

            $this->add_control(
                'content_box',
                [
                    'label'       => __( 'Content Box', 'falar-toolkit' ),
                    'type'        => Controls_Manager::WYSIWYG,
                    'label_block' => true,
                ]
            );

        $list_items = new Repeater();

            $list_items->add_control(
				'link_text',
				[
					'label'       => __( 'Link Text', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'link_url',
				[
					'label'       => __( 'Link Url', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
                'active_style',
                [
                    'label' 	=> esc_html__( 'Active/Inactive Style', 'falar-toolkit' ),
                    'type' 		=> Controls_Manager::SELECT,
                    'options' 	=> [
                        '1'         => esc_html__( 'Inactive', 'falar-toolkit' ),
                        '2'         => esc_html__( 'Active', 'falar-toolkit' ),
                    ],
                    'default' => '1',
                ]
            );
            $this->add_control(
                'link_item',
                [
                    'label' => esc_html__('Add Link Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'parking_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .blog-title h2' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .blog-title h2',
                ]
            );
			$this->add_control(
				'content_color',
				[
					'label'     => __( 'Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .blog-title p' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .blog-title p',
                ]
            );

            $this->add_control(
				'title_color2',
				[
					'label'     => __( 'Title Color Two', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .parking-locker-content .parking-location-widget h4' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography2',
                    'label'    => __( 'Title Typography Two', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .parking-locker-content .parking-location-widget h4',
                ]
            );
            $this->add_control(
				'title_color3',
				[
					'label'     => __( 'Title Color Three', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .parking-locker-content .parking-location-widget .parking-item h5' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography3',
                    'label'    => __( 'Title Typography Three', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .parking-locker-content .parking-location-widget .parking-item h5',
                ]
            );

            $this->add_control(
				'paragraph_color',
				[
					'label'     => __( 'Paragraph Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} p' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'paragraph_typography',
                    'label'    => __( 'Paragraph Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} p',
                ]
            );

            $this->add_control(
				'site_btn_color',
				[
					'label'     => __( 'Site Button Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .accessibility-link-widget .accessibility-link-list a' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'site_btn_bg_color',
				[
					'label'     => __( 'Site Button Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .accessibility-link-widget .accessibility-link-list a' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'site_btn_typography',
                    'label'    => __( 'Site Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .accessibility-link-widget .accessibility-link-list a',
                ]
            );
            
        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $locker_item = $settings['locker_item'];
        $link_item    = $settings['link_item'];
        ?>

        <!-- Parking Locker Warp Start -->
        <div class="parking-locker-warp ptb-100">
            <div class="container">
                <div class="row">
                    <div class="col-lg-8">
                        <div class="parking-locker-content">
                            <div class="blog-title">
                                <?php if( $settings['title']): ?>
                                    <h2><?php echo wp_kses_post( $settings['title'] ); ?></h2>
                                <?php endif; ?>
                                <?php if( $settings['content']): ?>
                                    <p><?php echo wp_kses_post( $settings['content'] ); ?></p>
                                <?php endif; ?>
                            </div>
                            <div class="parking-location-widget">
                                <?php if( $settings['title_two']): ?>
                                    <h4><?php echo wp_kses_post( $settings['title_two'] ); ?></h4>
                                <?php endif; ?>
                                <?php foreach($locker_item as $item_locker): ?>
                                    <div class="parking-item">
                                        <h5><?php echo wp_kses_post( $item_locker['feature_title'] ); ?></h5>
                                        <ul class="parking-item-list">
                                            <li><?php echo wp_kses_post( $item_locker['feature_content'] ); ?></li>
                                            <li><?php echo wp_kses_post( $item_locker['date'] ); ?></li>
                                            <li>
                                                <a href="tel:<?php echo wp_kses_post( $item_locker['number'] ); ?>"><?php echo wp_kses_post( $item_locker['number'] ); ?></a>
                                            </li>
                                        </ul>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                            <?php if( $settings['content_box']): ?>
                                <div class="parking-notice">
                                    <?php echo wp_kses_post($settings['content_box']); ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <div class="accessibility-link-widget">
                            <div class="accessibility-link-list">
                                <?php foreach($link_item as $item_link): ?>
                                    <a href="<?php echo wp_kses_post( $item_link['link_url'] ); ?>" class="item <?php if ($item_link['active_style']=='1'): ?>inactive<?php elseif($item_link['active_style']=='2'): ?>active<?php endif; ?>"><?php echo wp_kses_post( $item_link['link_text'] ); ?>
                                        <div class="icon">
                                            <i class="ti ti-caret-right-filled"></i>
                                        </div>
                                    </a>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Parking Locker Warp End -->
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Parking_Locker );