<?php
/**
 * Privacy-Policy Widget
 */

namespace Elementor;
class Falar_Privacy_Policy extends Widget_Base {

	public function get_name() {
        return 'Falar_Privacy_Policy';
    }

	public function get_title() {
        return __( 'Privacy Policy', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Privacy_Policy_Area',
			[
				'label' => __( 'Privacy Policy Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
            $this->add_control(
                'privacy_policy_content',
                [
                    'label' => __( 'Privacy Policy Content', 'falar-toolkit' ),
                    'type' => Controls_Manager::WYSIWYG,
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'privacy_policy_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

            $this->add_control(
				'heading_color',
				[
					'label'     => __( 'Heading Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .privacy-policy-content h1, .privacy-policy-content h2, .privacy-policy-content h3, .privacy-policy-content h4, .privacy-policy-content h5, .privacy-policy-content h6' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'heading_typography',
                    'label'    => __( 'Heading Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .privacy-policy-content h1, .privacy-policy-content h2, .privacy-policy-content h3, .privacy-policy-content h4, .privacy-policy-content h5, .privacy-policy-content h6',
                ]
            );
            $this->add_control(
				'content_color',
				[
					'label'     => __( 'Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .privacy-policy-content p' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .privacy-policy-content p',
                ]
            );


        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

		?>

        <div class="privacy-policy-warp ptb-100">
            <div class="container">
                <div class="privacy-policy-content">
                    <?php if( $settings['privacy_policy_content']): ?>
                        <?php echo wp_kses_post($settings['privacy_policy_content']); ?>
                    <?php endif; ?>
                </div>
            </div> 
        </div>
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Privacy_Policy );