<?php
/**
 * Program Widget
 */

namespace Elementor;
class Falar_Program_Choose extends Widget_Base {

	public function get_name() {
        return 'Falar_Program_Choose';
    }

	public function get_title() {
        return __( 'Program Choose', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Program_Area',
			[
				'label' => __( 'Program Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => __('Please select up to 3 program choices in order of preference.', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content',
            [
                'label'       => __( 'Content', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => __('If you do not meet the requirements for your first program choice, we will process your second program choice and then your third program choice. Please note that the Fall term is scheduled from September to December; the Winter term is scheduled from January to April; and the Summer term is scheduled from May to August.', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
            $this->add_control(
                'shortcode',
                [
                    'label'   => __( 'Choose Form Shortcode', 'falar-toolkit' ),
                    'type'    => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'program_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .program-small-widget h5' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .program-small-widget h5',
                ]
            );

            $this->add_control(
				'info_title_color',
				[
					'label'     => __( 'Info Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .program-small-widget .program-item span' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'info_title_typography',
                    'label'    => __( 'Info Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .program-small-widget .program-item span',
                ]
            );
            $this->add_control(
				'info_content_color',
				[
					'label'     => __( 'Info Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .program-small-widget .program-item p' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'info_content_typography',
                    'label'    => __( 'Info Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .program-small-widget .program-item p',
                ]
            );

            $this->add_control(
				'info_bg_color',
				[
					'label'     => __( 'Info Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .program-small-widget' => 'background: {{VALUE}}',
					],
				]
			);

            $this->add_control(
				'title_color2',
				[
					'label'     => __( 'Title Color Two', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .blog-title h2' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography2',
                    'label'    => __( 'Title Typography Two', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .blog-title h2',
                ]
            );

            $this->add_control(
				'btn_color',
				[
					'label'     => __( 'Button Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .default-btn' => 'color: {{VALUE}}',
					],
				]
			);
            $this->add_control(
				'btn_bg_color',
				[
					'label'     => __( 'Button Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .default-btn' => 'background: {{VALUE}}',
					],
				]
			);
			
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn_typography',
                    'label'    => __( 'Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .default-btn',
                ]
            );
            
        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        ?>

        <!-- Program Choose Warp Start -->
        <div class="program-choose-warp pb-100">
            <div class="container">
                <div class="program-choose-content">
                    <?php if( $settings['title']): ?>
                        <h4><?php echo wp_kses_post( $settings['title'] ); ?></h4>
                    <?php endif; ?>
                    <?php if( $settings['content']): ?>
                        <p><?php echo wp_kses_post( $settings['content'] ); ?></p>
                    <?php endif; ?>
                </div>
                <?php echo do_shortcode( $settings['shortcode'] ); ?>
            </div>
        </div>
        <!-- Program Choose Warp End -->
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Program_Choose );