<?php
/**
 * Program  Page Wrap Widget
 */

namespace Elementor;
class Falar_Program_Page_Wrap extends Widget_Base {

	public function get_name() {
        return 'Falar_Program_Page_Wrap';
    }

	public function get_title() {
        return __( 'Program Page Wrap', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Program_Page_Wrap_Area',
			[
				'label' => __( 'Program Page Wrap Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('We Have <span>36+</span> Programs In Total In Luva University', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'content',
            [
                'label'       => __( 'Content', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => __('Falar offers the variety of programming you might find at a large university, but with the personalized learning experience of a small, liberal arts school. We offer more than 36 majors, minors, graduate programs and advanced certificates.', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        $list_items = new Repeater();

            $list_items->add_control(
				'program_image',
				[
					'label'       => __( 'Program Image', 'falar-toolkit' ),
					'type'        => Controls_Manager::MEDIA,
				]
			);
            $this->add_control(
                'program_item',
                [
                    'label' => esc_html__('Add Program Image Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );
        
        $this->end_controls_section();

        $this->start_controls_section(
			'program_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .program-page-title h2' => 'color: {{PROGRAM}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .program-page-title h2',
                ]
            );
			$this->add_control(
				'content_color',
				[
					'label'     => __( 'Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .program-page-content p' => 'color: {{PROGRAM}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .program-page-content p',
                ]
            );
           
        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $program_item = $settings['program_item'];
        ?>

        <!-- Program Page Warp Start -->
        <div class="program-page-warp ptb-100">
            <div class="container">
                <div class="row">
                    <div class="col-lg-6">
                        <div class="program-page-title">
                            <?php if( $settings['title']): ?>
                                <h2><?php echo wp_kses_post( $settings['title'] ); ?></h2>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="program-page-content">
                            <?php if( $settings['content']): ?>
                                <p><?php echo wp_kses_post( $settings['content'] ); ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="program-page-image">
                    <div class="row g-5">
                        <?php foreach($program_item as $item_program): ?>
                            <div class="col-lg-3 col-md-6" data-cue="slideInUp">
                                <?php if( $item_program['program_image']['url'] != '' ): ?>
                                    <div class="image">
                                        <img src="<?php echo esc_url($item_program['program_image']['url'] ) ?>" class="image" alt="image">
                                    </div>
                                <?php endif; ?>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </div>
        <!-- Program Page Warp End -->
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Program_Page_Wrap );