<?php
/**
 * Program Widget
*/

namespace Elementor;
class Falar_Program_Six extends Widget_Base {

	public function get_name() {
        return 'Program_Six';
    }

	public function get_title() {
        return __( 'Program Six', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-tools';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'program_section',
			[
				'label' => __( 'Program', 'falar-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

            $list_items = new Repeater();

            $list_items->add_control(
                'title',
                [
                    'label' => __( 'Tab Title', 'falar-toolkit' ),
                    'default' => __( 'Undergraduate', 'falar-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                ]
            );
            $list_items->add_control(
                'btn_url',
                [
                    'label' => __( 'Button Url', 'falar-toolkit' ),
                    'default' => __( '#', 'falar-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                ]
            );
            $list_items->add_control(
                'btn_text',
                [
                    'label' => __( 'Button Text', 'falar-toolkit' ),
                    'default' => __( 'View All Programs', 'falar-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                ]
            );
            $list_items->add_control(
                'limit',
                [
                    'label' => esc_attr__( 'Posts Limit', 'falar-toolkit' ),
                    'description' => esc_attr__( 'Choose posts limit', 'falar-toolkit' ),
                    'type' => Controls_Manager::TEXT,

                    'default' => '4',

                ]
            );

            $list_items->add_control(
                'categories',
                [
                    'label' => esc_attr__( 'Show Only Specific Categories', 'falar-toolkit' ),
                    'description' => esc_attr__( 'Enter categories slugs to narrow output (Note: only listed categories will be displayed, divide categories with linebreak (Enter)).', 'falar-toolkit' ),
                    'type' => Controls_Manager::TEXTAREA,
                    'options' => falar_toolkit_get_page_program_cat_el(),

                ]
            );

            $list_items->add_control(
                'order',
                [
                    'label' => esc_attr__( 'Order', 'falar-toolkit' ),
                    'description' => esc_attr__( '', 'falar-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'desc' => esc_attr__( 'Descending', 'falar-toolkit' ),
                        'asc' => esc_attr__( 'Ascending', 'falar-toolkit' ),
                    ],
                    'default' => 'desc',

                ]
            );

            $this->add_control(
                'programs',
                [
                    'label' => __('Program Items', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );

            $this->add_control(
                'shape',
                [
                    'label'       => __( 'Shape', 'falar-toolkit' ),
                    'type'        => Controls_Manager::MEDIA,
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'program_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
            'title_color',
            [
                'label'     => __( 'Title Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .undergraduate-widget h3' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'title_typography',
                'label'    => __( 'Title Typography', 'falar-toolkit' ),
                'selector' => '{{WRAPPER}} .undergraduate-widget h3',
            ]
        );
        $this->add_control(
            'card_title_color',
            [
                'label'     => __( 'Link Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .undergraduate-widget .undergraduate-list li a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'card_title_typography',
                'label'    => __( 'Link Typography', 'falar-toolkit' ),
                'selector' => '{{WRAPPER}} .undergraduate-widget .undergraduate-list li',
            ]
        );
        $this->add_control(
            'btn_color',
            [
                'label'     => __( 'Button Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .undergraduate-widget .default-btn' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn_border_color',
            [
                'label'     => __( 'Button Border Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .undergraduate-widget .default-btn' => 'border-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'btn_typography',
                'label'    => __( 'Button Typography', 'falar-toolkit' ),
                'selector' => '{{WRAPPER}} .undergraduate-widget .default-btn',
            ]
        );

        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings_for_display();
        ?>

        <!-- Undergraduate Warp Start -->
        <div class="undergraduate-warp home-four-undergraduate">
            <div class="container">
                <div class="inner-undergraduate-warp four-undergraduate-widget">
                    <div class="row g-4">
                    <?php $tab_i = 1; foreach($settings['programs'] as $tab): 
                        $limit = ( isset( $tab['limit'] ) && is_numeric($tab['limit']) ) ? intval( $tab['limit'] ) : 8;
                        $orderby = ( isset($tab['order_by']) && $tab['order_by'] ) ? esc_attr( $tab['order_by'] ) : 'post_date';
                        $order = ( isset($tab['order']) && $tab['order'] ) ? esc_attr( $tab['order'] ) : 'desc';

                        if($tab['categories']){
                            $posts = new \WP_Query( array(
                                'post_type' => 'program',
                                'posts_per_page' => $limit,
                                'orderby' => $orderby,
                                'order' => $order,
                                'tax_query' => array(
                                    array (
                                        'taxonomy' => 'program_cat',
                                        'field' => 'name',
                                        'terms' => $tab['categories'],
                                    )
                                ),
                            ));
                        }else{
                            $posts = new \WP_Query( array(
                                'post_type' => 'program',
                                'posts_per_page' => $limit,
                                'orderby' => $orderby,
                                'order' => $order,
                            ));
                        }
                        ?>
                        <div class="col-lg-6 <?php if($tab_i == 1): ?>border-right<?php endif; ?> col-sm-6">
                            <div class="undergraduate-widget">
                                <h3 class="reveal3"><?php echo esc_html($tab['title']); ?></h3>
                                <ul class="undergraduate-list">
                                    <?php
                                        while($posts->have_posts()):
                                        $posts->the_post();
                                        $id              =  get_the_ID();
                                    ?>
                                    <li>
                                        <a href="<?php echo esc_url(get_the_permalink($id)); ?>">
                                            <?php the_title(); ?>
                                            <i class="ti ti-arrow-narrow-right"></i>
                                        </a>
                                    </li>
                                    <?php endwhile; wp_reset_postdata();?>
                                </ul>
                                <a href="<?php echo esc_html($tab['btn_url']); ?>" class="default-btn">
                                    <?php echo esc_html($tab['btn_text']); ?>
                                    <i class="ti ti-arrow-narrow-right"></i>
                                </a>
                            </div>
                        </div>
                        <?php $tab_i++; endforeach; ?>
                    </div>
                </div>
            </div>
            <?php if( $settings['shape']['url'] != '' ): ?>
                <div class="all-shapes">
                    <img src="<?php echo esc_url( $settings['shape']['url'] ); ?>" class="undergraduate-shape" alt="Word">
                </div>
            <?php endif; ?>
        </div>
        <!-- Undergraduate Warp End -->

        <?php
    }

}

Plugin::instance()->widgets_manager->register( new Falar_Program_Six );