<?php
/**
 * Program Widget
*/

namespace Elementor;
class Falar_Program extends Widget_Base {

	public function get_name() {
        return 'Program';
    }

	public function get_title() {
        return __( 'Program', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-person';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'program_section',
			[
				'label' => __( 'Program', 'falar-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Graduate Programs At Falar', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

            $this->add_control(
                'cat_name',
                [
                    'label' => __( 'Choose Category', 'falar-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => falar_toolkit_get_page_program_cat_el(),
                ]
            );

            $this->add_control(
                'order',
                [
                    'label' => __( 'Program Order By', 'falar-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'DESC'      => __( 'DESC', 'falar-toolkit' ),
                        'ASC'       => __( 'ASC', 'falar-toolkit' ),
                    ],
                    'default' => 'DESC',
                ]
            );

            $this->add_control(
                'count',
                [
                    'label' => __( 'Post Per Page', 'falar-toolkit' ),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 4,
                    'description' => __('If you want to see all post, type -1','falar-toolkit')
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'program_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
            'title_color',
            [
                'label'     => __( 'Title Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-warp h2' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'title_typography',
                'label'    => __( 'Title Typography', 'falar-toolkit' ),
                'selector' => '{{WRAPPER}} .section-warp h2',
            ]
        );
        $this->add_control(
            'card_top_color',
            [
                'label'     => __( 'Card Top Title Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .management-widget .content ul li' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'title_content_typography',
                'label'    => __( 'Card top title Typography', 'falar-toolkit' ),
                'selector' => '{{WRAPPER}} .management-widget .content ul li',
            ]
        );
        $this->add_control(
            'card_title_color',
            [
                'label'     => __( 'Card Title Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .management-widget .content h3 a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'card_title_typography',
                'label'    => __( 'Card Title Typography', 'falar-toolkit' ),
                'selector' => '{{WRAPPER}} .management-widget .content h3',
            ]
        );
        $this->add_control(
            'card_content_color',
            [
                'label'     => __( 'Card Content Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .management-widget .content p' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'card_content_typography',
                'label'    => __( 'Card Content Typography', 'falar-toolkit' ),
                'selector' => '{{WRAPPER}} .management-widget .content p',
            ]
        );
        
        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        // Program Query
        if( $settings['cat_name'] != '' ) {
            $args = array(
                'post_type'     => 'program',
                'posts_per_page'=> $settings['count'],
                'order'         => $settings['order'],
                'tax_query'     => array(
                    array(
                        'taxonomy'      => 'program_cat',
                        'field'         => 'slug',
                        'terms'         => $settings['cat_name'],
                        'hide_empty'    => false
                    )
                )
            );
        } else {
            $args = array(
                'post_type'         => 'program',
                'posts_per_page'    => $settings['count'],
                'order'             => $settings['order']
            );
        }

        $program_array = new \WP_Query( $args );

        ?>

        <!-- Management Warp Start -->
        <div class="management-warp ptb-100">
            <div class="container">
                <div class="section-warp">
                    <?php if( $settings['title']): ?>
                        <h2 class="reveal3"><?php echo wp_kses_post( $settings['title'] ); ?></h2>
                    <?php endif; ?>
                </div>
                <div class="management-slider-warp">
                    <div class="swiper management-slider">
                        <div class="swiper-wrapper">
                            <?php
                                $i=1;
                                while($program_array->have_posts()):
                                $program_array->the_post();
                                $id                =  get_the_ID();
                                $program_top_title  = get_field( 'program_top_title' );
                            ?>
                                <div class="swiper-slide">
                                    <div class="management-widget">
                                        <?php if(get_the_post_thumbnail_url() != ''): ?>
                                            <div class="image">
                                                <a href="<?php echo esc_url(get_the_permalink($id)); ?>"><img src="<?php echo get_the_post_thumbnail_url( get_the_ID() ); ?>" alt="image"></a>
                                            </div>
                                        <?php endif; ?>
                                        <div class="content">
                                            <ul>
                                                <?php if($program_top_title): ?>
                                                    <li>
                                                        <img src="<?php echo esc_url(get_template_directory_uri() .'/assets/img/graduate.svg') ?>" alt="ico">
                                                        <?php echo wp_kses_post($program_top_title); ?>
                                                    </li>
                                                <?php endif; ?>
                                            </ul>
                                            <h3>
                                                <a href="<?php echo esc_url(get_the_permalink($id)); ?>"><?php the_title(); ?></a>
                                            </h3>
                                            <?php echo the_excerpt(); ?>
                                        </div>
                                    </div>
                                </div>
                            <?php $i++; endwhile; wp_reset_postdata();?>
                        </div>
                    </div>
                    <div class="swiper-btn style2">
                        <div class="swiper-button-next"></div>
                        <div class="swiper-button-prev"></div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Management Warp End -->
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Program );