<?php
/**
 * Question Widget
 */

namespace Elementor;
class Falar_Question extends Widget_Base {

	public function get_name() {
        return 'Falar_Question_Section';
    }

	public function get_title() {
        return __( 'Question Section', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Question_Area',
			[
				'label' => __( 'Question Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'top_title',
            [
                'label'       => __( 'Top Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Frequently Asked Questions', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'tab_title1',
            [
                'label'       => __( 'Tab Title One', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('INTERNATIONAL STUDENT', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

            $list_item = new Repeater();

            $list_item->add_control(
                'question_title1',
                [
                    'label' => __( 'Question Title', 'falar-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                ]
            );
            $list_item->add_control(
                'question_content1',
                [
                    'label' => __( 'Question Content', 'falar-toolkit' ),
                    'type' => Controls_Manager::TEXTAREA,
                ]
            );
            $this->add_control(
                'question_item1',
                [
                    'label' => esc_html__('Add Question Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_item->get_controls(),
                ]
            );

            $this->add_control(
                'tab_title2',
                [
                    'label'       => __( 'Tab Title Two', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('PROFESSIONALS', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
    
            $list_items = new Repeater();

            $list_items->add_control(
                'question_title2',
                [
                    'label' => __( 'Question Title', 'falar-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                ]
            );
            $list_items->add_control(
                'question_content2',
                [
                    'label' => __( 'Question Content', 'falar-toolkit' ),
                    'type' => Controls_Manager::TEXTAREA,
                ]
            );
            $this->add_control(
                'question_item2',
                [
                    'label' => esc_html__('Add Question Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );

            $this->add_control(
                'tab_title3',
                [
                    'label'       => __( 'Tab Title Three', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('ALUMNI', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );

            $list_itemss = new Repeater();

            $list_itemss->add_control(
                'question_title3',
                [
                    'label' => __( 'Question Title', 'falar-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                ]
            );
            $list_itemss->add_control(
                'question_content3',
                [
                    'label' => __( 'Question Content', 'falar-toolkit' ),
                    'type' => Controls_Manager::TEXTAREA,
                ]
            );
            $this->add_control(
                'question_item3',
                [
                    'label' => esc_html__('Add Question Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_itemss->get_controls(),
                ]
            );

            $this->add_control(
                'tab_title4',
                [
                    'label'       => __( 'Tab Title Four', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('CURRENT STUDENT', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
            
            $list_itemsss = new Repeater();

            $list_itemsss->add_control(
                'question_title4',
                [
                    'label' => __( 'Question Title', 'falar-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                ]
            );
            $list_itemsss->add_control(
                'question_content4',
                [
                    'label' => __( 'Question Content', 'falar-toolkit' ),
                    'type' => Controls_Manager::TEXTAREA,
                ]
            );
            $this->add_control(
                'question_item4',
                [
                    'label' => esc_html__('Add Question Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_itemsss->get_controls(),
                ]
            );

            $this->add_control(
                'question_image',
                [
                    'label' => __( 'Quetion Image', 'falar-toolkit' ),
                    'type' => Controls_Manager::MEDIA,
                ]
            );


        $this->end_controls_section();

        $this->start_controls_section(
			'question_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_control(
            'top_title_color',
            [
                'label'     => __( 'Top Title Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .question-content .title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'top_title_typography',
                'label'    => __( 'Top Title Typography', 'falar-toolkit' ),
                'selector' => '{{WRAPPER}} .question-content .title',
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label'     => __( 'Title Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .question-content h2' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'title_typography',
                'label'    => __( 'Title Typography', 'falar-toolkit' ),
                'selector' => '{{WRAPPER}} .question-content h2',
            ]
        );
        $this->add_control(
            'tab_title_color',
            [
                'label'     => __( 'Tab Title Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .question-content .question-tab .nav-item .nav-link' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'tab_title_bg_color',
            [
                'label'     => __( 'Tab Title Background Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .question-content .question-tab .nav-item .nav-link' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'tab_title_typography2',
                'label'    => __( 'Tab Title Typography', 'falar-toolkit' ),
                'selector' => '{{WRAPPER}} .question-content .question-tab .nav-item .nav-link',
            ]
        );
        $this->add_control(
            'faq_title_color',
            [
                'label'     => __( 'Faq Title Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .question-content .accordion-question .accordion-item .accordion-button' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'faq_title_typography',
                'label'    => __( 'Faq Title Typography', 'falar-toolkit' ),
                'selector' => '{{WRAPPER}} .question-content .accordion-question .accordion-item .accordion-button',
            ]
        );
        $this->add_control(
            'faq_content_color',
            [
                'label'     => __( 'Faq Content Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .question-content .accordion-question .accordion-item .accordion-body p' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'faq_content_typography',
                'label'    => __( 'Faq Content Typography', 'falar-toolkit' ),
                'selector' => '{{WRAPPER}} .question-content .accordion-question .accordion-item .accordion-body p',
            ]
        );


        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');

        $question_item1 = $settings['question_item1'];
        $question_item2 = $settings['question_item2'];
        $question_item3 = $settings['question_item3'];
        $question_item4 = $settings['question_item4'];
		?>

            <!-- Question Warp Start -->
            <div class="question-warp pb-100">
                <div class="container">
                    <div class="row align-items-center">
                        <div class="col-lg-7">
                            <div class="question-content">
                                <?php if( $settings['top_title']): ?>
                                    <span class="title"><?php echo wp_kses_post( $settings['top_title'] ); ?></span>
                                <?php endif; ?> 
                                <?php if( $settings['title']): ?>
                                    <h2 class="reveal3">
                                        <?php echo wp_kses_post( $settings['title'] ); ?>
                                    </h2>
                                <?php endif; ?> 
                                <ul class="nav question-tab nav-pills mb-3" id="pills-tab" role="tablist">
                                    <?php if( $settings['tab_title1']): ?>
                                        <li class="nav-item" role="presentation">
                                        <button class="nav-link active" id="pills-home-tab" data-bs-toggle="pill" data-bs-target="#pills-home" type="button" role="tab" aria-controls="pills-home" aria-selected="true"><?php echo wp_kses_post( $settings['tab_title1'] ); ?></button>
                                        </li>
                                    <?php endif; ?>

                                    <?php if( $settings['tab_title2']): ?>
                                        <li class="nav-item" role="presentation">
                                        <button class="nav-link" id="pills-profile-tab" data-bs-toggle="pill" data-bs-target="#pills-profile" type="button" role="tab" aria-controls="pills-profile" aria-selected="false"><?php echo wp_kses_post( $settings['tab_title2'] ); ?></button>
                                        </li>
                                    <?php endif; ?>

                                    <?php if( $settings['tab_title3']): ?>
                                        <li class="nav-item" role="presentation">
                                        <button class="nav-link" id="pills-contact-tab" data-bs-toggle="pill" data-bs-target="#pills-contact" type="button" role="tab" aria-controls="pills-contact" aria-selected="false"><?php echo wp_kses_post( $settings['tab_title3'] ); ?></button>
                                        </li>
                                    <?php endif; ?>

                                    <?php if( $settings['tab_title4']): ?>
                                        <li class="nav-item" role="presentation">
                                        <button class="nav-link" id="pills-student-tab" data-bs-toggle="pill" data-bs-target="#pills-student" type="button" role="tab" aria-controls="pills-student" aria-selected="false"><?php echo wp_kses_post( $settings['tab_title4'] ); ?></button>
                                        </li>
                                    <?php endif; ?>
                                </ul>

                                <div class="tab-content" id="pills-tabContent">

                                    <div class="tab-pane fade show active" id="pills-home" role="tabpanel" aria-labelledby="pills-home-tab" tabindex="0">

                                        <div class="accordion-question">
                                            <div class="accordion" id="faqAccordion">
                                                <?php $i = 1;  foreach( $question_item1 as $item_question1 ): 
                                                    $cl='';
                                                    if ($i == 1) {
                                                        $cl='';
                                                    }else {
                                                        $cl='collapsed';
                                                    }

                                                    if($i <= 10):
                                                ?>
                                                <?php if( $item_question1['question_title1']): ?>
                                                    <div class="accordion-item">
                                                        <button class="accordion-button <?php echo esc_attr($cl); ?>" type="button" data-bs-toggle="collapse" data-bs-target="#collapse1<?php echo $i; ?>" aria-expanded="true" aria-controls="collapse1<?php echo $i; ?>">
                                                            <?php echo esc_attr( $item_question1['question_title1']) ?>
                                                        </button>

                                                        <div id="collapse1<?php echo $i; ?>" class="accordion-collapse collapse <?php if($i == 1): ?>show<?php endif; ?>" data-bs-parent="#faqAccordion">
                                                            <div class="accordion-body">
                                                                <p><?php echo wp_kses_post( $item_question1['question_content1']) ?></p>
                                                            </div>
                                                        </div>
                                                    </div>
                                                <?php endif; ?>
                                                <?php endif; $i++; endforeach; ?>
                                            </div>
                                        </div>
                                        
                                    </div>

                                    <div class="tab-pane fade" id="pills-profile" role="tabpanel" aria-labelledby="pills-profile-tab" tabindex="0">

                                        <div class="accordion-question">
                                            <div class="accordion" id="faqAccordion2">
                                                <?php $i1 = 1;  foreach( $question_item2 as $item_question2 ): 
                                                    $cl='';
                                                    if ($i1 == 1) {
                                                        $cl='';
                                                    }else {
                                                        $cl='collapsed';
                                                    }

                                                    if($i1 <= 10):
                                                ?>
                                                <?php if( $item_question2['question_title2']): ?>
                                                    <div class="accordion-item">
                                                        <button class="accordion-button <?php echo esc_attr($cl); ?>" type="button" data-bs-toggle="collapse" data-bs-target="#collapse2<?php echo $i1; ?>" aria-expanded="true" aria-controls="collapse2<?php echo $i1; ?>">
                                                            <?php echo esc_attr( $item_question2['question_title2']) ?>
                                                        </button>

                                                        <div id="collapse2<?php echo $i1; ?>" class="accordion-collapse collapse <?php if($i1 == 1): ?>show<?php endif; ?>" data-bs-parent="#faqAccordion2">
                                                            <div class="accordion-body">
                                                                <p><?php echo wp_kses_post( $item_question2['question_content2']) ?></p>
                                                            </div>
                                                        </div>
                                                    </div>
                                                <?php endif; ?>
                                                <?php endif; $i1++; endforeach; ?>
                                            </div>
                                        </div>

                                    </div>

                                    <div class="tab-pane fade" id="pills-contact" role="tabpanel" aria-labelledby="pills-contact-tab" tabindex="0">
                                        
                                        <div class="accordion-question">
                                            <div class="accordion" id="faqAccordion3">
                                                <?php $i2 = 1;  foreach( $question_item3 as $item_question3 ): 
                                                    $cl='';
                                                    if ($i2 == 1) {
                                                        $cl='';
                                                    }else {
                                                        $cl='collapsed';
                                                    }

                                                    if($i2 <= 10):
                                                ?>
                                                <?php if( $item_question3['question_title3']): ?>
                                                    <div class="accordion-item">
                                                        <button class="accordion-button <?php echo esc_attr($cl); ?>" type="button" data-bs-toggle="collapse" data-bs-target="#collapse3<?php echo $i2; ?>" aria-expanded="true" aria-controls="collapse3<?php echo $i2; ?>">
                                                            <?php echo esc_attr( $item_question3['question_title3']) ?>
                                                        </button>

                                                        <div id="collapse3<?php echo $i2; ?>" class="accordion-collapse collapse <?php if($i2 == 1): ?>show<?php endif; ?>" data-bs-parent="#faqAccordion3">
                                                            <div class="accordion-body">
                                                                <p><?php echo wp_kses_post( $item_question3['question_content3']) ?></p>
                                                            </div>
                                                        </div>
                                                    </div>
                                                <?php endif; ?>
                                                <?php endif; $i2++; endforeach; ?>
                                            </div>
                                        </div>

                                    </div>

                                    <div class="tab-pane fade" id="pills-student" role="tabpanel" aria-labelledby="pills-student-tab" tabindex="0">
                                        
                                        <div class="accordion-question">
                                            <div class="accordion" id="faqAccordion4">
                                                <?php $i3 = 1;  foreach( $question_item4 as $item_question4 ): 
                                                    $cl='';
                                                    if ($i3 == 1) {
                                                        $cl='';
                                                    }else {
                                                        $cl='collapsed';
                                                    }

                                                    if($i3 <= 10):
                                                ?>
                                                <?php if( $item_question4['question_title4']): ?>
                                                    <div class="accordion-item">
                                                        <button class="accordion-button <?php echo esc_attr($cl); ?>" type="button" data-bs-toggle="collapse" data-bs-target="#collapse4<?php echo $i3; ?>" aria-expanded="true" aria-controls="collapse4<?php echo $i3; ?>">
                                                            <?php echo esc_attr( $item_question4['question_title4']) ?>
                                                        </button>

                                                        <div id="collapse4<?php echo $i3; ?>" class="accordion-collapse collapse <?php if($i3 == 1): ?>show<?php endif; ?>" data-bs-parent="#faqAccordion4">
                                                            <div class="accordion-body">
                                                                <p><?php echo wp_kses_post( $item_question4['question_content4']) ?></p>
                                                            </div>
                                                        </div>
                                                    </div>
                                                <?php endif; ?>
                                                <?php endif; $i3++; endforeach; ?>
                                            </div>
                                        </div>

                                    </div>

                                </div>
                            </div>
                        </div>
                        <div class="col-lg-5">
                            <div class="question-images reveal2">
                                <?php if( $settings['question_image']['url'] != '' ): ?>
                                    <img src="<?php echo esc_url($settings['question_image']['url'] ) ?>" alt="image">
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Question Warp End -->
        <?php
	}
}

Plugin::instance()->widgets_manager->register( new Falar_Question );