<?php
/**
 * Recent Posts Three Widget
 */

namespace Elementor;
class Falar_Recent_Posts_Three extends Widget_Base {

	public function get_name() {
        return 'Falar_Recent_Posts_Three';
    }

	public function get_title() {
        return __( 'Recent Posts Three', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Recent_Posts_Three_Area',
			[
				'label' => __( 'Recent Posts Three Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

            $this->add_control(
				'title',
				[
					'label'       => __( 'Title', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
					'default'     => __('Explore Latest News', 'falar-toolkit'),
                    'label_block' => true,
				]
			);

            $this->add_control(
                'button_text',
                [
                    'label'   => __( 'Button Text', 'falar-toolkit' ),
                    'type'    => Controls_Manager::TEXT,
                    'default' => __('View All Articles', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'button_url',
                [
                    'label'   => __( 'Button Url', 'falar-toolkit' ),
                    'type'    => Controls_Manager::TEXT,
                    'default' => __('#', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'view_button_text',
                [
                    'label'   => __( 'View Button Text', 'falar-toolkit' ),
                    'type'    => Controls_Manager::TEXT,
                    'default' => __('Read Article', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );

            $this->add_control(
                'cat_name',
                [
                    'label' => __( 'Choose Category', 'falar-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => falar_toolkit_get_post_cat_list(),
                ]
            );
            $this->add_control(
                'count',
                [
                    'label'       => __( 'Show Post Count', 'falar-toolkit' ),
                    'default'     => __( '6', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'description' => __('if you want to see all post, type -1','falar-toolkit')
                ]
            );
            $this->add_control(
                'order',
                [
                    'label'   => __( 'Select Order', 'falar-toolkit' ),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'DESC'  => __( 'DESC', 'falar-toolkit' ),
                        'ASC'   => __( 'ASC', 'falar-toolkit' ),
                    ],
                    'default'   => 'DESC',
                ]
            );

            $this->add_control(
				'donate_icon',
				[
					'label'       => __( 'Donate Icon', 'falar-toolkit' ),
					'type'        => Controls_Manager::MEDIA,
                    'label_block' => true,
				]
			);
            $this->add_control(
				'donate_content',
				[
					'label'       => __( 'Donate Content', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
					'default'     => __('Help create an Unlimited future for Luva students.', 'falar-toolkit'),
                    'label_block' => true,
				]
			);
            $this->add_control(
				'donate_btn_text',
				[
					'label'       => __( 'Donate Button Text', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
					'default'     => __('Donate Today', 'falar-toolkit'),
                    'label_block' => true,
				]
			);
            $this->add_control(
				'donate_btn_url',
				[
					'label'       => __( 'Donate Button Url', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);

        $this->end_controls_section();

        $this->start_controls_section(
			'streaming_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .section-warp h2' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .section-warp h2',
                ]
            );

            $this->add_control(
				'btn_color',
				[
					'label'     => __( 'Button Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .section-warp .view-link' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn_typography',
                    'label'    => __( 'Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .section-warp .view-link',
                ]
            );

			$this->add_control(
				'card_title_color',
				[
					'label'     => __( 'Card Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .hf-faculty-main h3 a' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'card_title_typography',
                    'label'    => __( 'Card Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .hf-faculty-main h3',
                ]
            );

            $this->add_control(
				'cat_color',
				[
					'label'     => __( 'Category Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .hf-faculty-main .tags' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'cat_typography',
                    'label'    => __( 'Category Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .hf-faculty-main .tags',
                ]
            );

            $this->add_control(
				'info_color',
				[
					'label'     => __( 'Info Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .hf-faculty-main ul li' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'info_typography',
                    'label'    => __( 'Info Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .hf-faculty-main ul li',
                ]
            );

            $this->add_control(
				'card_title_color2',
				[
					'label'     => __( 'Card Title Color Two', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .hf-faculty-item h3 a' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'card_title_typography2',
                    'label'    => __( 'Card Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .hf-faculty-item h3',
                ]
            );
            $this->add_control(
				'card_meta_color',
				[
					'label'     => __( 'Card Meta Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .hf-faculty-item ul li' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'card_meta_typography',
                    'label'    => __( 'Card Meta Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .hf-faculty-item ul li',
                ]
            );
            $this->add_control(
				'card_btn_color',
				[
					'label'     => __( 'Card Button Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .default-btn' => 'color: {{VALUE}}',
					],
				]
			);

            $this->add_control(
				'card_btn_bg_color',
				[
					'label'     => __( 'Card Button background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .default-btn' => 'background-color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'card_btn_typography',
                    'label'    => __( 'Card Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .default-btn',
                ]
            );

            $this->add_control(
				'donate_content_color',
				[
					'label'     => __( 'Donate Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .home-four-donate .content h6' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'donate_typography',
                    'label'    => __( 'Donate Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .home-four-donate .content h6',
                ]
            );
            $this->add_control(
				'donate_btn_color',
				[
					'label'     => __( 'Donate Button Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .home-four-donate .content .donate-link' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'donate_btn_typography',
                    'label'    => __( 'Donate Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .home-four-donate .content .donate-link',
                ]
            );

            $this->add_control(
				'donate_bg_color',
				[
					'label'     => __( 'Donate Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .home-four-donate' => 'background: {{VALUE}}',
					],
				]
			);

            $this->add_control(
				'card_title_color3',
				[
					'label'     => __( 'Card Title Color Three', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .hf-faculty-card-item .content h3 a' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'card_title_typography3',
                    'label'    => __( 'Card Title Three Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .hf-faculty-card-item .content h3',
                ]
            );
            $this->add_control(
				'card_cat_color3',
				[
					'label'     => __( 'Card Cat Three', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .hf-faculty-card-item .content .tags' => 'color: {{VALUE}}',
					],
				]
			);
            $this->add_control(
				'card_bg_color3',
				[
					'label'     => __( 'Card cat Bacground Three', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .hf-faculty-card-item .content .tags' => 'background: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'card_cat_typography3',
                    'label'    => __( 'Card Cat Three Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .hf-faculty-card-item .content .tags',
                ]
            );

        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');

        // Post Query
        if( $settings['cat_name'] != '' ) {
            $args = array(
                'post_type'     => 'post',
                'posts_per_page'=> $settings['count'],
                'order'         => $settings['order'],
                'meta_key'      => '_thumbnail_id',
                'ignore_sticky_posts' => 1,
                'tax_query'     => array(
                    array(
                        'taxonomy'      => 'category',
                        'field'         => 'slug',
                        'terms'         => $settings['cat_name'],
                        'hide_empty'    => false,
                    )
                )
            );
        } else {
            $args = array(
                'post_type'           => 'post',
                'posts_per_page'      => $settings['count'],
                'order'               => $settings['order'],
                'meta_key'            => '_thumbnail_id',
                'ignore_sticky_posts' => 1,
            );
        }

        $post_array = new \WP_Query( $args ); 
        ?>

        <!-- Home Five Faculty Area Start -->
        <div class="home-five-faculty-area ptb-100">
            <div class="container">
                <div class="section-warp">
                    <?php if( $settings['title']): ?>
                        <h2 class="reveal2">
                            <?php echo wp_kses_post( $settings['title'] ); ?>
                        </h2>
                    <?php endif; ?>
                    <?php if( $settings['button_url']): ?>
                        <a href="<?php echo wp_kses_post( $settings['button_url'] ); ?>" class="view-link">
                            <span><?php echo wp_kses_post( $settings['button_text'] ); ?></span>
                            <i class="ti ti-arrow-narrow-right"></i>
                        </a>
                    <?php endif; ?>
                </div>
                <div class="row gy-4 gx-5">
                    <div class="col-lg-8">
                        <div class="row gy-4 gx-5">
                            <div class="col-lg-6 col-md-6">
                                <?php
                                    $i     = 1;
                                    while ( $post_array->have_posts() ): $post_array->the_post();
                                    $id    = get_the_ID();
                                    $title = get_the_title( get_the_ID() );
                                ?>
                                <?php if($i == 1): ?>
                                <div class="hf-faculty-main">
                                    <div class="image">
                                        <a href="<?php echo esc_url(get_the_permalink($id)); ?>">
                                        <img src="<?php echo get_the_post_thumbnail_url( $id, 'falar_post_thumb_Two' ); ?>" alt="image">
                                        </a>
                                    </div>
                                    <?php
                                        $categories = get_the_category();
                                        if ($categories) {
                                            echo '<ul class="ps-0 mb-0 list-unstyled cat">';
                                            foreach ($categories as $category) {
                                                echo '<li><a class="tags" href="' . esc_url(get_category_link($category->term_id)) . '">' . esc_html($category->name) . '</a></li>';
                                            }
                                            echo '</ul>';
                                        }
                                    ?>
                                    <h3>
                                        <a href="<?php echo esc_url(get_the_permalink($id)); ?>"><?php echo wp_kses_post($title); ?></a>
                                    </h3>
                                    <ul>
                                        <li><?php echo esc_html(get_the_date()); ?></li>
                                        <li><?php echo esc_html(falar_post_reading_time()); ?></li>
                                    </ul>
                                </div>
                                <?php endif; $i++; endwhile; ?>
                                <?php
                                    wp_reset_query();
                                ?>
                            </div>
                            <div class="col-lg-6 col-md-6">
                                <?php
                                    $i     = 1;
                                    while ( $post_array->have_posts() ): $post_array->the_post();
                                    $id    = get_the_ID();
                                    $title = get_the_title( get_the_ID() );
                                ?>
                                <?php if($i == 2): ?>
                                    <div class="hf-faculty-item">
                                        <?php
                                            $categories = get_the_category();
                                            if ($categories) {
                                                echo '<ul class="ps-0 mb-0 list-unstyled cat">';
                                                foreach ($categories as $category) {
                                                    echo '<li><a class="tags" href="' . esc_url(get_category_link($category->term_id)) . '">' . esc_html($category->name) . '</a></li>';
                                                }
                                                echo '</ul>';
                                            }
                                        ?>
                                        <h3>
                                            <a href="<?php echo esc_url(get_the_permalink($id)); ?>"><?php echo wp_kses_post($title); ?></a>
                                        </h3>
                                        <ul>
                                            <li><?php echo esc_html(get_the_date()); ?></li>
                                            <li><?php echo esc_html(falar_post_reading_time()); ?></li>
                                        </ul>
                                        <?php if( $settings['view_button_text']): ?>
                                            <a href="<?php echo esc_url(get_the_permalink($id)); ?>" class="default-btn">
                                                <?php echo wp_kses_post( $settings['view_button_text'] ); ?>
                                                <i class="ti ti-arrow-narrow-right"></i>
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                <?php endif; $i++; endwhile; ?>
                                <?php
                                    wp_reset_query();
                                ?>
                                <?php
                                    $i     = 1;
                                    while ( $post_array->have_posts() ): $post_array->the_post();
                                    $id    = get_the_ID();
                                    $title = get_the_title( get_the_ID() );
                                ?>
                                <?php if($i == 3): ?>
                                    <div class="hf-faculty-item">
                                        <?php
                                            $categories = get_the_category();
                                            if ($categories) {
                                                echo '<ul class="ps-0 mb-0 list-unstyled cat">';
                                                foreach ($categories as $category) {
                                                    echo '<li><a class="tags" href="' . esc_url(get_category_link($category->term_id)) . '">' . esc_html($category->name) . '</a></li>';
                                                }
                                                echo '</ul>';
                                            }
                                        ?>
                                        <h3>
                                            <a href="<?php echo esc_url(get_the_permalink($id)); ?>"><?php echo wp_kses_post($title); ?></a>
                                        </h3>
                                        <ul>
                                            <li><?php echo esc_html(get_the_date()); ?></li>
                                            <li><?php echo esc_html(falar_post_reading_time()); ?></li>
                                        </ul>
                                        <?php if( $settings['view_button_text']): ?>
                                            <a href="<?php echo esc_url(get_the_permalink($id)); ?>" class="default-btn">
                                                <?php echo wp_kses_post( $settings['view_button_text'] ); ?>
                                                <i class="ti ti-arrow-narrow-right"></i>
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                <?php endif; $i++; endwhile; ?>
                                <?php
                                    wp_reset_query();
                                ?>
                            </div>
                            <div class="col-lg-12">
                                <?php if( $settings['donate_content']): ?>
                                    <div class="home-four-donate faculty-donate">
                                        <?php if( $settings['donate_icon']['url'] != '' ): ?>
                                            <div class="icon">
                                                <img src="<?php echo esc_url($settings['donate_icon']['url'] ) ?>" alt="image">
                                            </div>
                                        <?php endif; ?>
                                        <div class="content">
                                            <?php if( $settings['donate_content']): ?>
                                                <h6>
                                                    <?php echo wp_kses_post( $settings['donate_content'] ); ?>
                                                </h6>
                                            <?php endif; ?>
                                            <?php if( $settings['donate_btn_url']): ?>
                                                <a href="<?php echo wp_kses_post( $settings['donate_btn_url'] ); ?>" class="donate-link">
                                                    <span><?php echo wp_kses_post( $settings['donate_btn_text'] ); ?></span>
                                                    <i class="ti ti-arrow-narrow-right"></i>
                                                </a>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <?php
                            $i     = 1;
                            while ( $post_array->have_posts() ): $post_array->the_post();
                            $id    = get_the_ID();
                            $title = get_the_title( get_the_ID() );
                        ?>
                        <?php if($i >= 4): ?>
                        <div class="hf-faculty-card-item">
                            <img src="<?php echo get_the_post_thumbnail_url( $id, 'falar_post_thumb_Two' ); ?>" alt="image">
                            <div class="content">
                                <?php
                                    $categories = get_the_category();
                                    if ($categories) {
                                        echo '<ul class="ps-0 mb-0 list-unstyled cat">';
                                        foreach ($categories as $category) {
                                            echo '<li><a class="tags" href="' . esc_url(get_category_link($category->term_id)) . '">' . esc_html($category->name) . '</a></li>';
                                        }
                                        echo '</ul>';
                                    }
                                ?>
                                <h3>
                                    <a href="<?php echo esc_url(get_the_permalink($id)); ?>"><?php echo wp_kses_post($title); ?></a>
                                </h3>
                            </div>
                        </div>
                        <?php endif; $i++; endwhile; ?>
                        <?php
                            wp_reset_query();
                        ?>
                    </div>
                </div>
            </div>
        </div>
        <!-- Home Five Favulty Area End -->
        
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Recent_Posts_Three );