<?php
/**
 * Recent Posts Widget
 */

namespace Elementor;
class Falar_Recent_Posts_Two extends Widget_Base {

	public function get_name() {
        return 'Falar_Recent_Posts_Two';
    }

	public function get_title() {
        return __( 'Recent Posts Two', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Recent_Posts_Two_Area',
			[
				'label' => __( 'Recent Posts Two Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

            $this->add_control(
				'top_title',
				[
					'label'       => __( 'Top Title', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
					'default'     => __('6. NEWS AND UPDATES', 'falar-toolkit'),
                    'label_block' => true,
				]
			);
            $this->add_control(
				'title',
				[
					'label'       => __( 'Title', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
					'default'     => __('Explore Latest News', 'falar-toolkit'),
                    'label_block' => true,
				]
			);

            $this->add_control(
                'button_text',
                [
                    'label'   => __( 'Button Text', 'falar-toolkit' ),
                    'type'    => Controls_Manager::TEXT,
                    'default' => __('Read Article', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );

            $this->add_control(
                'cat_name',
                [
                    'label' => __( 'Choose Category', 'falar-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => falar_toolkit_get_post_cat_list(),
                ]
            );
            $this->add_control(
                'count',
                [
                    'label'       => __( 'Show Post Count', 'falar-toolkit' ),
                    'default'     => __( '4', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'description' => __('if you want to see all post, type -1','falar-toolkit')
                ]
            );
            $this->add_control(
                'order',
                [
                    'label'   => __( 'Select Order', 'falar-toolkit' ),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'DESC'  => __( 'DESC', 'falar-toolkit' ),
                        'ASC'   => __( 'ASC', 'falar-toolkit' ),
                    ],
                    'default'   => 'DESC',
                ]
            );

            $this->add_control(
				'shape',
				[
					'label'       => __( 'Shape', 'falar-toolkit' ),
					'type'        => Controls_Manager::MEDIA,
                    'label_block' => true,
				]
			);

        $this->end_controls_section();

        $this->start_controls_section(
			'streaming_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'top_title_color',
				[
					'label'     => __( 'Top Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .research-explore-widget .title' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'top_title_typography',
                    'label'    => __( 'Top Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .research-explore-widget .title',
                ]
            );
			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .research-explore-widget h3' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .research-explore-widget h3',
                ]
            );

			$this->add_control(
				'card_title_color',
				[
					'label'     => __( 'Card Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .research-explore-widget .rex-item h4 a' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'card_title_typography',
                    'label'    => __( 'Card Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .research-explore-widget .rex-item h4',
                ]
            );

            $this->add_control(
				'cat_color',
				[
					'label'     => __( 'Category Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .research-explore-widget .rex-item .cat li a' => 'color: {{VALUE}}',
					],
				]
			);
            $this->add_control(
				'cat_bg_color',
				[
					'label'     => __( 'Category Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .research-explore-widget .rex-item .cat li a' => 'background: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'cat_typography',
                    'label'    => __( 'Category Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .research-explore-widget .rex-item .cat li a',
                ]
            );

            $this->add_control(
				'card_title_color2',
				[
					'label'     => __( 'Card Title Color Two', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rex-main-widget .content h3 a' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'card_title_typography2',
                    'label'    => __( 'Card Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .rex-main-widget .content h3',
                ]
            );
            $this->add_control(
				'cat_color2',
				[
					'label'     => __( 'Category Two Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rex-main-widget .content .tags-date .cat li a' => 'color: {{VALUE}}',
					],
				]
			);
            $this->add_control(
				'cat_bg_color2',
				[
					'label'     => __( 'Category Two Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rex-main-widget .content .tags-date .cat li a' => 'background: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'cat_typography2',
                    'label'    => __( 'Category Two Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .rex-main-widget .content .tags-date .cat li a',
                ]
            );
            $this->add_control(
				'card_meta_color',
				[
					'label'     => __( 'Card Meta Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rex-main-widget .content .tags-date ul li' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'card_meta_typography',
                    'label'    => __( 'Card Meta Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .rex-main-widget .content .tags-date ul li',
                ]
            );
            $this->add_control(
				'card_btn_color',
				[
					'label'     => __( 'Card Button Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rex-main-widget .content .rex-link' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'card_btn_typography',
                    'label'    => __( 'Card Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .rex-main-widget .content .rex-link',
                ]
            );

            $this->add_control(
				'area_bg_color',
				[
					'label'     => __( 'Area Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .research-explore-area' => 'background: {{VALUE}}',
					],
				]
			);

        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');

        // Post Query
        if( $settings['cat_name'] != '' ) {
            $args = array(
                'post_type'     => 'post',
                'posts_per_page'=> $settings['count'],
                'order'         => $settings['order'],
                'meta_key'      => '_thumbnail_id',
                'ignore_sticky_posts' => 1,
                'tax_query'     => array(
                    array(
                        'taxonomy'      => 'category',
                        'field'         => 'slug',
                        'terms'         => $settings['cat_name'],
                        'hide_empty'    => false,
                    )
                )
            );
        } else {
            $args = array(
                'post_type'           => 'post',
                'posts_per_page'      => $settings['count'],
                'order'               => $settings['order'],
                'meta_key'            => '_thumbnail_id',
                'ignore_sticky_posts' => 1,
            );
        }

        $post_array = new \WP_Query( $args ); 
        ?>

        <!-- Research Explore Area Start -->
        <div class="research-explore-area ptb-100">
            <div class="container">
                <div class="row g-4">
                    <div class="col-lg-5">
                        <div class="research-explore-widget">
                            <?php if( $settings['top_title']): ?>
                                <span class="title"><?php echo wp_kses_post( $settings['top_title'] ); ?></span>
                            <?php endif; ?>
                            <?php if( $settings['title']): ?>
                                <h3><?php echo wp_kses_post( $settings['title'] ); ?></h3>
                            <?php endif; ?>
                            <?php
                                $i     = 1;
                                while ( $post_array->have_posts() ): $post_array->the_post();
                                $id    = get_the_ID();
                                $title = get_the_title( get_the_ID() );
                            ?>
                            <?php if($i <= 3): ?>
                            <div class="rex-item">
                                <?php
                                    $categories = get_the_category();
                                    if ($categories) {
                                        echo '<ul class="ps-0 mb-0 list-unstyled cat">';
                                        foreach ($categories as $category) {
                                            echo '<li><a href="' . esc_url(get_category_link($category->term_id)) . '">' . esc_html($category->name) . '</a></li>';
                                        }
                                        echo '</ul>';
                                    }
                                ?>
                                <h4>
                                    <a href="<?php echo esc_url(get_the_permalink($id)); ?>"><?php echo wp_kses_post($title); ?></a>
                                </h4>
                            </div>
                            <?php endif; $i++; endwhile; ?>
                            <?php
                                wp_reset_query();
                            ?>
                        </div>
                    </div>
                    <div class="col-lg-7">
                        <?php
                            $i     = 1;
                            while ( $post_array->have_posts() ): $post_array->the_post();
                            $id    = get_the_ID();
                            $title = get_the_title( get_the_ID() );
                        ?>
                        <?php if($i == 4): ?>
                        <div class="rex-main-widget">
                            <div class="image">
                                <img src="<?php echo get_the_post_thumbnail_url( get_the_ID() ); ?>" class="explore-image" alt="Image">
                            </div>
                            <div class="content">
                                <div class="tags-date">
                                    <?php
                                        $categories = get_the_category();
                                        if ($categories) {
                                            echo '<ul class="ps-0 mb-0 list-unstyled cat">';
                                            foreach ($categories as $category) {
                                                echo '<li><a href="' . esc_url(get_category_link($category->term_id)) . '">' . esc_html($category->name) . '</a></li>';
                                            }
                                            echo '</ul>';
                                        }
                                    ?>
                                    <ul>
                                        <li><?php echo esc_html(get_the_date()); ?></li>
                                        <li><?php echo esc_html(falar_post_reading_time()); ?></li>
                                    </ul>
                                </div>
                                <h3>
                                    <a href="<?php echo esc_url(get_the_permalink($id)); ?>"><?php echo wp_kses_post($title); ?></a>
                                </h3>
                                <?php if( $settings['button_text']): ?>
                                    <a href="<?php echo esc_url(get_the_permalink($id)); ?>" class="rex-link">
                                        <?php echo wp_kses_post( $settings['button_text'] ); ?>
                                        <i class="ti ti-arrow-narrow-right"></i>
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php endif; $i++; endwhile; ?>
                        <?php
                            wp_reset_query();
                        ?>
                    </div>
                </div>
            </div>
            <?php if( $settings['shape']['url'] != '' ): ?>
                <div class="all-shapes">
                    <img src="<?php echo esc_url($settings['shape']['url'] ) ?>" class="rex-shape" alt="image">
                </div>
            <?php endif; ?>
        </div>
        <!-- Research Explore Area End -->
        
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Recent_Posts_Two );