<?php
/**
 * Related Career Widget
*/

namespace Elementor;
class Falar_Related_Career extends Widget_Base {

	public function get_name() {
        return 'Related_Career';
    }

	public function get_title() {
        return __( 'Related Career', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-person';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'related_career_section',
			[
				'label' => __( 'Related Career', 'falar-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Related Job Post', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'btn_text',
            [
                'label'       => __( 'Button Text', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('View Details', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

            $this->add_control(
                'cat_name',
                [
                    'label' => __( 'Choose Category', 'falar-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => falar_toolkit_get_page_career_cat_el(),
                ]
            );

            $this->add_control(
                'order',
                [
                    'label' => __( 'Career Order By', 'falar-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'DESC'      => __( 'DESC', 'falar-toolkit' ),
                        'ASC'       => __( 'ASC', 'falar-toolkit' ),
                    ],
                    'default' => 'DESC',
                ]
            );

            $this->add_control(
                'count',
                [
                    'label' => __( 'Post Per Page', 'falar-toolkit' ),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 2,
                    'description' => __('If you want to see all post, type -1','falar-toolkit')
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'career_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
            'title_color',
            [
                'label'     => __( 'Title Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'title_typography',
                'label'    => __( 'Title Typography', 'falar-toolkit' ),
                'selector' => '{{WRAPPER}} .section-title h2',
            ]
        );
        $this->add_control(
            'card_top_color',
            [
                'label'     => __( 'Card Top Title Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .event-widget span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'card_top_bg_color',
            [
                'label'     => __( 'Card Top Title Background Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .event-widget span' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'title_content_typography',
                'label'    => __( 'Card top title Typography', 'falar-toolkit' ),
                'selector' => '{{WRAPPER}} .event-widget span',
            ]
        );
        $this->add_control(
            'card_title_color',
            [
                'label'     => __( 'Card Title Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .event-widget h3 a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'card_title_typography',
                'label'    => __( 'Card Title Typography', 'falar-toolkit' ),
                'selector' => '{{WRAPPER}} .event-widget h3',
            ]
        );
        $this->add_control(
            'card_content_color',
            [
                'label'     => __( 'Card Content Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .event-widget .event-list li' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'card_content_typography',
                'label'    => __( 'Card Content Typography', 'falar-toolkit' ),
                'selector' => '{{WRAPPER}} .event-widget .event-list li',
            ]
        );
        $this->add_control(
            'card_bg_color',
            [
                'label'     => __( 'Card Background Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .event-widget' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        
        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        // Career Query
        if( $settings['cat_name'] != '' ) {
            $args = array(
                'post_type'     => 'career',
                'posts_per_page'=> $settings['count'],
                'order'         => $settings['order'],
                'tax_query'     => array(
                    array(
                        'taxonomy'      => 'career_cat',
                        'field'         => 'slug',
                        'terms'         => $settings['cat_name'],
                        'hide_empty'    => false
                    )
                )
            );
        } else {
            $args = array(
                'post_type'         => 'career',
                'posts_per_page'    => $settings['count'],
                'order'             => $settings['order']
            );
        }

        $career_array = new \WP_Query( $args );

        ?>

        <!-- Open Roles Job Warp Start -->
        <div class="open-roles-jobs-warp pb-100">
            <div class="container">
                <div class="section-title">
                    <?php if( $settings['title']): ?>
                        <h2 class="reveal3"><?php echo wp_kses_post( $settings['title'] ); ?></h2>
                    <?php endif; ?>
                </div>
                <div class="row g-4">
                    <?php
                        $i=1;
                        while($career_array->have_posts()):
                        $career_array->the_post();
                        $id                =  get_the_ID();
                        $career_top_title  = get_field( 'career_top_title' );
                        $career_date       = get_field( 'career_date' );
                        $career_location   = get_field( 'career_location' );
                    ?>
                    <div class="col-lg-6" data-cue="slideInUp">
                        <div class="event-widget bg-1 open-role-card">
                            <?php if($career_top_title): ?>
                                <a href="<?php echo esc_url(get_the_permalink($id)); ?>"><span><?php echo wp_kses_post($career_top_title); ?></span></a>
                            <?php endif; ?>
                            <h3>
                                <a href="<?php echo esc_url(get_the_permalink($id)); ?>">
                                    <?php the_title(); ?>
                                </a>
                            </h3>
                            <ul class="event-list">
                                <?php if($career_date): ?>
                                    <li>
                                        <i class="ti ti-calendar"></i>
                                        <?php echo wp_kses_post($career_date); ?>
                                    </li>
                                <?php endif; ?>
                                <?php if($career_location): ?>
                                    <li>
                                        <i class="ti ti-map-pin"></i>
                                        <?php echo wp_kses_post($career_location); ?>
                                    </li>
                                <?php endif; ?>
                            </ul>
                            <?php if( $settings['btn_text']): ?>
                                <a href="<?php echo esc_url(get_the_permalink($id)); ?>" class="default-btn"><?php echo wp_kses_post( $settings['btn_text'] ); ?> 
                                    <i class="ti ti-arrow-narrow-right"></i>
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php $i++; endwhile; wp_reset_postdata();?>
                </div>
            </div>
        </div>
        <!-- Open Roles Job Warp End -->
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Related_Career );