<?php
/**
 * Requirement Widget
 */

namespace Elementor;
class Falar_Requirement extends Widget_Base {

	public function get_name() {
        return 'Falar_Requirement';
    }

	public function get_title() {
        return __( 'Requirement', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Requirement_Area',
			[
				'label' => __( 'Requirement Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $list_items = new Repeater();

            $list_items->add_control(
				'link_text',
				[
					'label'       => __( 'Link Text', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'link_url',
				[
					'label'       => __( 'Link Url', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $this->add_control(
                'link_item',
                [
                    'label' => esc_html__('Add Link Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );

        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Graduate Program Requirement', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content',
            [
                'label'       => __( 'Content', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => __('Welcome to requirement studies at Falar University, a world-class institution of higher education in the heart of Canada. Our requirement student body of nearly 4,500, representing over 120 countries embodies the diverse, inclusive, and socially-minded spirit that shapes our world.', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'button_text1',
            [
                'label'   => __( 'Button Text One', 'falar-toolkit' ),
                'type'    => Controls_Manager::TEXT,
                'default' => __('Apply Now', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'button_url1',
            [
                'label'   => __( 'Button Url One', 'falar-toolkit' ),
                'type'    => Controls_Manager::TEXT,
                'default' => __('#', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'button_text2',
            [
                'label'   => __( 'Button Text Two', 'falar-toolkit' ),
                'type'    => Controls_Manager::TEXT,
                'default' => __('See How To Apply', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'button_url2',
            [
                'label'   => __( 'Button Url Two', 'falar-toolkit' ),
                'type'    => Controls_Manager::TEXT,
                'default' => __('#', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
			'requirement_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'site_btn_color',
				[
					'label'     => __( 'Site Button Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .requirements-small-widget .requirement-list a' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'site_btn_bg_color',
				[
					'label'     => __( 'Site Button Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .requirements-small-widget .requirement-list a' => 'background-color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'site_btn_typography',
                    'label'    => __( 'Site Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .requirements-small-widget .requirement-list a',
                ]
            );
			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .requirement-big-warp h2' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .requirement-big-warp h2',
                ]
            );
			$this->add_control(
				'content_color',
				[
					'label'     => __( 'Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .requirement-big-warp p' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .requirement-big-warp p',
                ]
            );
            $this->add_control(
				'btn_color1',
				[
					'label'     => __( 'Button Color One', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .requirement-big-warp .default-btn.style1' => 'color: {{VALUE}}',
					],
				]
			);
            $this->add_control(
				'btn_bg_color1',
				[
					'label'     => __( 'Button Background Color One', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .requirement-big-warp .default-btn.style1' => 'background: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn_typography1',
                    'label'    => __( 'Button Typography One', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .requirement-big-warp .default-btn.style1',
                ]
            );
            $this->add_control(
				'btn_color2',
				[
					'label'     => __( 'Button Color Two', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .requirement-big-warp .default-btn.style2' => 'color: {{VALUE}}',
					],
				]
			);
            $this->add_control(
				'btn_border_color2',
				[
					'label'     => __( 'Button Border Color Two', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .requirement-big-warp .default-btn.style2' => 'border-color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn_typography2',
                    'label'    => __( 'Button Typography Two', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .requirement-big-warp .default-btn.style2',
                ]
            );
            
        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $link_item = $settings['link_item'];
        ?>

        <!-- Requirement Warp Start  -->
        <div class="requirement-warp ptb-100">
            <div class="container">
                <div class="row">
                    <div class="col-lg-5">
                        <div class="requirements-small-widget">
                            <div class="requirement-list">
                                <?php foreach($link_item as $item_link): ?>
                                    <a href="<?php echo wp_kses_post( $item_link['link_url'] ); ?>" class="item"><?php echo wp_kses_post( $item_link['link_text'] ); ?>
                                    <i class="ti ti-caret-right-filled"></i>
                                    </a>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-7">
                        <div class="requirement-big-warp">
                            <?php if( $settings['title']): ?>
                                <h2><?php echo wp_kses_post( $settings['title'] ); ?></h2>
                            <?php endif; ?>
                            <?php if( $settings['content']): ?>
                                <p><?php echo wp_kses_post( $settings['content'] ); ?></p>
                            <?php endif; ?>
                            <div class="requirement-button">
                                <?php if( $settings['button_text1']): ?>
                                    <a href="<?php echo esc_html( $settings['button_url1'] ); ?>" class="default-btn style1">
                                        <?php echo esc_html( $settings['button_text1'] ); ?>
                                        <i class="ti ti-arrow-narrow-right"></i>
                                    </a>
                                <?php endif; ?>
                                <?php if( $settings['button_text2']): ?>
                                    <a href="<?php echo esc_html( $settings['button_url2'] ); ?>" class="default-btn style2">
                                        <?php echo esc_html( $settings['button_text2'] ); ?>
                                        <i class="ti ti-arrow-narrow-right"></i>
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Requirement Warp End  -->
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Requirement );