<?php
/**
 * Research Left Widget
 */

namespace Elementor;
class Falar_Research_Left extends Widget_Base {

	public function get_name() {
        return 'Falar_Research_Left';
    }

	public function get_title() {
        return __( 'Research Left', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Research_Left_Area',
			[
				'label' => __( 'Research Left Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'image1',
            [
                'label'       => __( 'Image One', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );

        $this->add_control(
            'image2',
            [
                'label'       => __( 'Image Two', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );

        $this->add_control(
            'icon',
            [
                'label'       => __( 'Icon', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );

        $this->add_control(
            'num',
            [
                'label'       => __( 'Number', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('15+', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content',
            [
                'label'       => __( 'Content', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Collected Awards', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
			'research_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Number Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .changing-wave-image .content-image .icon-heading h3' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .changing-wave-image .content-image .icon-heading h3',
                ]
            );
			$this->add_control(
				'content_color',
				[
					'label'     => __( 'Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .changing-wave-image .content-image p' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .changing-wave-image .content-image p',
                ]
            );
            $this->add_control(
				'content_bg_color',
				[
					'label'     => __( 'Content Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .changing-wave-image .content-image' => 'background: {{VALUE}}',
					],
				]
			);
            
        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        ?>

            <div class="changing-wave-image">
                <?php if( $settings['image1']['url'] != '' ): ?>
                    <img src="<?php echo esc_url($settings['image1']['url'] ) ?>" class="changing-image1" alt="image">
                <?php endif; ?>
                <?php if( $settings['image2']['url'] != '' ): ?>
                    <img src="<?php echo esc_url($settings['image2']['url'] ) ?>" class="changing-image2" alt="image">
                <?php endif; ?>
                <div class="content-image">
                    <div class="icon-heading">
                        <?php if( $settings['icon']['url'] != '' ): ?>
                            <img src="<?php echo esc_url($settings['icon']['url'] ) ?>" class="changing-icon" alt="image">
                        <?php endif; ?>
                        <h3><?php echo wp_kses_post( $settings['num'] ); ?></h3>
                    </div>
                    <p><?php echo wp_kses_post( $settings['content'] ); ?></p>
                </div>
            </div>
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Research_Left );