<?php
/**
 * Research Right Widget
 */

namespace Elementor;
class Falar_Research_Right extends Widget_Base {

	public function get_name() {
        return 'Falar_Research_Right';
    }

	public function get_title() {
        return __( 'Research Right', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Research_Right_Area',
			[
				'label' => __( 'Research Right Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('The world is changing and so we are in the wave', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content',
            [
                'label'       => __( 'Content', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('The mission of Luva is to serve as a digital gateway and information hub for all members of the university community.', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'button_text',
            [
                'label'       => __( 'Button Text', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Our Research', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'button_url',
            [
                'label'       => __( 'Button Url', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('#', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'feature_content',
            [
                'label'       => __( 'Feature Content', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXTAREA,
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
			'research_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .changing-wave-content h2' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .changing-wave-content h2',
                ]
            );
			$this->add_control(
				'content_color',
				[
					'label'     => __( 'Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .changing-wave-content p' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .changing-wave-content p',
                ]
            );
			$this->add_control(
				'feature_color',
				[
					'label'     => __( 'Feature Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .changing-wave-content ul li' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'feature_typography',
                    'label'    => __( 'Feature Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .changing-wave-content ul li',
                ]
            );
            $this->add_control(
				'btn_color',
				[
					'label'     => __( 'Button Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .changing-wave-content .default-btn' => 'color: {{VALUE}}',
					],
				]
			);
            $this->add_control(
				'btn_bg_color',
				[
					'label'     => __( 'Button Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .changing-wave-content .default-btn' => 'background: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn_typography',
                    'label'    => __( 'Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .changing-wave-content .default-btn',
                ]
            );
            
        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        ?>

            <div class="changing-wave-content">
                <?php if( $settings['title']): ?>
                    <h2><?php echo wp_kses_post( $settings['title'] ); ?></h2>
                <?php endif; ?>
                <?php if( $settings['content']): ?>
                    <p><?php echo wp_kses_post( $settings['content'] ); ?></p>
                <?php endif; ?>
                <?php if( $settings['button_url']): ?>
                    <a href="<?php echo wp_kses_post( $settings['button_url'] ); ?>" class="default-btn">
                        <?php echo wp_kses_post( $settings['button_text'] ); ?>
                        <i class="ti ti-arrow-narrow-right"></i>
                    </a>
                <?php endif; ?>
                <?php if( $settings['feature_content']): ?>
                    <ul>
                        <?php echo wp_kses_post( $settings['feature_content'] ); ?>
                    </ul>
                <?php endif; ?>
            </div>
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Research_Right );