<?php
/**
 * Single Program Widget
 */

namespace Elementor;
class Falar_Single_Program extends Widget_Base {

	public function get_name() {
        return 'Falar_Single_Program';
    }

	public function get_title() {
        return __( 'Single Program', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Single_Program_Area',
			[
				'label' => __( 'Single Program Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'content1',
            [
                'label'       => __( 'Content One', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXTAREA,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'image',
            [
                'label'       => __( 'Image', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content2',
            [
                'label'       => __( 'Content Two', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXTAREA,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content3',
            [
                'label'       => __( 'Content Three', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXTAREA,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'btn_text',
            [
                'label'       => __( 'Button Text', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Go Back To The Faculty List', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'btn_url',
            [
                'label'       => __( 'Button Url', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('#', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'title2',
            [
                'label'       => __( 'Title Two', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Faculty Details', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        $list_items = new Repeater();

            $list_items->add_control(
				'info_title',
				[
					'label'       => __( 'Info Title', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'info',
				[
					'label'       => __( 'Info', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXTAREA,
                    'label_block' => true,
				]
			);
            $this->add_control(
                'info_item',
                [
                    'label' => esc_html__('Add Information Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );
            $this->add_control(
                'button_info',
                [
                    'label'       => __( 'Bottom info', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('* Information only related to the National Call for Applications', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'btn_text2',
                [
                    'label'       => __( 'Button Text Two', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('Apply To The Faculty Now', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'btn_url2',
                [
                    'label'       => __( 'Button Url Two', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('#', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'btn_text3',
                [
                    'label'       => __( 'Button Text Three', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('View All Requirements', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'btn_url3',
                [
                    'label'       => __( 'Button Url Three', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('#', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
        $this->end_controls_section();

        $this->start_controls_section(
			'single_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .facilities-details-widget .content1 h3' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .facilities-details-widget .content1 h3',
                ]
            );
			$this->add_control(
				'content_color',
				[
					'label'     => __( 'Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .facilities-details-widget p' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .facilities-details-widget p',
                ]
            );

            $this->add_control(
				'title_color2',
				[
					'label'     => __( 'Title Color Two', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .facilities-details-widget .content2 h5' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography2',
                    'label'    => __( 'Title Typography Two', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .facilities-details-widget .content2 h5',
                ]
            );

            $this->add_control(
				'paragraph_color',
				[
					'label'     => __( 'Paragraph Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} p' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'paragraph_typography',
                    'label'    => __( 'Paragraph Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} p',
                ]
            );

            $this->add_control(
				'site_info_title_color',
				[
					'label'     => __( 'Site Info Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .facilities-small-widget .facilities-item span' => 'color: {{VALUE}}',
					],
				]
			);
			
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'site_info_title_typography',
                    'label'    => __( 'Site Info Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .facilities-small-widget .facilities-item span',
                ]
            );
            $this->add_control(
				'site_info_color',
				[
					'label'     => __( 'Site Info Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .facilities-small-widget .facilities-item  p' => 'color: {{VALUE}}',
					],
				]
			);
			
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'site_info_typography',
                    'label'    => __( 'Site Info Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .facilities-small-widget .facilities-item p',
                ]
            );
            $this->add_control(
				'site_area_bg_color',
				[
					'label'     => __( 'Site Area Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .facilities-small-widget' => 'background: {{VALUE}}',
					],
				]
			);

            $this->add_control(
				'btn_color',
				[
					'label'     => __( 'Button Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .facilities-small' => 'color: {{VALUE}}',
					],
				]
			);
            $this->add_control(
				'btn_bg_color',
				[
					'label'     => __( 'Button Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .facilities-small' => 'background: {{VALUE}}',
					],
				]
			);
			
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn_typography',
                    'label'    => __( 'Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .facilities-small',
                ]
            );
            
        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $info_item     = $settings['info_item'];
        ?>

        <!-- FacilitiesDetails Warp Start -->
        <div class="facilities-details-warp ptb-100">
            <div class="container">
                <div class="row">
                    <div class="col-lg-8">
                        <div class="facilities-details-widget">
                            <div class="content1">
                                <?php if( $settings['content1']): ?>
                                    <?php echo wp_kses_post( $settings['content1'] ); ?>
                                <?php endif; ?>
                            </div>
                            <?php if( $settings['image']['url'] != '' ): ?>
                                <div class="image">
                                    <img src="<?php echo esc_url($settings['image']['url'] ) ?>" alt="image">
                                </div>
                            <?php endif; ?>
                            <div class="content2">
                                <?php if( $settings['content2']): ?>
                                    <?php echo wp_kses_post( $settings['content2'] ); ?>
                                <?php endif; ?>
                            </div>
                            <div class="accreditation">
                                <?php if( $settings['content3']): ?>
                                    <?php echo wp_kses_post( $settings['content3'] ); ?>
                                <?php endif; ?>
                            </div>
                            <?php if( $settings['btn_url']): ?>
                                <a href="<?php echo wp_kses_post( $settings['btn_url'] ); ?>" class="default-btn">
                                    <i class="ti ti-arrow-narrow-left"></i>
                                    <?php echo wp_kses_post( $settings['btn_text'] ); ?>
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <div class="facilities-small-widget">
                            <?php if( $settings['title2']): ?>
                                <h5><?php echo wp_kses_post( $settings['title2'] ); ?></h5>
                            <?php endif; ?>
                            <?php foreach($info_item as $item_info): ?>
                                <div class="facilities-item">
                                    <span><?php echo wp_kses_post( $item_info['info_title'] ); ?></span>
                                    <?php echo wp_kses_post( $item_info['info'] ); ?>
                                </div>
                            <?php endforeach; ?>
                            <?php if( $settings['button_info']): ?>
                                <p class="info"><?php echo wp_kses_post( $settings['button_info'] ); ?></p>
                            <?php endif; ?>
                        </div>
                        <?php if( $settings['btn_url2']): ?>
                            <a href="<?php echo wp_kses_post( $settings['btn_url2'] ); ?>" class="default-btn facilities-small"><?php echo wp_kses_post( $settings['btn_text2'] ); ?>
                                <i class="ti ti-arrow-narrow-right"></i>
                            </a>
                        <?php endif; ?>
                        <?php if( $settings['btn_url3']): ?>
                            <a href="<?php echo wp_kses_post( $settings['btn_url3'] ); ?>" class="facilities-requirements"><?php echo wp_kses_post( $settings['btn_text3'] ); ?>
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        <!-- FacilitiesDetails Warp End -->
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Single_Program );