<?php
/**
 * Sustainability Widget
 */

namespace Elementor;
class Falar_Sustainability extends Widget_Base {

	public function get_name() {
        return 'Falar_Sustainability';
    }

	public function get_title() {
        return __( 'Sustainability', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Sustainability_Area',
			[
				'label' => __( 'Sustainability Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Sustainability', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content',
            [
                'label'       => __( 'Content One', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Sheridan continues to lead, manage and innovate for long-term sustainability, seeking novel approaches to funding options and partnerships, and reinforcing our leadership in green campus initiatives.', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        $list_items = new Repeater();

            $list_items->add_control(
				'feature_content',
				[
					'label'       => __( 'Feature Content', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXTAREA,
                    'label_block' => true,
				]
			);
            $this->add_control(
                'sustainability_item',
                [
                    'label' => esc_html__('Add Sustainability Feature Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );
            $this->add_control(
                'sustainability_img1',
                [
                    'label'       => __( 'Sustainability Image One', 'falar-toolkit' ),
                    'type'        => Controls_Manager::MEDIA,
                ]
            );
            $this->add_control(
                'sustainability_img2',
                [
                    'label'       => __( 'Sustainability Image Two', 'falar-toolkit' ),
                    'type'        => Controls_Manager::MEDIA,
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'sustainability_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Number Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .sustainability-content h2' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Number Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .sustainability-content h2',
                ]
            );
			$this->add_control(
				'content_color',
				[
					'label'     => __( 'Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .sustainability-content p' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .sustainability-content p',
                ]
            );
            $this->add_control(
				'feature_title_color',
				[
					'label'     => __( 'Link Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .sustainability-content .sustainability-list li' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'feature_title_typography',
                    'label'    => __( 'Link Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .sustainability-content .sustainability-list li',
                ]
            );

            $this->add_control(
				'area_color',
				[
					'label'     => __( 'Area Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .sustainability-warp::before' => 'background: {{VALUE}}',
					],
				]
			);

        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $sustainability_item = $settings['sustainability_item'];
        ?>

        <!-- Sustainability Warp Start -->
        <div class="sustainability-warp pb-100">
            <div class="container">
                <div class="row">
                    <div class="col-lg-6">
                        <div class="sustainability-content">
                            <?php if( $settings['title']): ?>
                                <h2 class="reveal3">
                                    <?php echo wp_kses_post( $settings['title'] ); ?>
                                </h2>
                            <?php endif; ?> 
                            <?php if( $settings['content']): ?>
                                <p>
                                    <?php echo wp_kses_post( $settings['content'] ); ?>
                                </p>
                            <?php endif; ?> 
                            <ul class="sustainability-list">
                                <?php foreach($sustainability_item as $item_sustainability): ?>
                                    <li>
                                        <i class="ti ti-check"></i>
                                        <?php echo wp_kses_post( $item_sustainability['feature_content'] ); ?>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="sustainability-image">
                            <div class="row">
                                <div class="col-lg-6 col-md-6">
                                    <?php if( $settings['sustainability_img1']['url'] != '' ): ?>
                                        <div class="image style1">
                                            <img src="<?php echo esc_url($settings['sustainability_img1']['url'] ) ?>" alt="image">
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <div class="col-lg-6 col-md-6">
                                    <?php if( $settings['sustainability_img2']['url'] != '' ): ?>
                                        <div class="image style2">
                                            <img src="<?php echo esc_url($settings['sustainability_img2']['url'] ) ?>" alt="image">
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Sustainability Warp End -->
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Sustainability );